/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.driverlaunched;

import com.mysql.jdbc.SocketFactory;
import com.mysql.jdbc.StandardSocketFactory;
import com.mysql.management.MysqldResourceI;
import com.mysql.management.driverlaunched.MysqldFactory;
import com.mysql.management.util.FileUtil;
import com.mysql.management.util.Str;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class ServerLauncherSocketFactory
implements SocketFactory {
    public static final String SERVER_DOT = "server.";
    private static Map startedMysqlds = new HashMap();
    private static int launchCount = 0;
    private Map myMysqlds;
    private MysqldFactory resourceFactory;
    private SocketFactory socketFactory;

    public ServerLauncherSocketFactory() {
        this.setResourceFactory(new MysqldFactory.Default());
        this.setSocketFactory((SocketFactory)new StandardSocketFactory());
        this.setMyMysqlds(startedMysqlds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket connect(String host, int portNumber, Properties props) throws SocketException, IOException {
        String mapKey = host + ":" + portNumber;
        Map map = this.getStartedMysqlds();
        synchronized (map) {
            this.ensureMysqlStarted(mapKey, portNumber, props);
        }
        return this.getSocketFactory().connect(host, portNumber, props);
    }

    private void ensureMysqlStarted(final String mapKey, int port, Properties props) {
        if (this.getStartedMysqlds().containsKey(mapKey)) {
            return;
        }
        HashMap<String, String> serverOpts = new HashMap<String, String>();
        Enumeration<?> enums = props.propertyNames();
        while (enums.hasMoreElements()) {
            String key = enums.nextElement().toString();
            if (!key.startsWith(SERVER_DOT)) continue;
            serverOpts.put(key.substring(SERVER_DOT.length()), props.getProperty(key));
        }
        serverOpts.put("port", Integer.toString(port));
        File baseDir = new FileUtil().newFile(serverOpts.get("basedir"));
        MysqldResourceI mysqld = this.resourceFactory.newMysqldResource(baseDir);
        mysqld.addCompletionListenser(new Runnable(){

            public void run() {
                ServerLauncherSocketFactory.this.remove(mapKey);
            }
        });
        String threadName = "driver_launched_mysqld_" + ++launchCount;
        mysqld.start(threadName, serverOpts);
        this.getStartedMysqlds().put(mapKey, mysqld);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(String mapKey) {
        Map map = this.getStartedMysqlds();
        synchronized (map) {
            this.getStartedMysqlds().remove(mapKey);
        }
    }

    public Socket afterHandshake() throws SocketException, IOException {
        return this.getSocketFactory().afterHandshake();
    }

    public Socket beforeHandshake() throws SocketException, IOException {
        return this.getSocketFactory().beforeHandshake();
    }

    void setResourceFactory(MysqldFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    MysqldFactory getResourceFactory() {
        return this.resourceFactory;
    }

    void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    void setMyMysqlds(Map mysqldMap) {
        this.myMysqlds = mysqldMap;
    }

    Map getStartedMysqlds() {
        return this.myMysqlds;
    }

    public static void shutdown(String hostColonPort) {
        ServerLauncherSocketFactory.shutdown(hostColonPort, System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown(String hostColonPort, PrintStream out) {
        Map map = startedMysqlds;
        synchronized (map) {
            Object obj = startedMysqlds.get(hostColonPort);
            MysqldResourceI mysqld = (MysqldResourceI)obj;
            if (mysqld != null) {
                startedMysqlds.remove(hostColonPort);
                mysqld.shutdown();
            } else {
                String list = new Str().toString(startedMysqlds.keySet());
                out.println("mysqld [" + hostColonPort + "] not found in " + list);
            }
        }
    }
}

