/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.driverlaunched;

import com.mysql.jdbc.SocketFactory;
import com.mysql.management.MysqldResourceI;
import com.mysql.management.MysqldResourceTestImpl;
import com.mysql.management.driverlaunched.MysqldFactory;
import com.mysql.management.driverlaunched.ServerLauncherSocketFactory;
import java.io.File;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;

public class ServerLauncherSocketFactoryTest
extends TestCase {
    static /* synthetic */ Class class$com$mysql$jdbc$StandardSocketFactory;
    static /* synthetic */ Class class$com$mysql$management$driverlaunched$MysqldFactory$Default;

    public void testDefaultConstruction() {
        ServerLauncherSocketFactory sf = new ServerLauncherSocketFactory();
        ServerLauncherSocketFactoryTest.assertEquals((Object)(class$com$mysql$jdbc$StandardSocketFactory == null ? (class$com$mysql$jdbc$StandardSocketFactory = ServerLauncherSocketFactoryTest.class$("com.mysql.jdbc.StandardSocketFactory")) : class$com$mysql$jdbc$StandardSocketFactory), sf.getSocketFactory().getClass());
        ServerLauncherSocketFactoryTest.assertEquals((Object)(class$com$mysql$management$driverlaunched$MysqldFactory$Default == null ? (class$com$mysql$management$driverlaunched$MysqldFactory$Default = ServerLauncherSocketFactoryTest.class$("com.mysql.management.driverlaunched.MysqldFactory$Default")) : class$com$mysql$management$driverlaunched$MysqldFactory$Default), sf.getResourceFactory().getClass());
    }

    public void testComposition() throws Exception, Exception {
        ServerLauncherSocketFactory sf = new ServerLauncherSocketFactory();
        sf.setMyMysqlds(new HashMap());
        FakeSocketFactory fake = new FakeSocketFactory();
        sf.setSocketFactory(fake);
        sf.setResourceFactory(new FakeMysqldFactory());
        ServerLauncherSocketFactoryTest.assertEquals((int)0, (int)fake.connectCalled);
        ServerLauncherSocketFactoryTest.assertEquals((int)0, (int)fake.beforeHandshakeCalled);
        ServerLauncherSocketFactoryTest.assertEquals((int)0, (int)fake.afterHandshakeCalled);
        sf.connect(null, 0, new Properties());
        ServerLauncherSocketFactoryTest.assertEquals((int)1, (int)fake.connectCalled);
        ServerLauncherSocketFactoryTest.assertEquals((int)0, (int)fake.beforeHandshakeCalled);
        ServerLauncherSocketFactoryTest.assertEquals((int)0, (int)fake.afterHandshakeCalled);
        sf.beforeHandshake();
        ServerLauncherSocketFactoryTest.assertEquals((int)1, (int)fake.connectCalled);
        ServerLauncherSocketFactoryTest.assertEquals((int)1, (int)fake.beforeHandshakeCalled);
        ServerLauncherSocketFactoryTest.assertEquals((int)0, (int)fake.afterHandshakeCalled);
        sf.afterHandshake();
        ServerLauncherSocketFactoryTest.assertEquals((int)1, (int)fake.connectCalled);
        ServerLauncherSocketFactoryTest.assertEquals((int)1, (int)fake.beforeHandshakeCalled);
        ServerLauncherSocketFactoryTest.assertEquals((int)1, (int)fake.afterHandshakeCalled);
    }

    public void testMultipleConnectionsAndShutdownListener() throws Exception {
        HashMap testMysqlds = new HashMap();
        ServerLauncherSocketFactory sf = new ServerLauncherSocketFactory();
        sf.setMyMysqlds(testMysqlds);
        FakeMysqldFactory factory = new FakeMysqldFactory();
        sf.setResourceFactory(factory);
        sf.setSocketFactory(new FakeSocketFactory());
        ServerLauncherSocketFactoryTest.assertEquals((int)0, (int)factory.resources.size());
        String host = "localhost";
        int port = 3306;
        Properties props = new Properties();
        props.setProperty("foo", "bar");
        props.setProperty("server.baz", "wiz");
        ServerLauncherSocketFactoryTest.assertEquals((int)0, (int)testMysqlds.size());
        sf.connect(host, port, props);
        ServerLauncherSocketFactoryTest.assertEquals((int)1, (int)testMysqlds.size());
        MysqldResourceI mysqldResource = (MysqldResourceI)factory.resources.get(0);
        Map serverParams = mysqldResource.getServerOptions();
        ServerLauncherSocketFactoryTest.assertEquals((Object)"wiz", serverParams.get("baz"));
        ServerLauncherSocketFactoryTest.assertFalse((String)"wiz", (boolean)serverParams.containsKey("foo"));
        sf.connect(host, port, props);
        ServerLauncherSocketFactoryTest.assertEquals((int)1, (int)testMysqlds.size());
        sf.connect(host, port + 1, props);
        ServerLauncherSocketFactoryTest.assertEquals((int)2, (int)testMysqlds.size());
        String mapKey = testMysqlds.keySet().iterator().next().toString();
        MysqldResourceI mysqld = (MysqldResourceI)testMysqlds.get(mapKey);
        mysqld.shutdown();
        ServerLauncherSocketFactoryTest.assertEquals((int)1, (int)testMysqlds.size());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class FakeSocketFactory
    implements SocketFactory {
        int afterHandshakeCalled = 0;
        int beforeHandshakeCalled = 0;
        int connectCalled = 0;
        Object[] connectInfo;

        FakeSocketFactory() {
        }

        public Socket afterHandshake() {
            ++this.afterHandshakeCalled;
            return null;
        }

        public Socket beforeHandshake() {
            ++this.beforeHandshakeCalled;
            return null;
        }

        public Socket connect(String host, int portNumber, Properties props) {
            this.connectInfo = new Object[]{host, new Integer(portNumber), props};
            ++this.connectCalled;
            return null;
        }
    }

    static class FakeMysqldFactory
    implements MysqldFactory {
        List resources = new ArrayList();
        File baseDir;

        FakeMysqldFactory() {
        }

        public MysqldResourceI newMysqldResource(File base) {
            this.baseDir = base;
            MysqldResourceTestImpl newMysqldResourceI = new MysqldResourceTestImpl();
            this.resources.add(newMysqldResourceI);
            return newMysqldResourceI;
        }
    }
}

