/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.jmx;

import com.mysql.management.jmx.ConnectorMXJPropertiesTransform;
import com.mysql.management.jmx.StubTestMBeanServer;
import com.mysql.management.util.TestUtil;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import junit.framework.TestCase;

public class ConnectorMXJPropertiesTransformTest
extends TestCase {
    private static final String PORT = "3307";
    private ConnectorMXJPropertiesTransform munger;
    private TestUtil testUtil;
    static /* synthetic */ Class class$com$mysql$management$jmx$MysqldDynamicMBean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$mysql$management$jmx$SimpleMysqldDynamicMBean;
    static /* synthetic */ Class class$com$mysql$management$jmx$jboss$JBossMysqldDynamicMBean;

    protected void setUp() throws Exception {
        this.testUtil = new TestUtil();
        String[] objectNames = new String[]{"mysql:name=MySQL1"};
        Class mbeanClass = class$com$mysql$management$jmx$MysqldDynamicMBean == null ? (class$com$mysql$management$jmx$MysqldDynamicMBean = ConnectorMXJPropertiesTransformTest.class$("com.mysql.management.jmx.MysqldDynamicMBean")) : class$com$mysql$management$jmx$MysqldDynamicMBean;
        TestMBeanServer mbs = new TestMBeanServer(objectNames, mbeanClass);
        this.munger = new ConnectorMXJPropertiesTransform(mbs);
    }

    public void testGetMysqldDynamicMBean() throws Exception {
        ObjectName objName = this.munger.getMysqldObjectName();
        String name = objName.getCanonicalName();
        this.testUtil.assertContainsIgnoreCase(name, "mysql");
    }

    public void testGetHostAndPort() throws Exception {
        ConnectorMXJPropertiesTransformTest.assertEquals((String)"localhost", (String)this.munger.getHost());
        ConnectorMXJPropertiesTransformTest.assertEquals((String)PORT, (String)this.munger.getPort());
    }

    public void testTransformProperties() throws Exception {
        Properties props = new Properties();
        props.put("HOST", "foo");
        props.put("PORT", PORT);
        this.munger.transformProperties(props);
        ConnectorMXJPropertiesTransformTest.assertEquals((Object)"localhost:3307", (Object)props.get("HOST"));
        ConnectorMXJPropertiesTransformTest.assertEquals((Object)PORT, (Object)props.get("PORT"));
    }

    public void testGetMysqldObjectName() throws Exception {
        String[] objectNames = new String[]{"foo:name=foo1", "foo:name=bar1", "baz:name=baz1"};
        TestMBeanServer mbs = new TestMBeanServer(objectNames, class$java$lang$String == null ? (class$java$lang$String = ConnectorMXJPropertiesTransformTest.class$("java.lang.String")) : class$java$lang$String);
        this.munger = new ConnectorMXJPropertiesTransform(mbs);
        IllegalStateException expected = null;
        ObjectName objectName = null;
        try {
            objectName = this.munger.getMysqldObjectName();
        }
        catch (IllegalStateException e) {
            expected = e;
        }
        ConnectorMXJPropertiesTransformTest.assertNull((Object)objectName);
        ConnectorMXJPropertiesTransformTest.assertNotNull((Object)expected);
        String errMsg = expected.getMessage();
        this.testUtil.assertContainsIgnoreCase(errMsg, "foo");
        this.testUtil.assertContainsIgnoreCase(errMsg, "bar");
        this.testUtil.assertContainsIgnoreCase(errMsg, "baz");
    }

    public void testNameMatch() throws Exception {
        ConnectorMXJPropertiesTransformTest.assertFalse((boolean)this.munger.classNameMatch("foo"));
        ConnectorMXJPropertiesTransformTest.assertTrue((boolean)this.munger.classNameMatch((class$com$mysql$management$jmx$MysqldDynamicMBean == null ? (class$com$mysql$management$jmx$MysqldDynamicMBean = ConnectorMXJPropertiesTransformTest.class$("com.mysql.management.jmx.MysqldDynamicMBean")) : class$com$mysql$management$jmx$MysqldDynamicMBean).getName()));
        ConnectorMXJPropertiesTransformTest.assertTrue((boolean)this.munger.classNameMatch((class$com$mysql$management$jmx$SimpleMysqldDynamicMBean == null ? (class$com$mysql$management$jmx$SimpleMysqldDynamicMBean = ConnectorMXJPropertiesTransformTest.class$("com.mysql.management.jmx.SimpleMysqldDynamicMBean")) : class$com$mysql$management$jmx$SimpleMysqldDynamicMBean).getName()));
        ConnectorMXJPropertiesTransformTest.assertTrue((boolean)this.munger.classNameMatch((class$com$mysql$management$jmx$jboss$JBossMysqldDynamicMBean == null ? (class$com$mysql$management$jmx$jboss$JBossMysqldDynamicMBean = ConnectorMXJPropertiesTransformTest.class$("com.mysql.management.jmx.jboss.JBossMysqldDynamicMBean")) : class$com$mysql$management$jmx$jboss$JBossMysqldDynamicMBean).getName()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class TestMBeanServer
    extends StubTestMBeanServer {
        private Set objectNames = new LinkedHashSet();
        private String className;
        Object[] methodparams;

        public TestMBeanServer(String[] names, Class aClass) throws Exception {
            for (int i = 0; i < names.length; ++i) {
                this.objectNames.add(new ObjectName(names[i]));
            }
            this.className = aClass.getName();
        }

        public Set queryNames(ObjectName arg0, QueryExp arg1) {
            this.methodparams = new Object[]{arg0, arg1};
            return this.objectNames;
        }

        public ObjectInstance getObjectInstance(ObjectName arg0) {
            return new ObjectInstance(arg0, this.className);
        }

        public Object getAttribute(ObjectName arg0, String arg1) {
            if ("port".equals(arg1)) {
                return ConnectorMXJPropertiesTransformTest.PORT;
            }
            return arg1 + "? ... arg0: " + arg0;
        }
    }
}

