/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.jmx;

import com.mysql.management.MysqldResourceTestImpl;
import com.mysql.management.jmx.SimpleMysqldDynamicMBean;
import com.mysql.management.util.ClassUtil;
import com.mysql.management.util.TestUtil;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import junit.framework.TestCase;

public class SimpleMysqldDynamicMBeanTest
extends TestCase {
    static /* synthetic */ Class class$java$lang$String;

    public void testGetMBeanInfo() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("foo", "bar");
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(options);
        SimpleMysqldDynamicMBean myBean = new SimpleMysqldDynamicMBean(mysqld);
        MBeanInfo info = myBean.getMBeanInfo();
        SimpleMysqldDynamicMBeanTest.assertNotNull((Object)info);
        SimpleMysqldDynamicMBeanTest.assertEquals((String)myBean.getClass().getName(), (String)info.getClassName());
        SimpleMysqldDynamicMBeanTest.assertEquals((String)"MySQL MBean", (String)info.getDescription());
        MBeanAttributeInfo[] atts = info.getAttributes();
        SimpleMysqldDynamicMBeanTest.assertEquals((int)3, (int)atts.length);
        SimpleMysqldDynamicMBeanTest.assertEquals((String)"autostart", (String)atts[0].getName());
        SimpleMysqldDynamicMBeanTest.assertEquals((String)"", (String)atts[0].getDescription());
        SimpleMysqldDynamicMBeanTest.assertEquals((String)(class$java$lang$String == null ? (class$java$lang$String = SimpleMysqldDynamicMBeanTest.class$("java.lang.String")) : class$java$lang$String).getName(), (String)atts[0].getType());
        SimpleMysqldDynamicMBeanTest.assertTrue((boolean)atts[0].isReadable());
        SimpleMysqldDynamicMBeanTest.assertTrue((boolean)atts[0].isWritable());
        SimpleMysqldDynamicMBeanTest.assertEquals((boolean)false, (boolean)atts[0].isIs());
        SimpleMysqldDynamicMBeanTest.assertEquals((String)"foo", (String)atts[1].getName());
        SimpleMysqldDynamicMBeanTest.assertEquals((String)"", (String)atts[1].getDescription());
        SimpleMysqldDynamicMBeanTest.assertEquals((String)(class$java$lang$String == null ? (class$java$lang$String = SimpleMysqldDynamicMBeanTest.class$("java.lang.String")) : class$java$lang$String).getName(), (String)atts[1].getType());
        SimpleMysqldDynamicMBeanTest.assertTrue((boolean)atts[1].isReadable());
        SimpleMysqldDynamicMBeanTest.assertTrue((boolean)atts[1].isWritable());
        SimpleMysqldDynamicMBeanTest.assertEquals((boolean)false, (boolean)atts[1].isIs());
        MBeanConstructorInfo[] cons = info.getConstructors();
        SimpleMysqldDynamicMBeanTest.assertEquals((int)1, (int)cons.length);
        SimpleMysqldDynamicMBeanTest.assertEquals((int)0, (int)cons[0].getSignature().length);
        MBeanNotificationInfo[] notes = info.getNotifications();
        SimpleMysqldDynamicMBeanTest.assertEquals((int)0, (int)notes.length);
        MBeanOperationInfo[] ops = info.getOperations();
        SimpleMysqldDynamicMBeanTest.assertEquals((int)1, (int)ops.length);
        SimpleMysqldDynamicMBeanTest.assertEquals((String)"startMysqld", (String)ops[0].getName());
        SimpleMysqldDynamicMBeanTest.assertEquals((String)"Start MySQL", (String)ops[0].getDescription());
        SimpleMysqldDynamicMBeanTest.assertEquals((int)0, (int)ops[0].getSignature().length);
        SimpleMysqldDynamicMBeanTest.assertEquals((String)"void", (String)ops[0].getReturnType());
        SimpleMysqldDynamicMBeanTest.assertEquals((int)1, (int)ops[0].getImpact());
        myBean.invoke("startMysqld", null, null);
        info = myBean.getMBeanInfo();
        ops = info.getOperations();
        SimpleMysqldDynamicMBeanTest.assertEquals((int)1, (int)ops.length);
        SimpleMysqldDynamicMBeanTest.assertEquals((String)"stop", (String)ops[0].getName());
        SimpleMysqldDynamicMBeanTest.assertEquals((String)"Stop MySQL", (String)ops[0].getDescription());
        SimpleMysqldDynamicMBeanTest.assertEquals((int)0, (int)ops[0].getSignature().length);
        SimpleMysqldDynamicMBeanTest.assertEquals((String)"void", (String)ops[0].getReturnType());
        SimpleMysqldDynamicMBeanTest.assertEquals((int)1, (int)ops[0].getImpact());
        myBean.invoke("stop", null, null);
        info = myBean.getMBeanInfo();
        ops = info.getOperations();
        SimpleMysqldDynamicMBeanTest.assertEquals((int)1, (int)ops.length);
        SimpleMysqldDynamicMBeanTest.assertEquals((String)"startMysqld", (String)ops[0].getName());
    }

    public void testGetAttribute() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("foo", "bar");
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(options);
        SimpleMysqldDynamicMBean myBean = new SimpleMysqldDynamicMBean(mysqld);
        SimpleMysqldDynamicMBeanTest.assertEquals((Object)"bar", (Object)myBean.getAttribute("foo"));
        try {
            myBean.getAttribute("b0gus");
            SimpleMysqldDynamicMBeanTest.fail();
        }
        catch (AttributeNotFoundException e) {
            SimpleMysqldDynamicMBeanTest.assertTrue((e.getMessage().indexOf("b0gus") >= 0 ? 1 : 0) != 0);
        }
    }

    public void testGetAttributeList() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("foo", "bar");
        options.put("baz", "wiz");
        options.put("datadir", "/bogus/dir");
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(options);
        SimpleMysqldDynamicMBean myBean = new SimpleMysqldDynamicMBean(mysqld);
        AttributeList attributeList = myBean.getAttributes(new String[]{"foo", "datadir"});
        SimpleMysqldDynamicMBeanTest.assertEquals((int)2, (int)attributeList.size());
        Attribute att = (Attribute)attributeList.get(0);
        SimpleMysqldDynamicMBeanTest.assertEquals((String)"foo", (String)att.getName());
        SimpleMysqldDynamicMBeanTest.assertEquals((Object)"bar", (Object)att.getValue());
    }

    public void testGetAgentVersion() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("foo", "bar");
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(options);
        SimpleMysqldDynamicMBean myBean = new SimpleMysqldDynamicMBean(mysqld);
        String verAttName = myBean.versionAttributeName();
        String expected = "$Id: " + new ClassUtil().shortName(myBean);
        String beanVersion = (String)myBean.getAttribute(verAttName);
        new TestUtil().assertContainsIgnoreCase(beanVersion, expected);
        MBeanInfo info = myBean.getMBeanInfo();
        MBeanAttributeInfo[] atts = info.getAttributes();
        SimpleMysqldDynamicMBeanTest.assertTrue((boolean)atts[0].isReadable());
        SimpleMysqldDynamicMBeanTest.assertTrue((boolean)atts[0].isWritable());
        SimpleMysqldDynamicMBeanTest.assertFalse((boolean)atts[0].isIs());
        SimpleMysqldDynamicMBeanTest.assertTrue((boolean)atts[1].isReadable());
        SimpleMysqldDynamicMBeanTest.assertTrue((boolean)atts[1].isWritable());
        SimpleMysqldDynamicMBeanTest.assertFalse((boolean)atts[1].isIs());
        SimpleMysqldDynamicMBeanTest.assertTrue((boolean)atts[2].isReadable());
        SimpleMysqldDynamicMBeanTest.assertFalse((boolean)atts[2].isWritable());
        SimpleMysqldDynamicMBeanTest.assertFalse((boolean)atts[2].isIs());
    }

    public void testSetAttributes() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("foo", "bar");
        options.put("baz", "wiz");
        options.put("datadir", "/bogus/dir");
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(options);
        SimpleMysqldDynamicMBean myBean = new SimpleMysqldDynamicMBean(mysqld);
        AttributeList list = new AttributeList();
        list.add(new Attribute("foo", "changed"));
        list.add(new Attribute("datadir", "/changed/dir"));
        myBean.setAttributes(list);
        SimpleMysqldDynamicMBeanTest.assertEquals((Object)"changed", (Object)myBean.getAttribute("foo"));
        SimpleMysqldDynamicMBeanTest.assertEquals((Object)"wiz", (Object)myBean.getAttribute("baz"));
        SimpleMysqldDynamicMBeanTest.assertEquals((Object)"/changed/dir", (Object)myBean.getAttribute("datadir"));
    }

    public void testSetAttribute() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("foo", "bar");
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(options);
        SimpleMysqldDynamicMBean myBean = new SimpleMysqldDynamicMBean(mysqld);
        try {
            myBean.setAttribute(new Attribute("bogus", "werid"));
            SimpleMysqldDynamicMBeanTest.fail();
        }
        catch (AttributeNotFoundException e) {
            SimpleMysqldDynamicMBeanTest.assertTrue((String)e.getMessage(), (e.getMessage().indexOf("bogus") >= 0 ? 1 : 0) != 0);
        }
    }

    public void testAutoStart() throws Exception {
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl();
        SimpleMysqldDynamicMBean myBean = new SimpleMysqldDynamicMBean(mysqld);
        SimpleMysqldDynamicMBeanTest.assertFalse((boolean)mysqld.isRunning());
        String autostart = "autostart";
        String str_true = Boolean.TRUE.toString();
        myBean.setAttribute(new Attribute(autostart, str_true));
        SimpleMysqldDynamicMBeanTest.assertFalse((boolean)mysqld.isRunning());
        SimpleMysqldDynamicMBeanTest.assertFalse((boolean)mysqld.getServerOptions().containsKey(autostart));
    }

    public void testInvoke() throws Exception {
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl();
        SimpleMysqldDynamicMBean myBean = new SimpleMysqldDynamicMBean(mysqld);
        SimpleMysqldDynamicMBeanTest.assertEquals((boolean)false, (boolean)mysqld.isRunning());
        myBean.invoke("startMysqld", null, null);
        SimpleMysqldDynamicMBeanTest.assertTrue((boolean)mysqld.isRunning());
        myBean.invoke("stop", null, null);
        SimpleMysqldDynamicMBeanTest.assertEquals((boolean)false, (boolean)mysqld.isRunning());
        try {
            myBean.invoke("bogus", null, null);
            SimpleMysqldDynamicMBeanTest.fail();
        }
        catch (Exception e) {
            SimpleMysqldDynamicMBeanTest.assertTrue((e.getMessage().indexOf("bogus") >= 0 ? 1 : 0) != 0);
        }
    }

    public void testPassOptionsMapToMysqld() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("foo", "bar");
        options.put("baz", "wiz");
        options.put("datadir", "/bogus/dir");
        options.put("help", "");
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(options);
        SimpleMysqldDynamicMBean myBean = new SimpleMysqldDynamicMBean(mysqld);
        myBean.setAttribute(new Attribute("foo", "changed"));
        SimpleMysqldDynamicMBeanTest.assertTrue((boolean)myBean.attributesToOpionMap().containsKey("foo"));
        SimpleMysqldDynamicMBeanTest.assertEquals((int)1, (int)myBean.attributesToOpionMap().size());
        myBean.invoke("startMysqld", null, null);
        SimpleMysqldDynamicMBeanTest.assertEquals((Object)"changed", mysqld.getServerOptions().get("foo"));
    }

    public void testFreezeAttributes() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("foo", "bar");
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(options);
        SimpleMysqldDynamicMBean myBean = new SimpleMysqldDynamicMBean(mysqld);
        MBeanInfo info = myBean.getMBeanInfo();
        MBeanAttributeInfo[] atts = info.getAttributes();
        SimpleMysqldDynamicMBeanTest.assertTrue((boolean)atts[0].isWritable());
        myBean.freezeAttributes();
        info = myBean.getMBeanInfo();
        atts = info.getAttributes();
        SimpleMysqldDynamicMBeanTest.assertFalse((boolean)atts[0].isWritable());
    }

    public void testAttributesFrozenWhenRunning() throws ReflectionException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("foo", "bar");
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(options);
        SimpleMysqldDynamicMBean myBean = new SimpleMysqldDynamicMBean(mysqld);
        MBeanInfo info = myBean.getMBeanInfo();
        MBeanAttributeInfo[] atts = info.getAttributes();
        SimpleMysqldDynamicMBeanTest.assertTrue((boolean)atts[0].isWritable());
        myBean.invoke("startMysqld", null, null);
        info = myBean.getMBeanInfo();
        atts = info.getAttributes();
        SimpleMysqldDynamicMBeanTest.assertFalse((boolean)atts[0].isWritable());
        myBean.invoke("stop", null, null);
        info = myBean.getMBeanInfo();
        atts = info.getAttributes();
        SimpleMysqldDynamicMBeanTest.assertTrue((boolean)atts[0].isWritable());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

