/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.CausedSQLException;
import com.mysql.management.util.WrappedException;
import java.io.PrintStream;
import java.sql.SQLException;

public class Exceptions {
    private PrintStream log;

    public Exceptions() {
        this(null);
    }

    public Exceptions(PrintStream log) {
        this.log = log;
    }

    public RuntimeException toRuntime(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        String msg = e.getMessage();
        if (msg != null) {
            return new WrappedException(msg, e);
        }
        return new WrappedException(e);
    }

    public SQLException toSQLException(Exception e) {
        if (e instanceof SQLException) {
            return (SQLException)e;
        }
        return new CausedSQLException(e);
    }

    protected final void log(Exception e) {
        if (this.log != null) {
            e.printStackTrace(this.log);
        }
    }

    public static abstract class VoidBlock
    extends Exceptions {
        protected abstract void inner() throws Exception;

        public void exec() {
            try {
                this.inner();
            }
            catch (Exception e) {
                this.log(e);
                throw this.toRuntime(e);
            }
        }

        public void execSwallowingException(PrintStream err) {
            try {
                this.inner();
            }
            catch (Exception e) {
                e.printStackTrace(err);
            }
        }
    }

    public static abstract class SQLBlock
    extends Exceptions {
        public SQLBlock(PrintStream log) {
            super(log);
        }

        protected abstract Object inner() throws Exception;

        public Object exec() throws SQLException {
            try {
                return this.inner();
            }
            catch (Exception e) {
                this.log(e);
                throw this.toSQLException(e);
            }
        }
    }

    public static abstract class Block
    extends Exceptions {
        protected abstract Object inner() throws Exception;

        public Object exec() {
            try {
                return this.inner();
            }
            catch (Exception e) {
                this.log(e);
                throw this.toRuntime(e);
            }
        }
    }
}

