/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.Exceptions;
import com.mysql.management.util.NotImplementedException;
import com.mysql.management.util.WrappedException;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import junit.framework.TestCase;

public class ExceptionsTest
extends TestCase {
    Exceptions exceptions;

    protected void setUp() {
        this.exceptions = new Exceptions();
    }

    public void testToRuntime() {
        RuntimeException runtime = new RuntimeException("test");
        ExceptionsTest.assertSame((Object)runtime, (Object)this.exceptions.toRuntime(runtime));
        SQLException checkedException = new SQLException("test");
        ExceptionsTest.assertFalse((boolean)(checkedException instanceof RuntimeException));
        RuntimeException returned = this.exceptions.toRuntime(checkedException);
        ExceptionsTest.assertTrue((boolean)(returned instanceof RuntimeException));
        ExceptionsTest.assertEquals((Object)checkedException, (Object)returned.getCause());
    }

    public void testToSQLException() {
        SQLException testSQLE = new SQLException("test");
        ExceptionsTest.assertSame((Object)testSQLE, (Object)this.exceptions.toSQLException(testSQLE));
        Exception checkedException = new Exception("test");
        ExceptionsTest.assertFalse((boolean)(checkedException instanceof SQLException));
        SQLException returned = this.exceptions.toSQLException(checkedException);
        ExceptionsTest.assertTrue((boolean)(returned instanceof SQLException));
        ExceptionsTest.assertEquals((Object)checkedException, (Object)returned.getCause());
    }

    public void testReturnBlock() {
        String expected = "foo";
        Exceptions.Block block = new Exceptions.Block(){

            public Object inner() throws Exception {
                return "foo";
            }
        };
        String actual = (String)block.exec();
        ExceptionsTest.assertEquals((String)"foo", (String)actual);
    }

    public void testReturnBlockThrows() {
        Exception expected = null;
        final Exception orig = new Exception("test");
        Exceptions.Block block = new Exceptions.Block(){

            public Object inner() throws Exception {
                throw orig;
            }
        };
        try {
            block.exec();
        }
        catch (Exception e) {
            expected = e;
        }
        ExceptionsTest.assertNotNull((Object)expected);
        ExceptionsTest.assertEquals((Object)orig, (Object)expected.getCause());
    }

    public void testVoidBlock() {
        final SQLException orig = new SQLException();
        ExceptionsTest.assertNull((Object)orig.getMessage());
        WrappedException caught = null;
        Exceptions.VoidBlock block = new Exceptions.VoidBlock(){

            public void inner() throws Exception {
                throw orig;
            }
        };
        try {
            block.exec();
        }
        catch (WrappedException converted) {
            caught = converted;
        }
        ExceptionsTest.assertNotNull((Object)caught);
        ExceptionsTest.assertEquals((Object)orig, (Object)caught.getCause());
    }

    public void testRunSQLBlock() {
        ByteArrayOutputStream log = new ByteArrayOutputStream();
        String msg = "search for me";
        final Exception orig = new Exception(msg);
        SQLException caught = null;
        Exceptions.SQLBlock block = new Exceptions.SQLBlock(new PrintStream(log)){

            public Object inner() throws Exception {
                throw orig;
            }
        };
        try {
            block.exec();
        }
        catch (SQLException e) {
            caught = e;
        }
        ExceptionsTest.assertNotNull((Object)caught);
        ExceptionsTest.assertEquals((Object)orig, (Object)caught.getCause());
        ExceptionsTest.assertTrue((log.toString().indexOf(msg) >= 0 ? 1 : 0) != 0);
    }

    public void testConstructions() {
        new NotImplementedException();
        new NotImplementedException((Object)"a");
        new NotImplementedException((Object)"a", "b");
        new NotImplementedException("a", "b", "c");
        new NotImplementedException((Object)"a", "b", "c", "d");
        new NotImplementedException("a", "b", "c", "d", "e");
    }

    public void testSwallowExceptionBlockExec() {
        ByteArrayOutputStream log = new ByteArrayOutputStream();
        PrintStream fakeErr = new PrintStream(log);
        final SQLException orig = new SQLException("foo");
        Exceptions.VoidBlock block = new Exceptions.VoidBlock(){

            public void inner() throws Exception {
                throw orig;
            }
        };
        block.execSwallowingException(fakeErr);
        ExceptionsTest.assertTrue((log.toString().indexOf("foo") >= 0 ? 1 : 0) != 0);
    }
}

