/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.Shell;
import com.mysql.management.util.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;

public class FileUtil {
    public static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private Shell.Factory shellFactory;
    private char separatorChar;
    private Streams streams;

    public FileUtil() {
        this(new Shell.Factory(), File.separatorChar, new Streams());
    }

    FileUtil(Shell.Factory shellFactory, char separatorChar, Streams streams) {
        this.shellFactory = shellFactory;
        this.separatorChar = separatorChar;
        this.streams = streams;
    }

    public File tmp() {
        return new File(System.getProperty(JAVA_IO_TMPDIR));
    }

    public boolean deleteTree(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.deleteTree(files[i]);
            }
        }
        return file.delete();
    }

    public void addExecutableRights(File executable, PrintStream out, PrintStream err) {
        if (this.isWindows()) {
            return;
        }
        String[] args = new String[]{"chmod", "+x", executable.getPath()};
        String tName = "make " + executable + " runable";
        this.shellFactory.newShell(args, tName, out, err).run();
    }

    public boolean isWindows() {
        return this.separatorChar == '\\';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String asString(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            String string = this.streams.readString(fis);
            return string;
        }
        finally {
            fis.close();
        }
    }

    public File nullFile() {
        return new File("");
    }

    public File newFile(Object fileName) {
        if (fileName == null) {
            return this.nullFile();
        }
        return new File(fileName.toString());
    }
}

