/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.FileUtil;
import com.mysql.management.util.Shell;
import com.mysql.management.util.Streams;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import junit.framework.Assert;
import junit.framework.TestCase;

public class FileUtilTest
extends TestCase {
    FileUtil fileUtil;

    protected void setUp() {
        this.fileUtil = new FileUtil();
    }

    public void testTempDir() {
        String property = System.getProperty("java.io.tmpdir");
        FileUtilTest.assertNotNull((Object)property);
        File javaTmp = new File(property);
        FileUtilTest.assertEquals((String)javaTmp.getPath(), (boolean)true, (boolean)javaTmp.exists());
        FileUtilTest.assertEquals((Object)javaTmp, (Object)this.fileUtil.tmp());
    }

    public void testDeleteTree() throws FileNotFoundException {
        File foo = new File(this.fileUtil.tmp(), "foo");
        File bar = new File(foo, "bar");
        bar.mkdirs();
        FileUtilTest.assertEquals((boolean)true, (boolean)bar.exists());
        File baz = new File(foo, "baz");
        FileOutputStream fos = new FileOutputStream(baz);
        PrintWriter out = new PrintWriter(fos);
        out.print("baz");
        out.close();
        FileUtilTest.assertEquals((boolean)true, (boolean)baz.exists());
        FileUtilTest.assertEquals((long)3L, (long)baz.length());
        FileUtilTest.assertEquals((boolean)true, (boolean)this.fileUtil.deleteTree(foo));
        FileUtilTest.assertEquals((boolean)false, (boolean)foo.exists());
    }

    public void testMakeExecutable() {
        class FakeShellStub
        extends Shell.Stub {
            String[] args;
            int runCalled = 0;

            FakeShellStub() {
            }

            public void run() {
                ++this.runCalled;
            }
        }
        FakeShellStub shell = new FakeShellStub();
        class FakeShellFactory
        extends Shell.Factory {
            private final /* synthetic */ FakeShellStub val$shell;

            FakeShellFactory(FakeShellStub val$shell) {
                this.val$shell = val$shell;
            }

            public Shell newShell(String[] args, String name, PrintStream out, PrintStream err) {
                Assert.assertNotNull((Object)name);
                Assert.assertNotNull((Object)out);
                Assert.assertNotNull((Object)err);
                this.val$shell.args = args;
                return this.val$shell;
            }
        }
        this.fileUtil = new FileUtil(new FakeShellFactory(shell), '\\', new Streams());
        this.fileUtil.addExecutableRights(new File("bogus"), System.out, System.err);
        FileUtilTest.assertNull((Object)shell.args);
        FileUtilTest.assertEquals((int)0, (int)shell.runCalled);
        this.fileUtil = new FileUtil(new FakeShellFactory(shell), '/', new Streams());
        this.fileUtil.addExecutableRights(new File("bogus"), System.out, System.err);
        FileUtilTest.assertEquals((int)1, (int)shell.runCalled);
        FileUtilTest.assertEquals((int)3, (int)shell.args.length);
        FileUtilTest.assertEquals((String)"chmod", (String)shell.args[0]);
        FileUtilTest.assertEquals((String)"+x", (String)shell.args[1]);
        FileUtilTest.assertTrue((shell.args[2].indexOf("bogus") >= 0 ? 1 : 0) != 0);
    }
}

