/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.FileUtil;
import com.mysql.management.util.Shell;
import com.mysql.management.util.Str;
import com.mysql.management.util.Streams;
import com.mysql.management.util.Threads;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;

public final class ProcessUtil {
    private String pid;
    private PrintStream out;
    private PrintStream err;
    private String killCommand;
    private Str str;
    private FileUtil fileUtil;
    private Shell.Factory shellFactory;
    private Streams streams;
    private Threads threads;

    public ProcessUtil(String pid, PrintStream out, PrintStream err) {
        this(new FileUtil(), pid, out, err, new Str(), new Shell.Factory(), new Streams(), new Threads());
    }

    ProcessUtil(FileUtil fileUtil, String pid, PrintStream out, PrintStream err, Str str, Shell.Factory shellFactory, Streams streams, Threads threads) {
        this.pid = pid != null ? pid.trim() : "-1";
        this.out = out;
        this.err = err;
        this.fileUtil = fileUtil;
        this.str = str;
        this.shellFactory = shellFactory;
        this.streams = streams;
        this.threads = threads;
        this.killCommand = fileUtil.isWindows() ? this.getWindowsKillFile().getPath() : "kill";
    }

    final File getWindowsKillFile() {
        File parent = new File(this.fileUtil.tmp(), "c-mxj-utils");
        File kill = new File(parent, "kill.exe");
        if (!kill.exists()) {
            this.streams.createFileFromResource("kill.exe", kill);
        }
        return kill;
    }

    String pid() {
        return this.pid;
    }

    public void kill() {
        this.kill(false);
    }

    public void forceKill() {
        this.kill(true);
    }

    private void kill(boolean force) {
        String threadName = "killing process " + this.pid;
        if (force) {
            threadName = "force " + threadName;
        }
        this.launchShell(threadName, this.killArgs(force), 10);
    }

    String[] killArgs(boolean force) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.killCommand);
        if (force) {
            args.add("-9");
        }
        args.add(this.pid);
        return this.str.toStringArray(args);
    }

    public boolean isRunning() {
        String threadName = "is_process_" + this.pid + "_running";
        Shell shell = this.launchShell(threadName, this.isRunningArgs(), 5);
        if (!shell.hasReturned()) {
            return false;
        }
        return shell.returnCode() == 0;
    }

    private Shell launchShell(String threadName, String[] args, int seconds) {
        Shell shell = this.shellFactory.newShell(args, threadName, this.out, this.err);
        shell.start();
        int fraction = 20;
        int loops = fraction * seconds;
        do {
            this.threads.pause(1000 / fraction);
        } while (!shell.hasReturned() && loops-- > 0);
        if (!shell.hasReturned()) {
            this.err.println("Thread \"" + threadName + "\" may be hung");
            this.err.println("(did not return after " + seconds + " seconds)");
            this.err.println("command line used: ");
            this.err.println(this.str.toString(Arrays.asList(args), "", " ", ""));
        }
        return shell;
    }

    String[] isRunningArgs() {
        return new String[]{this.killCommand, "-0", this.pid};
    }
}

