/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.FileUtil;
import com.mysql.management.util.ProcessUtil;
import com.mysql.management.util.Str;
import com.mysql.management.util.Streams;
import com.mysql.management.util.TestUtil;
import java.io.File;
import junit.framework.TestCase;

public class ProcessUtilTest
extends TestCase {
    public void testNullPid() {
        ProcessUtil kp = new ProcessUtil(null, null, null);
        ProcessUtilTest.assertEquals((String)"-1", (String)kp.pid());
    }

    public void testPidWithEOL() {
        String pid = " 3343\n";
        ProcessUtil kp = new ProcessUtil(pid, null, null);
        ProcessUtilTest.assertEquals((String)"3343", (String)kp.pid());
    }

    public void testKillCommandLineUnix() {
        FileUtil fu = new FileUtil(){

            public boolean isWindows() {
                return false;
            }
        };
        String pid = "2342";
        ProcessUtil kp = new ProcessUtil(fu, pid, null, null, new Str(), null, null, null);
        String[] args = kp.killArgs(false);
        ProcessUtilTest.assertEquals((String)args[0], (String)"kill");
        ProcessUtilTest.assertEquals((String)pid, (String)args[args.length - 1]);
    }

    public void testKillCommandLineWindows() {
        FileUtil fu = new FileUtil(){

            public boolean isWindows() {
                return true;
            }
        };
        String pid = "2342";
        ProcessUtil kp = new ProcessUtil(fu, pid, null, null, new Str(), null, new Streams(), null);
        String[] args = kp.killArgs(false);
        ProcessUtilTest.assertTrue((String)args[0], (boolean)args[0].endsWith("kill.exe"));
        ProcessUtilTest.assertEquals((String)pid, (String)args[args.length - 1]);
    }

    public void testForce() {
        ProcessUtil kp = new ProcessUtil("4321", null, null);
        String[] args = kp.killArgs(true);
        ProcessUtilTest.assertEquals((String)"-9", (String)args[1]);
    }

    public void testIsRunning() {
        String pid = "5234";
        ProcessUtil kp = new ProcessUtil(pid, null, null);
        String[] args = kp.isRunningArgs();
        new TestUtil().assertContainsIgnoreCase(args[0], "kill");
        ProcessUtilTest.assertEquals((String)"-0", (String)args[1]);
        ProcessUtilTest.assertEquals((String)pid, (String)args[2]);
    }

    public void testFileCreation() {
        ProcessUtil pu = new ProcessUtil("1234", null, null);
        File winKill = pu.getWindowsKillFile();
        ProcessUtilTest.assertTrue((boolean)winKill.exists());
        winKill.delete();
        ProcessUtilTest.assertFalse((boolean)winKill.exists());
        winKill = pu.getWindowsKillFile();
        ProcessUtilTest.assertTrue((boolean)winKill.exists());
    }
}

