/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.FileUtil;
import com.mysql.management.util.QuietTestCase;
import com.mysql.management.util.RuntimeI;
import com.mysql.management.util.Shell;
import com.mysql.management.util.TestStubProcess;
import com.mysql.management.util.TestUtil;
import com.mysql.management.util.Threads;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import junit.framework.Assert;

public class ShellTest
extends QuietTestCase {
    private Shell.Default shell;
    private int shellName = 0;
    private TestProcess testProcess;
    private int processSleep = 0;
    static /* synthetic */ Class class$com$mysql$management$util$Shell;

    protected void setUp() {
        super.setUp();
        this.processSleep = 0;
        String[] commandLineArgs = new String[]{"java"};
        String threadName = "ShellTest" + this.shellName++;
        this.shell = new Shell.Default(commandLineArgs, threadName, System.out, System.err);
        this.setRuntime(0);
    }

    private void setRuntime(final int returnCode) {
        RuntimeI.Stub fakeRuntime = new RuntimeI.Stub(){

            public Process exec(String[] cmdarray, String[] envp, File dir) {
                Assert.assertNotNull((Object)cmdarray);
                Assert.assertNull((Object)envp);
                Assert.assertNull((Object)dir);
                ShellTest.this.testProcess = new TestProcess(returnCode, ShellTest.this.processSleep);
                return ShellTest.this.testProcess;
            }
        };
        this.shell.setRuntime(fakeRuntime);
    }

    public void testCompletionListener() {
        IllegalArgumentException expected = null;
        try {
            this.shell.addCompletionListener(null);
        }
        catch (IllegalArgumentException e) {
            expected = e;
        }
        ShellTest.assertNotNull((Object)expected);
        class TestListener
        implements Runnable {
            int timesRun = 0;

            TestListener() {
            }

            public void run() {
                ++this.timesRun;
            }
        }
        TestListener listener = new TestListener();
        this.shell.addCompletionListener(listener);
        this.shell.run();
        for (int c = 0; c < 5 && listener.timesRun == 0; ++c) {
            new Threads().pause(10);
        }
        ShellTest.assertEquals((int)1, (int)listener.timesRun);
    }

    public void testShellReturnsWithReturnCode() {
        int returnCode = 7;
        this.setRuntime(returnCode);
        this.shell.run();
        ShellTest.assertTrue((boolean)this.shell.hasReturned());
        ShellTest.assertEquals((int)returnCode, (int)this.shell.returnCode());
    }

    public void testSetters() {
        this.shell.setRuntime(new RuntimeI.Default());
        this.shell.setEnvironment(new String[0]);
        this.shell.setWorkingDir(new FileUtil().tmp());
        this.shell.run();
        ShellTest.assertTrue((boolean)this.shell.hasReturned());
        ShellTest.assertEquals((int)1, (int)this.shell.returnCode());
    }

    public void testDoubleRun() {
        this.processSleep = 2000;
        this.shell.start();
        new Threads().pause(20);
        IllegalStateException expected = null;
        try {
            this.shell.run();
        }
        catch (IllegalStateException e) {
            expected = e;
        }
        ShellTest.assertNotNull((Object)expected);
    }

    public void testShellThrowsIfNotYetReturned() {
        ShellTest.assertFalse((boolean)this.shell.hasReturned());
        Exception expected = null;
        try {
            this.shell.returnCode();
        }
        catch (Exception e) {
            expected = e;
        }
        ShellTest.assertNotNull((String)"Should have throws", (Object)expected);
    }

    public void testDestroy() throws Exception {
        this.processSleep = 2000;
        ShellTest.assertNull((Object)this.testProcess);
        this.shell.start();
        new Threads().pause(20);
        this.shell.destroyProcess();
        ShellTest.assertEquals((int)1, (int)this.testProcess.destroyCalled);
    }

    public void testForThrownExceptions() throws Exception {
        this.shell = new Shell.Default(null, "foo", null, null);
        Exception expected = null;
        try {
            this.shell.run();
        }
        catch (Exception e) {
            expected = e;
        }
        ShellTest.assertNotNull((Object)expected);
    }

    public void testStub() throws Exception {
        final Method[] methods = (class$com$mysql$management$util$Shell == null ? (class$com$mysql$management$util$Shell = ShellTest.class$("com.mysql.management.util.Shell")) : class$com$mysql$management$util$Shell).getDeclaredMethods();
        final Shell.Stub stub = new Shell.Stub();
        final TestUtil testUtil = new TestUtil();
        int i = 0;
        while (i < methods.length) {
            final int x = i++;
            testUtil.assertNotImplemented(new TestUtil.Block(){

                public void exec() throws Exception {
                    testUtil.invoke(stub, methods[x]);
                }
            });
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class TestProcess
    extends TestStubProcess {
        private int returnCode;
        int destroyCalled;
        int sleep;

        public TestProcess(int returnCode, int sleep) {
            this.returnCode = returnCode;
            this.destroyCalled = 0;
            this.sleep = sleep;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(new byte[0]);
        }

        public InputStream getErrorStream() {
            return new ByteArrayInputStream(new byte[0]);
        }

        public int waitFor() {
            new Threads().pause(this.sleep);
            return this.returnCode;
        }

        public void destroy() {
            ++this.destroyCalled;
        }
    }
}

