/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.Exceptions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.MissingResourceException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public final class Streams {
    public static final String RESOURCE_SEPARATOR = "/";
    private static final int END_OF_STREAM = -1;
    private Exceptions exceptions = new Exceptions();

    public void copy(InputStream from, OutputStream to) throws IOException {
        this.copy(from, to, true, false);
    }

    void copy(InputStream from, OutputStream to, boolean buffer, boolean terminateOnFailure) throws IOException {
        block5: {
            if (buffer) {
                from = new BufferedInputStream(from);
                to = new BufferedOutputStream(to);
            }
            try {
                int i;
                while ((i = from.read()) != -1) {
                    to.write(i);
                }
            }
            catch (Exception e) {
                if (terminateOnFailure) break block5;
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw this.exceptions.toRuntime(e);
            }
        }
        to.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readString(InputStream from) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            this.copy(from, buf);
            String string = buf.toString();
            return string;
        }
        finally {
            buf.close();
        }
    }

    public InputStream getResourceAsStream(String name) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return this.getResourceAsStream(classLoader, name);
    }

    public InputStream getResourceAsStream(ClassLoader classLoader, String name) {
        InputStream is = classLoader.getResourceAsStream(name);
        if (is == null) {
            String msg = "Resource '" + name + "' not found";
            throw new MissingResourceException(msg, null, name);
        }
        return is;
    }

    public void createFileFromResource(final String resourceName, final File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        Exceptions.VoidBlock block = new Exceptions.VoidBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void inner() throws Exception {
                InputStream is = Streams.this.getResourceAsStream(resourceName);
                try {
                    FileOutputStream fos = new FileOutputStream(file);
                    try {
                        Streams.this.copy(is, fos);
                    }
                    finally {
                        fos.close();
                    }
                }
                finally {
                    is.close();
                }
            }
        };
        block.exec();
    }

    public void expandResourceJar(final File outputDir, final String jarResourceName) {
        Exceptions.VoidBlock block = new Exceptions.VoidBlock(){

            public void inner() throws Exception {
                Streams.this.expandResourceJarInner(outputDir, jarResourceName);
            }
        };
        block.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandResourceJarInner(File outputDir, String jarResourceName) throws IOException {
        InputStream is = this.getResourceAsStream(jarResourceName);
        try {
            JarInputStream jis = new JarInputStream(is);
            try {
                this.expandEachEntry(outputDir, jis);
            }
            finally {
                jis.close();
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandEachEntry(File outputDir, JarInputStream jis) throws IOException, FileNotFoundException {
        JarEntry entry = jis.getNextJarEntry();
        while (entry != null) {
            File file = new File(outputDir, entry.getName());
            if (!file.exists()) {
                if (entry.isDirectory()) {
                    file.mkdirs();
                } else {
                    File parent = file.getParentFile();
                    parent.mkdirs();
                    FileOutputStream fos = new FileOutputStream(file);
                    try {
                        this.copy(jis, fos);
                    }
                    finally {
                        fos.close();
                    }
                }
            }
            entry = jis.getNextJarEntry();
        }
    }
}

