import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class TestDb {
    private String driver;

    private String url;

    private String user;

    private String password;

    public TestDb(String driver, String url, String user, String password) {
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public Connection connection() throws Exception {
        Class.forName(driver);
        return DriverManager.getConnection(url, user, password);
    }

    public void printResults(String query, PrintStream out) throws Exception {
        out.println("driver: " + driver);
        out.println("url: " + url);
        out.println("user: " + user);
        out.println("password: " + password);
        out.println("query: " + query);
        out.println();
        Connection conn = connection();
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(query);
            int columns = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                for (int i = 1; i <= columns; i++) {
                    out.println(rs.getString(i));
                }
                out.println();
            }
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            conn.close();
        }
    }

    public static void main(String[] args) throws Exception {
        String driver = (args.length > 0) ? args[0] : "com.mysql.jdbc.Driver";
        String url = (args.length > 1) ? args[1] : "jdbc:mysql:///test";
        String user = (args.length > 2) ? args[2] : "root";
        String password = (args.length > 3) ? args[3] : "";
        String query = (args.length > 4) ? args[4] : "SELECT VERSION()";

        TestDb testDb = new TestDb(driver, url, user, password);
        testDb.printResults(query, System.out);
    }
}
