package com.mysql.management.util;

import java.io.File;
import java.io.PrintStream;

import junit.framework.TestCase;

public class ProcessUtilTest extends TestCase {
    private File dir = new File(new Files().testDir(), "ProcUtiTest");

    private PrintStream devNull = new NullPrintStream();

    public void testNullPid() {
        ProcessUtil kp = new ProcessUtil(null, devNull, devNull, dir);
        assertEquals("-1", kp.pid());
    }

    public void testPidWithEOL() {
        String pid = " 3343\n";
        ProcessUtil kp = new ProcessUtil(pid, devNull, devNull, dir);
        assertEquals("3343", kp.pid());
    }

    public void testKillCommandLineUnix() {
        Utils utils = new Utils();
        utils.setFiles(new Files() {
            public boolean isWindows() {
                return false;
            }
        });
        String pid = "2342";
        ProcessUtil kp = new ProcessUtil(pid, devNull, devNull, dir, utils);
        String[] args = kp.killArgs(false);
        assertEquals(args[0], "kill");
        assertEquals(pid, args[args.length - 1]);
    }

    public void testKillCommandLineWindows() {
        Utils utils = new Utils();
        utils.setFiles(new Files() {
            public boolean isWindows() {
                return true;
            }
        });
        String pid = "2342";
        ProcessUtil kp = new ProcessUtil(pid, devNull, devNull, dir, utils);
        String[] args = kp.killArgs(false);
        assertTrue(args[0], args[0].endsWith("kill.exe"));
        assertEquals(pid, args[args.length - 1]);
    }

    public void testForce() {
        ProcessUtil kp = new ProcessUtil("4321", devNull, devNull, dir);
        String[] args = kp.killArgs(true);
        assertEquals("-9", args[1]);
    }

    public void testIsRunning() {
        String pid = "5234";
        ProcessUtil kp = new ProcessUtil(pid, devNull, devNull, dir);
        String[] args = kp.isRunningArgs();
        new TestUtil().assertContainsIgnoreCase(args[0], "kill");
        assertEquals("-0", args[1]);
        assertEquals(pid, args[2]);
    }

    public void testFileCreation() {
        ProcessUtil pu = new ProcessUtil("1234", devNull, devNull, dir);
        File winKill;
        winKill = pu.getWindowsKillFile();
        assertTrue(winKill.exists());
        winKill.delete();
        assertFalse(winKill.exists());
        winKill = pu.getWindowsKillFile();
        assertTrue(winKill.exists());
    }
}