/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management;

import com.mysql.jdbc.Driver;
import com.mysql.management.MysqldResource;
import com.mysql.management.MysqldResourceI;
import com.mysql.management.trace.Tracer;
import com.mysql.management.util.Files;
import com.mysql.management.util.QuietTestCase;
import com.mysql.management.util.Str;
import com.mysql.management.util.TestUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import junit.framework.Assert;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class AcceptanceTest
extends QuietTestCase {
    private Connection conn = null;
    private Statement stmt = null;
    private ResultSet rs = null;
    private File tmpDir;
    private MysqldResourceI mysqld;
    private Files fileUtil;
    static /* synthetic */ Class class$0;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;

    protected void setUp() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        super.setUp();
        this.fileUtil = new Files();
        this.tmpDir = new Files().testDir();
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    protected void tearDown() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        super.tearDown();
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (this.stmt != null) {
            try {
                this.stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.conn = null;
        }
        if (this.mysqld != null) {
            try {
                this.mysqld.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Object var3_7 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var3_7, joinPoint);
    }

    public void testMain() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        TestUtil testUtil = new TestUtil();
        int port1 = testUtil.testPort();
        File baseDir1 = new File(this.tmpDir, "cmxj-dir.1");
        String url1 = "jdbc:mysql://127.0.0.1:" + port1 + "/test";
        String[] startArgs1 = new String[]{"--port=" + port1, "--basedir=" + baseDir1};
        String[] stopArgs1 = new String[]{"--basedir=" + baseDir1, "--shutdown"};
        MysqldResource.main(startArgs1);
        int port2 = port1 + 1000;
        String url2 = "jdbc:mysql://127.0.0.1:" + port2 + "/test";
        File baseDir2 = new File(this.tmpDir, "cmxj-dir.2");
        String[] startArgs2 = new String[]{"--port=" + port2, "--basedir=" + baseDir2};
        String[] stopArgs2 = new String[]{"--basedir=" + baseDir2, "--shutdown"};
        MysqldResource.main(startArgs2);
        testUtil.assertConnectViaJDBC(url1);
        testUtil.assertConnectViaJDBC(url2);
        MysqldResource.main(stopArgs1);
        testUtil.assertConnectViaJDBC(url2);
        SQLException expected = null;
        try {
            testUtil.assertConnectViaJDBC(url1);
        }
        catch (SQLException e) {
            expected = e;
        }
        Assert.assertNotNull((Object)expected);
        MysqldResource.main(stopArgs2);
        expected = null;
        try {
            testUtil.assertConnectViaJDBC(url2);
        }
        catch (SQLException e) {
            expected = e;
        }
        Assert.assertNotNull((Object)expected);
        Object var15_16 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var15_16, joinPoint);
    }

    public void testCreateUser() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        File baseDir3 = new File(this.tmpDir, "mxj-user-test");
        this.fileUtil.deleteTree(baseDir3);
        this.mysqld = new MysqldResource(baseDir3);
        baseDir3.mkdirs();
        HashMap<String, String> params = new HashMap<String, String>();
        int port = new TestUtil().testPort();
        params.put("port", Integer.toString(port));
        this.mysqld.start("mxj-user-test", params);
        String url = "jdbc:mysql://localhost:" + port + "/";
        String rootUser = "root";
        String rootPassword = "";
        this.makeDb(String.valueOf(url) + "test", rootUser, rootPassword);
        this.checkVersion(this.mysqld.getVersion());
        this.conn.close();
        this.conn = null;
        Driver driver = new Driver();
        Properties props = new Properties();
        props.setProperty("user", "JAVA");
        props.setProperty("password", "SAPR3");
        Exception exception = null;
        try {
            this.conn = driver.connect(String.valueOf(url) + "MY1", props);
        }
        catch (Exception e) {
            exception = e;
        }
        Assert.assertNull((String)("" + exception), (Object)exception);
        this.checkVersion(this.mysqld.getVersion());
        Object var12_12 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var12_12, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void checkVersion(String string) throws SQLException {
        void version;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.stmt = this.conn.createStatement();
        this.rs = this.stmt.executeQuery("SELECT VERSION()");
        int cols = this.rs.getMetaData().getColumnCount();
        Assert.assertTrue((boolean)this.rs.next());
        Assert.assertTrue((cols >= 1 ? 1 : 0) != 0);
        String searchIn = this.rs.getString(1);
        Assert.assertTrue((String)("<" + (String)version + "> not found in <" + searchIn + ">"), (boolean)new Str().containsIgnoreCase(searchIn, (String)version));
        Assert.assertEquals((int)cols, (int)1);
        Assert.assertFalse((boolean)this.rs.next());
        this.rs.close();
        this.stmt.close();
        Object var6_6 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var6_6, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void makeDb(String string, String string2, String string3) throws Exception {
        void password;
        void userName;
        void url;
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        Object[] objectArray = new Object[]{string4, string5, string6};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        new TestUtil().assertConnectViaJDBC((String)url, (String)userName, (String)password, true);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.mysql.jdbc.Driver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class.forName(clazz.getName());
        this.conn = DriverManager.getConnection((String)url, (String)userName, (String)password);
        this.stmt = this.conn.createStatement();
        this.stmt.execute("CREATE DATABASE MY1");
        this.stmt.execute("USE MY1");
        String sql = "GRANT ALL PRIVILEGES ON MY1.* TO 'JAVA'@'%' IDENTIFIED BY 'SAPR3' WITH GRANT OPTION";
        this.stmt.execute(sql);
        sql = "GRANT ALL PRIVILEGES ON MY1.* TO 'JAVA'@'localhost' IDENTIFIED BY 'SAPR3' WITH GRANT OPTION";
        this.stmt.execute(sql);
        this.stmt.execute("commit");
        this.stmt.close();
        Object var10_10 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var10_10, joinPoint);
    }

    static {
        Factory factory = new Factory("AcceptanceTest.java", Class.forName("com.mysql.management.AcceptanceTest"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-setUp-com.mysql.management.AcceptanceTest----void-"), 54);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-tearDown-com.mysql.management.AcceptanceTest----void-"), 60);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testMain-com.mysql.management.AcceptanceTest---java.lang.Exception:-void-"), 95);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testCreateUser-com.mysql.management.AcceptanceTest---java.lang.Exception:-void-"), 145);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkVersion-com.mysql.management.AcceptanceTest-java.lang.String:-version:-java.sql.SQLException:-void-"), 184);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-makeDb-com.mysql.management.AcceptanceTest-java.lang.String:java.lang.String:java.lang.String:-url:userName:password:-java.lang.Exception:-void-"), 200);
    }
}

