/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management;

import com.mysql.management.HelpOptionsParser;
import com.mysql.management.trace.Tracer;
import com.mysql.management.util.ListToString;
import com.mysql.management.util.Streams;
import com.mysql.management.util.Utils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class HelpOptionsParserTest
extends TestCase {
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;

    public void testOptionParser() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String resourceVersionDir = "5.0.21".replaceAll("\\.", "-");
        Assert.assertEquals((String)"5-0-21", (String)resourceVersionDir);
        String sampleHelp = String.valueOf(resourceVersionDir) + "/com/mysql/management/MySQL_Help.txt";
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        InputStream is = cl.getResourceAsStream(sampleHelp);
        String help = new Streams().readString(is);
        is.close();
        HelpOptionsParser parser = new HelpOptionsParser(System.err, new Utils());
        Map parsed = parser.getOptionsFromHelp(help);
        String optStr = new ListToString().toString(parsed);
        Assert.assertEquals((String)optStr, (Object)"TRUE", parsed.get("auto-rehash"));
        Object var10_10 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var10_10, joinPoint);
    }

    public void testTrimOptionsErrorMsg() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HelpOptionsParser parser = new HelpOptionsParser(new PrintStream(out), new Utils());
        Exception expected = null;
        try {
            parser.trimToOptions("bogus");
        }
        catch (Exception e) {
            expected = e;
        }
        Assert.assertNotNull((Object)expected);
        String errMsg = new String(out.toByteArray());
        Assert.assertTrue((errMsg.indexOf("bogus") >= 0 ? 1 : 0) != 0);
        Object var6_7 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var6_7, joinPoint);
    }

    public void testOptionParserSupportIssue8601() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String text = "support-issue-8601-help-output.txt";
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        InputStream is = cl.getResourceAsStream(text);
        String help = new Streams().readString(is);
        is.close();
        HelpOptionsParser parser = new HelpOptionsParser(System.err, new Utils());
        Map parsed = parser.getOptionsFromHelp(help);
        Assert.assertEquals((Object)"FALSE", parsed.get("allow-suspicious-udfs"));
        Object var8_8 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var8_8, joinPoint);
    }

    static {
        Factory factory = new Factory("HelpOptionsParserTest.java", Class.forName("com.mysql.management.HelpOptionsParserTest"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testOptionParser-com.mysql.management.HelpOptionsParserTest---java.lang.Exception:-void-"), 40);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testTrimOptionsErrorMsg-com.mysql.management.HelpOptionsParserTest----void-"), 65);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testOptionParserSupportIssue8601-com.mysql.management.HelpOptionsParserTest---java.lang.Exception:-void-"), 80);
    }
}

