/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management;

import com.mysql.management.HelpOptionsParser;
import com.mysql.management.MysqldResourceI;
import com.mysql.management.trace.Tracer;
import com.mysql.management.util.CommandLineOptionsParser;
import com.mysql.management.util.Files;
import com.mysql.management.util.ListToString;
import com.mysql.management.util.NullPrintStream;
import com.mysql.management.util.ProcessUtil;
import com.mysql.management.util.Shell;
import com.mysql.management.util.Threads;
import com.mysql.management.util.Utils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public final class MysqldResource
implements MysqldResourceI {
    public static final String MYSQL_C_MXJ = "mysql-c.mxj";
    public static final String DATA = "data";
    private String versionString;
    private Map options;
    private Shell shell;
    private File baseDir;
    private File dataDir;
    private File pidFile;
    private String msgPrefix;
    private String pid;
    private String osName;
    private String osArch;
    private PrintStream out;
    private PrintStream err;
    private Exception trace;
    private int killDelay;
    private List completionListensers;
    private boolean readyForConnections;
    private HelpOptionsParser optionParser;
    private Utils utils;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;
    private static final JoinPoint.StaticPart ajc$tjp_16;
    private static final JoinPoint.StaticPart ajc$tjp_17;
    private static final JoinPoint.StaticPart ajc$tjp_18;
    private static final JoinPoint.StaticPart ajc$tjp_19;
    private static final JoinPoint.StaticPart ajc$tjp_20;
    private static final JoinPoint.StaticPart ajc$tjp_21;
    private static final JoinPoint.StaticPart ajc$tjp_22;
    private static final JoinPoint.StaticPart ajc$tjp_23;
    private static final JoinPoint.StaticPart ajc$tjp_24;
    private static final JoinPoint.StaticPart ajc$tjp_25;
    private static final JoinPoint.StaticPart ajc$tjp_26;
    private static final JoinPoint.StaticPart ajc$tjp_27;
    private static final JoinPoint.StaticPart ajc$tjp_28;
    private static final JoinPoint.StaticPart ajc$tjp_29;
    private static final JoinPoint.StaticPart ajc$tjp_30;
    private static final JoinPoint.StaticPart ajc$tjp_31;
    private static final JoinPoint.StaticPart ajc$tjp_32;
    private static final JoinPoint.StaticPart ajc$tjp_33;
    private static final JoinPoint.StaticPart ajc$tjp_34;
    private static final JoinPoint.StaticPart ajc$tjp_35;
    private static final JoinPoint.StaticPart ajc$tjp_36;
    private static final JoinPoint.StaticPart ajc$tjp_37;
    private static final JoinPoint.StaticPart ajc$tjp_38;
    private static final JoinPoint.StaticPart ajc$tjp_39;
    private static final JoinPoint.StaticPart ajc$tjp_40;
    private static final JoinPoint.StaticPart ajc$tjp_41;
    private static final JoinPoint.StaticPart ajc$tjp_42;
    private static final JoinPoint.StaticPart ajc$tjp_43;
    private static final JoinPoint.StaticPart ajc$tjp_44;
    private static final JoinPoint.StaticPart ajc$tjp_45;
    private static final JoinPoint.StaticPart ajc$tjp_46;
    private static final JoinPoint.StaticPart ajc$tjp_47;
    private static final JoinPoint.StaticPart ajc$tjp_48;
    private static final JoinPoint.StaticPart ajc$tjp_49;
    private static final JoinPoint.StaticPart ajc$tjp_50;
    private static final JoinPoint.StaticPart ajc$tjp_51;

    public MysqldResource() {
        this(new Files().nullFile());
    }

    public MysqldResource(File baseDir) {
        this(baseDir, new Files().nullFile(), "5.0.21", System.out, System.err);
    }

    public MysqldResource(File baseDir, File dataDir) {
        this(baseDir, dataDir, "5.0.21", System.out, System.err);
    }

    public MysqldResource(File baseDir, File dataDir, String mysqlVersionString) {
        this(baseDir, dataDir, mysqlVersionString, System.out, System.err);
    }

    public MysqldResource(File baseDir, File dataDir, String mysqlVersionString, PrintStream out, PrintStream err) {
        this(baseDir, dataDir, mysqlVersionString, out, err, new Utils());
    }

    MysqldResource(File baseDir, File dataDir, String mysqlVersionString, PrintStream out, PrintStream err, Utils util) {
        this.out = out;
        this.err = err;
        this.utils = util;
        this.optionParser = new HelpOptionsParser(err, this.utils);
        this.killDelay = 30000;
        this.baseDir = this.utils.files().validCononicalDir(baseDir, this.utils.files().tmp(MYSQL_C_MXJ));
        this.dataDir = this.utils.files().validCononicalDir(dataDir, new File(this.baseDir, DATA));
        this.setVersion(false, mysqlVersionString);
        this.pidFile = null;
        this.msgPrefix = "[" + this.utils.str().shortClassName(this.getClass()) + "] ";
        this.options = new HashMap();
        this.setShell(null);
        this.setOsAndArch(System.getProperty("os.name"), System.getProperty("os.arch"));
        this.completionListensers = new ArrayList();
        this.initTrace();
    }

    private void initTrace() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.trace = new Exception();
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void start(String string, Map map) {
        String string2 = string;
        Map map2 = map;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string2, (Object)map2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.getShell() != null || this.processRunning()) {
            this.printMessage("mysqld already running (process: " + this.pid() + ")");
        } else {
            void threadName;
            void mysqldArgs;
            mysqldArgs.remove("mysql-version");
            this.options = this.optionParser.getOptionsFromHelp(this.getHelp((Map)mysqldArgs));
            this.out.flush();
            this.addCompletionListenser(new Runnable(){
                private static final JoinPoint.StaticPart ajc$tjp_0;

                public void run() {
                    JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
                    MysqldResource.access$0(MysqldResource.this, false);
                    MysqldResource.this.setShell(null);
                    MysqldResource.access$1(MysqldResource.this).remove(this);
                    Object var2_2 = null;
                    Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
                }

                static {
                    Factory factory = new Factory("MysqldResource.java", Class.forName("com.mysql.management.MysqldResource$1"));
                    ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-com.mysql.management.MysqldResource$1----void-"), 162);
                }
            });
            this.setShell(this.exec((String)threadName, (Map)mysqldArgs, this.out, this.err, true));
            this.reportPid();
            int port = 3306;
            Object portArg = mysqldArgs.get("port");
            if (portArg != null) {
                port = Integer.parseInt(portArg.toString());
            }
            int triesBeforeGivingUp = this.killDelay / 1000 * 4;
            boolean ready = this.canConnectToServer(port, triesBeforeGivingUp);
            this.setReadyForConnection(ready);
        }
        Object var10_10 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var10_10, joinPoint);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean canConnectToServer(int var1_1, int var2_2) {
        var14_3 = var1_1;
        var15_4 = var2_2;
        var13_5 = Factory.makeJP((JoinPoint.StaticPart)MysqldResource.ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.intObject((int)var14_3), (Object)Conversions.intObject((int)var15_4));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(var13_5);
        v0 = this.utils.str();
        v1 = MysqldResource.class$0;
        if (v1 == null) {
            try {
                v2 = Class.forName("com.mysql.jdbc.Driver");
            }
            catch (ClassNotFoundException v3) {
                throw new NoClassDefFoundError(v3.getMessage());
            }
            v1 = MysqldResource.class$0 = v2;
        }
        v0.classForName(v1.getName());
        conn = null;
        timeoutMilis = 250;
        bogusUser = "Connector/MXJ";
        password = "Bogus Password";
        url = "jdbc:mysql://localhost:" + (int)port + "/test" + "?connectTimeout=" + timeoutMilis;
        i = 0;
        while (true) {
            block22: {
                block19: {
                    block21: {
                        if (i >= triesBeforeGivingUp) {
                            v4 = false;
                            break;
                        }
                        try {
                            try {
                                conn = DriverManager.getConnection(url, bogusUser, password);
                                var10_12 = null;
                            }
                            catch (SQLException e) {
                                if (e.getErrorCode() != 1045) break block19;
                                var10_12 = null;
                                try {
                                    if (conn != null) {
                                        conn.close();
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                v4 = true;
                                break;
                            }
                        }
                        catch (Throwable var11_15) {
                            var10_12 = null;
                            ** try [egrp 3[TRYBLOCK] [1 : 190->203)] { 
lbl49:
                            // 1 sources

                            if (conn == null) throw var11_15;
                            conn.close();
                            throw var11_15;
lbl52:
                            // 1 sources

                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            throw var11_15;
                        }
                        ** try [egrp 3[TRYBLOCK] [1 : 190->203)] { 
lbl57:
                        // 1 sources

                        if (conn != null) {
                            conn.close();
                        }
                        break block21;
lbl60:
                        // 1 sources

                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    v4 = true;
                    break;
                }
                var10_12 = null;
                ** try [egrp 3[TRYBLOCK] [1 : 190->203)] { 
lbl68:
                // 1 sources

                if (conn != null) {
                    conn.close();
                }
                break block22;
lbl71:
                // 1 sources

                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        var16_16 = v4;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)var16_16), var13_5);
        return v4;
    }

    /*
     * WARNING - void declaration
     */
    private void setReadyForConnection(boolean bl) {
        void ready;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.readyForConnections = ready;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    public synchronized boolean isReadyForConnections() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.readyForConnections;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    private void reportPid() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        boolean printed = false;
        int i = 0;
        while (!printed && i < 50) {
            if (this.pidFile().exists() && this.pidFile().length() > 0L) {
                this.utils.threads().pause(25);
                this.printMessage("mysqld running as process: " + this.pid());
                this.out.flush();
                printed = true;
            }
            this.utils.threads().pause(100);
            ++i;
        }
        this.reportIfNoPidfile(printed);
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * Unable to fully structure code
     */
    synchronized String pid() {
        var1_1 = Factory.makeJP((JoinPoint.StaticPart)MysqldResource.ajc$tjp_6, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(var1_1);
        if (this.pid != null) ** GOTO lbl8
        if (!this.pidFile().exists()) {
            v0 = "No PID";
        } else {
            this.pid = this.utils.files().asString(this.pidFile()).trim();
lbl8:
            // 2 sources

            v0 = this.pid;
        }
        var2_2 = v0;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, var1_1);
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    void reportIfNoPidfile(boolean bl) {
        void pidFileFound;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        if (pidFileFound == false) {
            this.printWarning("mysqld pid-file not found:  " + this.pidFile());
        }
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    public synchronized void shutdown() {
        boolean haveShell;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = haveShell = this.getShell() != null;
        if (!this.pidFile().exists() && !haveShell) {
            this.printMessage("Mysqld not running. No file: " + this.pidFile());
        } else {
            this.printMessage("stopping mysqld (process: " + this.pid() + ")");
            this.issueNormalKill();
            if (this.processRunning()) {
                this.issueForceKill();
            }
            if (this.shellRunning()) {
                this.destroyShell();
            }
            this.setShell(null);
            if (this.processRunning()) {
                this.printWarning("Process " + this.pid + "still running; not deleting " + this.pidFile());
            } else {
                this.utils.threads().pause(150);
                System.gc();
                this.utils.threads().pause(150);
                this.pidFile().deleteOnExit();
                this.pidFile().delete();
                this.pidFile = null;
                this.pid = null;
            }
            this.setReadyForConnection(false);
            this.printMessage("clearing options");
            this.options.clear();
            this.out.flush();
            this.printMessage("shutdown complete");
        }
        Object var3_3 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var3_3, joinPoint);
    }

    void destroyShell() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String shellName = this.getShell().getName();
        this.printWarning("attempting to destroy thread " + shellName);
        this.getShell().destroyProcess();
        this.waitForShellToDie();
        String msg = String.valueOf(this.shellRunning() ? "not " : "") + "destroyed.";
        this.printWarning(String.valueOf(shellName) + " " + msg);
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    void issueForceKill() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.printWarning("attempting to \"force kill\" " + this.pid());
        new ProcessUtil(this.pid(), this.err, this.err, this.baseDir, this.utils).forceKill();
        this.waitForProcessToDie();
        if (this.processRunning()) {
            String msg = String.valueOf(this.processRunning() ? "not " : "") + "killed.";
            this.printWarning(String.valueOf(this.pid()) + " " + msg);
        } else {
            this.printMessage("force kill " + this.pid() + " issued.");
        }
        Object var3_3 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var3_3, joinPoint);
    }

    private void issueNormalKill() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        if (!this.pidFile().exists()) {
            this.printWarning("Not running? File not found: " + this.pidFile());
        } else {
            new ProcessUtil(this.pid(), this.err, this.err, this.baseDir, this.utils).killNoThrow();
            this.waitForProcessToDie();
        }
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    private void waitForProcessToDie() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        long giveUp = System.currentTimeMillis() + (long)this.killDelay;
        while (this.processRunning() && System.currentTimeMillis() < giveUp) {
            this.utils.threads().pause(250);
        }
        Object var4_3 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_3, joinPoint);
    }

    private void waitForShellToDie() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        long giveUp = System.currentTimeMillis() + (long)this.killDelay;
        while (this.shellRunning() && System.currentTimeMillis() < giveUp) {
            this.utils.threads().pause(250);
        }
        Object var4_3 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_3, joinPoint);
    }

    public synchronized Map getServerOptions() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.options.isEmpty()) {
            this.options = this.optionParser.getOptionsFromHelp(this.getHelp(new HashMap()));
        }
        HashMap hashMap = new HashMap(this.options);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(hashMap, joinPoint);
        return hashMap;
    }

    public synchronized boolean isRunning() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.shellRunning() || this.processRunning();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    private boolean processRunning() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = !this.pidFile().exists() ? false : new ProcessUtil(this.pid(), this.out, this.err, this.baseDir, this.utils).isRunning();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    private boolean shellRunning() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.getShell() != null && this.getShell().isAlive();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    public synchronized String getVersion() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String string = this.versionString;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    private String getVersionDir() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String string = this.getVersion().replaceAll("\\.", "-");
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void setVersion(boolean bl, String string) {
        void mysqlVersionString;
        void check;
        boolean bl2 = bl;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2), (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        if (check != false && this.isRunning()) {
            throw new IllegalStateException("Already running");
        }
        this.versionString = mysqlVersionString == null ? "5.0.21" : mysqlVersionString;
        Object var6_6 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var6_6, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setVersion(String string) {
        void mysqlVersionString;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.setVersion(true, (String)mysqlVersionString);
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void printMessage(String string) {
        void msg;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.println(this.out, (String)msg);
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void printWarning(String string) {
        void msg;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.println(this.err, "");
        this.println(this.err, (String)msg);
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void println(PrintStream printStream, String string) {
        void msg;
        void stream;
        PrintStream printStream2 = printStream;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)printStream2, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        stream.println(String.valueOf(this.msgPrefix) + (String)msg);
        Object var6_6 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var6_6, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void setOsAndArch(String string, String string2) {
        void osArch;
        void osName;
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)string3, (Object)string4);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String name = osName;
        if (osName.indexOf("Win") != -1) {
            name = "Win";
        }
        this.osName = this.stripUnwantedChars(name);
        this.osArch = this.stripUnwantedChars((String)osArch);
        Object var7_7 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var7_7, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    String stripUnwantedChars(String string) {
        void str;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String string3 = str.replace(' ', '_').replace('/', '_').replace('\\', '_');
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(string3, joinPoint);
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    synchronized Shell exec(String string, Map map, PrintStream printStream, PrintStream printStream2, boolean bl) {
        void withListeners;
        void errStream;
        void threadName;
        void outStream;
        void mysqldArgs;
        String string2 = string;
        Map map2 = map;
        PrintStream printStream3 = printStream;
        PrintStream printStream4 = printStream2;
        boolean bl2 = bl;
        Object[] objectArray = new Object[]{string2, map2, printStream3, printStream4, Conversions.booleanObject((boolean)bl2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.makeMysqld();
        this.ensureEssentialFilesExist();
        this.adjustParameterMap((Map)mysqldArgs);
        Object[] args = this.constructArgs((Map)mysqldArgs);
        outStream.println(new ListToString().toString(args));
        Shell launch = this.utils.shellFactory().newShell((String[])args, (String)threadName, (PrintStream)outStream, (PrintStream)errStream);
        if (withListeners != false) {
            int i = 0;
            while (i < this.completionListensers.size()) {
                Runnable listener = (Runnable)this.completionListensers.get(i);
                launch.addCompletionListener(listener);
                ++i;
            }
        }
        launch.setDaemon(true);
        this.printMessage("launching mysqld (" + (String)threadName + ")");
        launch.start();
        Shell shell = launch;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(shell, joinPoint);
        return shell;
    }

    /*
     * WARNING - void declaration
     */
    private void adjustParameterMap(Map map) {
        void mysqldArgs;
        Map map2 = map;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)map2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureDir((Map)mysqldArgs, this.baseDir, "basedir");
        this.ensureDir((Map)mysqldArgs, this.dataDir, "datadir");
        mysqldArgs.put("pid-file", this.utils.files().getPath(this.pidFile()));
        this.ensureSocket((Map)mysqldArgs);
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    File makeMysqld() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        File mysqld = this.getMysqldFilePointer();
        if (!mysqld.exists()) {
            mysqld.getParentFile().mkdirs();
            this.utils.streams().createFileFromResource(this.getResourceName(), mysqld);
        }
        this.utils.files().addExecutableRights(mysqld, this.out, this.err);
        File file = mysqld;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(file, joinPoint);
        return file;
    }

    String getResourceName() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String dir = String.valueOf(this.osName) + "-" + this.osArch;
        String name = this.executableName();
        String string = String.valueOf(this.getVersionDir()) + "/" + dir + "/" + name;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    private String executableName() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String mysqld = "mysqld";
        String string = this.isWindows() ? String.valueOf(mysqld) + "-nt.exe" : mysqld;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    boolean isWindows() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.osName.equals("Win");
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    File getMysqldFilePointer() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        File bin = new File(this.baseDir, "bin");
        File file = new File(bin, this.executableName());
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(file, joinPoint);
        return file;
    }

    void ensureEssentialFilesExist() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.utils.streams().expandResourceJar(this.dataDir, String.valueOf(this.getVersionDir()) + "/" + "data_dir.jar");
        this.utils.streams().expandResourceJar(this.baseDir, String.valueOf(this.getVersionDir()) + "/" + this.shareJar());
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    void ensureSocket(Map map) {
        void mysqldArgs;
        Map map2 = map;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object)map2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String socketString = (String)mysqldArgs.get("socket");
        if (socketString == null) {
            mysqldArgs.put("socket", "mysql.sock");
        }
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void ensureDir(Map map, File file, String string) {
        File asConnonical;
        void expected;
        void key;
        void mysqldArgs;
        Map map2 = map;
        File file2 = file;
        String string2 = string;
        Object[] objectArray = new Object[]{map2, file2, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String dirString = (String)mysqldArgs.get(key);
        if (dirString != null && !expected.equals(asConnonical = this.utils.files().validCononicalDir(new File(dirString)))) {
            String msg = String.valueOf(dirString) + " not equal to " + expected;
            throw new IllegalArgumentException(msg);
        }
        mysqldArgs.put(key, this.utils.files().getPath((File)expected));
        Object var12_12 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var12_12, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    String[] constructArgs(Map map) {
        void mysqldArgs;
        Map map2 = map;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, (Object)map2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        ArrayList<String> strs = new ArrayList<String>();
        strs.add(this.utils.files().getPath(this.getMysqldFilePointer()));
        strs.add("--no-defaults");
        if (this.isWindows()) {
            strs.add("--console");
        }
        Iterator it = mysqldArgs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            StringBuffer buf = new StringBuffer("--");
            buf.append(key);
            if (value != null) {
                buf.append("=");
                buf.append(value);
            }
            strs.add(buf.toString());
        }
        String[] stringArray = this.utils.str().toStringArray(strs);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(stringArray, joinPoint);
        return stringArray;
    }

    protected void finalize() throws Throwable {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.getShell() != null) {
            this.printWarning("resource released without closure.");
            this.trace.printStackTrace(this.err);
        }
        super.finalize();
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    String shareJar() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String shareJar = "share_dir.jar";
        if (this.isWindows()) {
            shareJar = "win_" + shareJar;
        }
        String string = shareJar;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    void setShell(Shell shell) {
        void shell2;
        Shell shell3 = shell;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, (Object)shell3);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.shell = shell2;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    Shell getShell() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        Shell shell = this.shell;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(shell, joinPoint);
        return shell;
    }

    public File getBaseDir() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        File file = this.baseDir;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(file, joinPoint);
        return file;
    }

    public File getDataDir() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        File file = this.dataDir;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(file, joinPoint);
        return file;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setKillDelay(int n) {
        void millis;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.killDelay = millis;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void addCompletionListenser(Runnable runnable) {
        void listener;
        Runnable runnable2 = runnable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this, (Object)runnable2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.completionListensers.add(listener);
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private String getHelp(Map map) {
        void params;
        Map map2 = map;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this, (Object)map2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream capturedOut = new PrintStream(bos);
        params.put("help", null);
        params.put("verbose", null);
        this.exec("getOptions", (Map)params, capturedOut, capturedOut, false).join();
        params.remove("help");
        params.remove("verbose");
        this.utils.threads().pause(500);
        capturedOut.flush();
        capturedOut.close();
        String string = new String(bos.toByteArray());
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    private synchronized File pidFile() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.pidFile == null) {
            String className = this.utils.str().shortClassName(this.getClass());
            this.pidFile = new File(this.dataDir, String.valueOf(className) + ".pid");
        }
        File file = this.pidFile;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(file, joinPoint);
        return file;
    }

    static void printUsage(PrintStream printStream) {
        PrintStream out;
        PrintStream printStream2 = printStream;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, null, null, (Object)printStream2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        StringBuffer stringBuffer = new StringBuffer("java ");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.mysql.management.MysqldResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String command = stringBuffer.append(clazz.getName()).toString();
        String basedir = " --basedir";
        String datadir = " --datadir";
        out.println("Usage to start: ");
        out.println(String.valueOf(command) + " [ server options ]");
        out.println();
        out.println("Usage to shutdown: ");
        out.println(String.valueOf(command) + " --shutdown [" + basedir + "=/full/path/to/basedir ]");
        out.println();
        out.println("Common server options include:");
        out.println(String.valueOf(basedir) + "=/full/path/to/basedir");
        out.println(String.valueOf(datadir) + "=/full/path/to/datadir");
        out.println(" --socket=/full/path/to/socketfile");
        out.println();
        out.println("Example:");
        out.println(String.valueOf(command) + basedir + "=/home/duke/dukeapp/db" + datadir + "=/data/dukeapp/data" + " --max_allowed_packet=65000000");
        out.println(String.valueOf(command) + " --shutdown" + basedir + "=/home/duke/dukeapp/db");
        out.println();
        Object var6_6 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var6_6, joinPoint);
    }

    public static void main(String[] stringArray) {
        String[] args;
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, null, null, (Object)stringArray2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        CommandLineOptionsParser clop = new CommandLineOptionsParser(args);
        if (clop.containsKey("help")) {
            MysqldResource.printUsage(System.out);
        } else {
            PrintStream out = System.out;
            PrintStream err = System.err;
            if (clop.containsKey("silent")) {
                clop.remove("silent");
                NullPrintStream devNull = new NullPrintStream();
                out = devNull;
                err = devNull;
            }
            MysqldResource mysqld = new MysqldResource(clop.getBaseDir(), clop.getDataDir(), clop.getVersion(), out, err);
            if (clop.isShutdown()) {
                mysqld.shutdown();
            } else {
                mysqld.start(new Threads().newName(), clop.asMap());
            }
        }
        Object var7_7 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var7_7, joinPoint);
    }

    static /* synthetic */ void access$0(MysqldResource mysqldResource, boolean bl) {
        MysqldResource mysqldResource2 = mysqldResource;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, null, null, (Object)mysqldResource2, (Object)Conversions.booleanObject((boolean)bl2));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        mysqldResource.setReadyForConnection(bl);
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    static /* synthetic */ List access$1(MysqldResource mysqldResource) {
        MysqldResource mysqldResource2 = mysqldResource;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, null, null, (Object)mysqldResource2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        List list = mysqldResource.completionListensers;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(list, joinPoint);
        return list;
    }

    static {
        Factory factory = new Factory("MysqldResource.java", Class.forName("com.mysql.management.MysqldResource"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-initTrace-com.mysql.management.MysqldResource----void-"), 141);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-start-com.mysql.management.MysqldResource-java.lang.String:java.util.Map:-threadName:mysqldArgs:--void-"), 149);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-issueForceKill-com.mysql.management.MysqldResource----void-"), 305);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-issueNormalKill-com.mysql.management.MysqldResource----void-"), 318);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-waitForProcessToDie-com.mysql.management.MysqldResource----void-"), 328);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-waitForShellToDie-com.mysql.management.MysqldResource----void-"), 335);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-getServerOptions-com.mysql.management.MysqldResource----java.util.Map-"), 342);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-isRunning-com.mysql.management.MysqldResource----boolean-"), 349);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-processRunning-com.mysql.management.MysqldResource----boolean-"), 353);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-shellRunning-com.mysql.management.MysqldResource----boolean-"), 360);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-getVersion-com.mysql.management.MysqldResource----java.lang.String-"), 364);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getVersionDir-com.mysql.management.MysqldResource----java.lang.String-"), 368);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-canConnectToServer-com.mysql.management.MysqldResource-int:int:-port:triesBeforeGivingUp:--boolean-"), 182);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("22-setVersion-com.mysql.management.MysqldResource-boolean:java.lang.String:-check:mysqlVersionString:--void-"), 373);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-setVersion-com.mysql.management.MysqldResource-java.lang.String:-mysqlVersionString:--void-"), 385);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-printMessage-com.mysql.management.MysqldResource-java.lang.String:-msg:--void-"), 389);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-printWarning-com.mysql.management.MysqldResource-java.lang.String:-msg:--void-"), 393);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-println-com.mysql.management.MysqldResource-java.io.PrintStream:java.lang.String:-stream:msg:--void-"), 398);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-setOsAndArch-com.mysql.management.MysqldResource-java.lang.String:java.lang.String:-osName:osArch:--void-"), 403);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-stripUnwantedChars-com.mysql.management.MysqldResource-java.lang.String:-str:--java.lang.String-"), 412);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("20-exec-com.mysql.management.MysqldResource-java.lang.String:java.util.Map:java.io.PrintStream:java.io.PrintStream:boolean:-threadName:mysqldArgs:outStream:errStream:withListeners:--com.mysql.management.util.Shell-"), 419);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-adjustParameterMap-com.mysql.management.MysqldResource-java.util.Map:-mysqldArgs:--void-"), 443);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-makeMysqld-com.mysql.management.MysqldResource----java.io.File-"), 451);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-setReadyForConnection-com.mysql.management.MysqldResource-boolean:-ready:--void-"), 211);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getResourceName-com.mysql.management.MysqldResource----java.lang.String-"), 461);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-executableName-com.mysql.management.MysqldResource----java.lang.String-"), 468);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-isWindows-com.mysql.management.MysqldResource----boolean-"), 473);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getMysqldFilePointer-com.mysql.management.MysqldResource----java.io.File-"), 477);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-ensureEssentialFilesExist-com.mysql.management.MysqldResource----void-"), 482);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-ensureSocket-com.mysql.management.MysqldResource-java.util.Map:-mysqldArgs:--void-"), 489);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-ensureDir-com.mysql.management.MysqldResource-java.util.Map:java.io.File:java.lang.String:-mysqldArgs:expected:key:--void-"), 497);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-constructArgs-com.mysql.management.MysqldResource-java.util.Map:-mysqldArgs:--[Ljava.lang.String;-"), 510);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-finalize-com.mysql.management.MysqldResource---java.lang.Throwable:-void-"), 535);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-shareJar-com.mysql.management.MysqldResource----java.lang.String-"), 543);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-isReadyForConnections-com.mysql.management.MysqldResource----boolean-"), 215);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-setShell-com.mysql.management.MysqldResource-com.mysql.management.util.Shell:-shell:--void-"), 551);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getShell-com.mysql.management.MysqldResource----com.mysql.management.util.Shell-"), 555);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getBaseDir-com.mysql.management.MysqldResource----java.io.File-"), 559);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getDataDir-com.mysql.management.MysqldResource----java.io.File-"), 563);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-setKillDelay-com.mysql.management.MysqldResource-int:-millis:--void-"), 567);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-addCompletionListenser-com.mysql.management.MysqldResource-java.lang.Runnable:-listener:--void-"), 571);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getHelp-com.mysql.management.MysqldResource-java.util.Map:-params:--java.lang.String-"), 575);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("22-pidFile-com.mysql.management.MysqldResource----java.io.File-"), 594);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-printUsage-com.mysql.management.MysqldResource-java.io.PrintStream:-out:--void-"), 603);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-main-com.mysql.management.MysqldResource-[Ljava.lang.String;:-args:--void-"), 628);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-reportPid-com.mysql.management.MysqldResource----void-"), 219);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-access$0-com.mysql.management.MysqldResource-com.mysql.management.MysqldResource:boolean:-arg0:arg1:--void-"), 210);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-access$1-com.mysql.management.MysqldResource-com.mysql.management.MysqldResource:-arg0:--java.util.List-"), 86);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("20-pid-com.mysql.management.MysqldResource----java.lang.String-"), 235);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-reportIfNoPidfile-com.mysql.management.MysqldResource-boolean:-pidFileFound:--void-"), 246);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-shutdown-com.mysql.management.MysqldResource----void-"), 255);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-destroyShell-com.mysql.management.MysqldResource----void-"), 296);
    }
}

