/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.driverlaunched;

import com.mysql.jdbc.SocketFactory;
import com.mysql.jdbc.StandardSocketFactory;
import com.mysql.management.MysqldResource;
import com.mysql.management.MysqldResourceI;
import com.mysql.management.driverlaunched.MysqldFactory;
import com.mysql.management.util.Files;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;

public final class ServerLauncherSocketFactory
implements SocketFactory {
    public static final String SERVER_DOT = "server.";
    private static int launchCount = 0;
    private MysqldFactory resourceFactory;
    private SocketFactory socketFactory;

    public ServerLauncherSocketFactory() {
        this.setResourceFactory(new MysqldFactory.Default());
        this.setSocketFactory((SocketFactory)new StandardSocketFactory());
    }

    public Socket connect(String host, int portNumber, Properties props) throws SocketException, IOException {
        this.ensureMysqlStarted(portNumber, props);
        return this.getSocketFactory().connect(host, portNumber, props);
    }

    private void ensureMysqlStarted(int port, Properties props) {
        MysqldResourceI mysqld;
        HashMap<String, String> serverOpts = new HashMap<String, String>();
        Enumeration<?> enums = props.propertyNames();
        while (enums.hasMoreElements()) {
            String key = enums.nextElement().toString();
            if (!key.startsWith(SERVER_DOT)) continue;
            String val = this.replaceNullStringWithNull(props.getProperty(key));
            serverOpts.put(key.substring(SERVER_DOT.length()), val);
        }
        serverOpts.put("port", Integer.toString(port));
        Object baseDirStr = serverOpts.get("basedir");
        File baseDir = new Files().newFile(baseDirStr);
        String dataDirString = (String)serverOpts.get("datadir");
        File dataDir = null;
        if (dataDirString != null) {
            File ddir = new File(dataDirString);
            dataDir = new Files().validCononicalDir(ddir);
        }
        if ((mysqld = this.resourceFactory.newMysqldResource(baseDir, dataDir)).isRunning()) {
            Object runningPort = mysqld.getServerOptions().get("port");
            if (!runningPort.equals(Integer.toString(port))) {
                String msg = "Mysqld at " + mysqld.getBaseDir() + " is running on port " + runningPort + " not " + port;
                throw new RuntimeException(msg);
            }
            return;
        }
        mysqld.setVersion((String)serverOpts.get("mysql-version"));
        String threadName = "driver_launched_mysqld_" + ++launchCount;
        mysqld.start(threadName, serverOpts);
    }

    String replaceNullStringWithNull(String str) {
        return String.valueOf(null).equals(str) ? null : str;
    }

    public Socket afterHandshake() throws SocketException, IOException {
        return this.getSocketFactory().afterHandshake();
    }

    public Socket beforeHandshake() throws SocketException, IOException {
        return this.getSocketFactory().beforeHandshake();
    }

    void setResourceFactory(MysqldFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    MysqldFactory getResourceFactory() {
        return this.resourceFactory;
    }

    void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public static synchronized boolean shutdown(File baseDir, File dataDir) {
        MysqldResource mysqld = new MysqldResource(baseDir, dataDir);
        mysqld.shutdown();
        return mysqld.isRunning();
    }
}

