/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.jmx;

import com.mysql.management.MysqldResource;
import com.mysql.management.MysqldResourceI;
import com.mysql.management.util.DefaultsMap;
import com.mysql.management.util.Exceptions;
import com.mysql.management.util.Str;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;

public class SimpleMysqldDynamicMBean
implements DynamicMBean {
    public static final String AUTOSTART_ATTR = "autostart";
    public static final String START_METHOD = "startMysqld";
    public static final String STOP_METHOD = "stop";
    private static final String VERSION = "$Id: SimpleMysqldDynamicMBean.java,v 1.15 2005/08/31 01:21:16 eherman Exp $";
    private MysqldResourceI mysqldResource;
    private MBeanAttributeInfo[] attrInfos;
    private MBeanConstructorInfo[] consInfo;
    private List mBeanOperationInfoList;
    private MBeanOperationInfo startMysqldOp;
    private MBeanOperationInfo stopOp;
    private MBeanNotificationInfo[] notesInfos;
    private MBeanInfo mbeanInfo;
    private DefaultsMap attributes;
    private Str str;
    Object[] lastInvocation;
    static /* synthetic */ Class class$0;

    public SimpleMysqldDynamicMBean() {
        this(new MysqldResource());
    }

    protected SimpleMysqldDynamicMBean(MysqldResourceI mysqldResource) {
        this.mysqldResource = mysqldResource;
        this.str = new Str();
        this.notesInfos = new MBeanNotificationInfo[0];
        this.mBeanOperationInfoList = new ArrayList();
        this.startMysqldOp = this.newVoidMBeanOperation(START_METHOD, "Start MySQL");
        this.stopOp = this.newVoidMBeanOperation(STOP_METHOD, "Stop MySQL");
        this.getMBeanOperationInfoList().add(this.startMysqldOp);
        this.initAttributes();
        this.initConstructors();
    }

    protected List getMBeanOperationInfoList() {
        return this.mBeanOperationInfoList;
    }

    private void initConstructors() {
        Constructor<?>[] constructors = this.getClass().getConstructors();
        Constructor<?> con = null;
        int i = 0;
        while (con == null && i < constructors.length) {
            if (constructors[i].getParameterTypes().length == 0) {
                con = constructors[i];
            }
            ++i;
        }
        this.consInfo = new MBeanConstructorInfo[1];
        this.consInfo[0] = new MBeanConstructorInfo("MySQL", con);
    }

    private void initAttributes() {
        this.attributes = new DefaultsMap();
        TreeMap options = new TreeMap(this.mysqldResource.getServerOptions());
        ArrayList attInfs = new ArrayList();
        this.makeAttribute(attInfs, AUTOSTART_ATTR, Boolean.FALSE.toString(), true);
        Iterator iter = options.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String attName = (String)entry.getKey();
            String attValue = (String)entry.getValue();
            this.makeAttribute(attInfs, attName, attValue, true);
        }
        this.makeAttribute(attInfs, this.versionAttributeName(), VERSION, false);
        this.attrInfos = attInfs.toArray(new MBeanAttributeInfo[attInfs.size()]);
    }

    private void makeAttribute(List attInfs, String attName, String attValue, boolean isWritable) {
        Attribute attr = new Attribute(attName, attValue);
        String description = "";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MBeanAttributeInfo atInfo = new MBeanAttributeInfo(attName, clazz.getName(), description, true, isWritable, false);
        this.attributes.put(attName, attr);
        attInfs.add(atInfo);
    }

    public synchronized Object getAttribute(String attributeName) throws AttributeNotFoundException {
        Attribute attribute = (Attribute)this.attributes.get(attributeName);
        if (attribute == null) {
            throw new AttributeNotFoundException(attributeName);
        }
        return attribute.getValue();
    }

    public synchronized AttributeList getAttributes(String[] attributeNames) {
        AttributeList list = new AttributeList(attributeNames.length);
        int i = 0;
        while (i < attributeNames.length) {
            Attribute att = (Attribute)this.attributes.get(attributeNames[i]);
            list.add(att);
            ++i;
        }
        return list;
    }

    public synchronized MBeanInfo getMBeanInfo() {
        if (this.mbeanInfo == null) {
            this.mbeanInfo = new MBeanInfo(this.getClass().getName(), "MySQL MBean", this.attrInfos, this.consInfo, this.opsInfo(), this.notesInfos);
        }
        return this.mbeanInfo;
    }

    private MBeanOperationInfo[] opsInfo() {
        int length = this.getMBeanOperationInfoList().size();
        MBeanOperationInfo[] array = new MBeanOperationInfo[length];
        return this.getMBeanOperationInfoList().toArray(array);
    }

    public synchronized Object invoke(String methodName, Object[] args, String[] types) throws ReflectionException {
        this.lastInvocation = new Object[]{methodName, args, types};
        this.clearMBeanInfo();
        if (methodName.equals(START_METHOD)) {
            this.mysqldResource.start("MysqldMBean", this.attributesToOpionMap());
            this.getMBeanOperationInfoList().remove(this.startMysqldOp);
            this.getMBeanOperationInfoList().add(this.stopOp);
            this.freezeAttributes();
            return null;
        }
        if (methodName.equals(STOP_METHOD)) {
            this.mysqldResource.shutdown();
            this.getMBeanOperationInfoList().remove(this.stopOp);
            this.getMBeanOperationInfoList().add(this.startMysqldOp);
            this.initAttributes();
            return null;
        }
        String msg = String.valueOf(methodName) + " not implemented";
        throw new ReflectionException(new NoSuchMethodException(msg), msg);
    }

    protected void clearMBeanInfo() {
        this.mbeanInfo = null;
    }

    void freezeAttributes() {
        boolean isWritable = false;
        int i = 0;
        while (i < this.attrInfos.length) {
            MBeanAttributeInfo info = this.attrInfos[i];
            this.attrInfos[i] = new MBeanAttributeInfo(info.getName(), info.getType(), info.getDescription(), info.isReadable(), isWritable, info.isIs());
            ++i;
        }
    }

    Map attributesToOpionMap() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        Iterator iter = this.attributes.getChanged().values().iterator();
        while (iter.hasNext()) {
            Attribute at = (Attribute)iter.next();
            options.put(at.getName(), at.getValue());
        }
        options.remove(AUTOSTART_ATTR);
        return options;
    }

    public synchronized void setAttribute(Attribute attribute) throws AttributeNotFoundException {
        String name = attribute.getName();
        if (!this.attributes.containsKey(name)) {
            throw new AttributeNotFoundException(name);
        }
        this.attributes.put(name, attribute);
    }

    public synchronized AttributeList setAttributes(AttributeList attributes) {
        int i = 0;
        while (i < attributes.size()) {
            final Attribute att = (Attribute)attributes.get(i);
            new Exceptions.VoidBlock(){

                public void inner() throws Exception {
                    SimpleMysqldDynamicMBean.this.setAttribute(att);
                }
            }.exec();
            ++i;
        }
        return attributes;
    }

    MysqldResourceI getMysqldResource() {
        return this.mysqldResource;
    }

    String versionAttributeName() {
        return "version_of_" + this.str.shortClassName(this.getClass());
    }

    protected MBeanOperationInfo newVoidMBeanOperation(String method, String description) {
        return new MBeanOperationInfo(method, description, new MBeanParameterInfo[0], "void", 1);
    }
}

