/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.jmx;

import com.mysql.management.MysqldResourceTestImpl;
import com.mysql.management.jmx.SimpleMysqldDynamicMBean;
import com.mysql.management.util.Str;
import com.mysql.management.util.TestUtil;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import junit.framework.Assert;
import junit.framework.TestCase;

public class SimpleMysqldDynamicMBeanTest
extends TestCase {
    static /* synthetic */ Class class$0;

    public void testGetMBeanInfo() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("foo", "bar");
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(null, null, options, new HashMap());
        SimpleMysqldDynamicMBean myBean = new SimpleMysqldDynamicMBean(mysqld);
        MBeanInfo info = myBean.getMBeanInfo();
        Assert.assertNotNull((Object)info);
        Assert.assertEquals((String)myBean.getClass().getName(), (String)info.getClassName());
        Assert.assertEquals((String)"MySQL MBean", (String)info.getDescription());
        MBeanAttributeInfo[] atts = info.getAttributes();
        Assert.assertEquals((int)3, (int)atts.length);
        Assert.assertEquals((String)"autostart", (String)atts[0].getName());
        Assert.assertEquals((String)"", (String)atts[0].getDescription());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Assert.assertEquals((String)clazz.getName(), (String)atts[0].getType());
        Assert.assertTrue((boolean)atts[0].isReadable());
        Assert.assertTrue((boolean)atts[0].isWritable());
        Assert.assertEquals((boolean)false, (boolean)atts[0].isIs());
        Assert.assertEquals((String)"foo", (String)atts[1].getName());
        Assert.assertEquals((String)"", (String)atts[1].getDescription());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Assert.assertEquals((String)clazz2.getName(), (String)atts[1].getType());
        Assert.assertTrue((boolean)atts[1].isReadable());
        Assert.assertTrue((boolean)atts[1].isWritable());
        Assert.assertEquals((boolean)false, (boolean)atts[1].isIs());
        MBeanConstructorInfo[] cons = info.getConstructors();
        Assert.assertEquals((int)1, (int)cons.length);
        Assert.assertEquals((int)0, (int)cons[0].getSignature().length);
        MBeanNotificationInfo[] notes = info.getNotifications();
        Assert.assertEquals((int)0, (int)notes.length);
        MBeanOperationInfo[] ops = info.getOperations();
        Assert.assertEquals((int)1, (int)ops.length);
        Assert.assertEquals((String)"startMysqld", (String)ops[0].getName());
        Assert.assertEquals((String)"Start MySQL", (String)ops[0].getDescription());
        Assert.assertEquals((int)0, (int)ops[0].getSignature().length);
        Assert.assertEquals((String)"void", (String)ops[0].getReturnType());
        Assert.assertEquals((int)1, (int)ops[0].getImpact());
        myBean.invoke("startMysqld", null, null);
        info = myBean.getMBeanInfo();
        ops = info.getOperations();
        Assert.assertEquals((int)1, (int)ops.length);
        Assert.assertEquals((String)"stop", (String)ops[0].getName());
        Assert.assertEquals((String)"Stop MySQL", (String)ops[0].getDescription());
        Assert.assertEquals((int)0, (int)ops[0].getSignature().length);
        Assert.assertEquals((String)"void", (String)ops[0].getReturnType());
        Assert.assertEquals((int)1, (int)ops[0].getImpact());
        myBean.invoke("stop", null, null);
        info = myBean.getMBeanInfo();
        ops = info.getOperations();
        Assert.assertEquals((int)1, (int)ops.length);
        Assert.assertEquals((String)"startMysqld", (String)ops[0].getName());
    }

    public void testGetAttribute() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("foo", "bar");
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(null, null, options, new HashMap());
        SimpleMysqldDynamicMBean myBean = new SimpleMysqldDynamicMBean(mysqld);
        Assert.assertEquals((Object)"bar", (Object)myBean.getAttribute("foo"));
        try {
            myBean.getAttribute("b0gus");
            Assert.fail();
        }
        catch (AttributeNotFoundException e) {
            Assert.assertTrue((e.getMessage().indexOf("b0gus") >= 0 ? 1 : 0) != 0);
        }
    }

    public void testGetAttributeList() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("foo", "bar");
        options.put("baz", "wiz");
        options.put("datadir", "/bogus/dir");
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(null, null, options, new HashMap());
        SimpleMysqldDynamicMBean myBean = new SimpleMysqldDynamicMBean(mysqld);
        AttributeList attributeList = myBean.getAttributes(new String[]{"foo", "datadir"});
        Assert.assertEquals((int)2, (int)attributeList.size());
        Attribute att = (Attribute)attributeList.get(0);
        Assert.assertEquals((String)"foo", (String)att.getName());
        Assert.assertEquals((Object)"bar", (Object)att.getValue());
    }

    public void testGetAgentVersion() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("foo", "bar");
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(null, null, options, new HashMap());
        SimpleMysqldDynamicMBean myBean = new SimpleMysqldDynamicMBean(mysqld);
        String verAttName = myBean.versionAttributeName();
        String expected = "$Id: " + new Str().shortClassName(myBean);
        String beanVersion = (String)myBean.getAttribute(verAttName);
        new TestUtil().assertContainsIgnoreCase(beanVersion, expected);
        MBeanInfo info = myBean.getMBeanInfo();
        MBeanAttributeInfo[] atts = info.getAttributes();
        Assert.assertTrue((boolean)atts[0].isReadable());
        Assert.assertTrue((boolean)atts[0].isWritable());
        Assert.assertFalse((boolean)atts[0].isIs());
        Assert.assertTrue((boolean)atts[1].isReadable());
        Assert.assertTrue((boolean)atts[1].isWritable());
        Assert.assertFalse((boolean)atts[1].isIs());
        Assert.assertTrue((boolean)atts[2].isReadable());
        Assert.assertFalse((boolean)atts[2].isWritable());
        Assert.assertFalse((boolean)atts[2].isIs());
    }

    public void testSetAttributes() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("foo", "bar");
        options.put("baz", "wiz");
        options.put("datadir", "/bogus/dir");
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(null, null, options, new HashMap());
        SimpleMysqldDynamicMBean myBean = new SimpleMysqldDynamicMBean(mysqld);
        AttributeList list = new AttributeList();
        list.add(new Attribute("foo", "changed"));
        list.add(new Attribute("datadir", "/changed/dir"));
        myBean.setAttributes(list);
        Assert.assertEquals((Object)"changed", (Object)myBean.getAttribute("foo"));
        Assert.assertEquals((Object)"wiz", (Object)myBean.getAttribute("baz"));
        Assert.assertEquals((Object)"/changed/dir", (Object)myBean.getAttribute("datadir"));
    }

    public void testSetAttribute() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("foo", "bar");
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(null, null, options, new HashMap());
        SimpleMysqldDynamicMBean myBean = new SimpleMysqldDynamicMBean(mysqld);
        try {
            myBean.setAttribute(new Attribute("bogus", "werid"));
            Assert.fail();
        }
        catch (AttributeNotFoundException e) {
            Assert.assertTrue((String)e.getMessage(), (e.getMessage().indexOf("bogus") >= 0 ? 1 : 0) != 0);
        }
    }

    public void testAutoStart() throws Exception {
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(null, null, new HashMap());
        SimpleMysqldDynamicMBean myBean = new SimpleMysqldDynamicMBean(mysqld);
        Assert.assertFalse((boolean)mysqld.isRunning());
        String autostart = "autostart";
        String str_true = Boolean.TRUE.toString();
        myBean.setAttribute(new Attribute(autostart, str_true));
        Assert.assertFalse((boolean)mysqld.isRunning());
        Assert.assertFalse((boolean)mysqld.getServerOptions().containsKey(autostart));
    }

    public void testInvoke() throws Exception {
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(null, null, new HashMap());
        SimpleMysqldDynamicMBean myBean = new SimpleMysqldDynamicMBean(mysqld);
        Assert.assertEquals((boolean)false, (boolean)mysqld.isRunning());
        myBean.invoke("startMysqld", null, null);
        Assert.assertTrue((boolean)mysqld.isRunning());
        myBean.invoke("stop", null, null);
        Assert.assertEquals((boolean)false, (boolean)mysqld.isRunning());
        try {
            myBean.invoke("bogus", null, null);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((e.getMessage().indexOf("bogus") >= 0 ? 1 : 0) != 0);
        }
    }

    public void testPassOptionsMapToMysqld() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("foo", "bar");
        options.put("baz", "wiz");
        options.put("datadir", "/bogus/dir");
        options.put("help", "");
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(null, null, options, new HashMap());
        SimpleMysqldDynamicMBean myBean = new SimpleMysqldDynamicMBean(mysqld);
        myBean.setAttribute(new Attribute("foo", "changed"));
        Assert.assertTrue((boolean)myBean.attributesToOpionMap().containsKey("foo"));
        Assert.assertEquals((int)1, (int)myBean.attributesToOpionMap().size());
        myBean.invoke("startMysqld", null, null);
        Assert.assertEquals((Object)"changed", mysqld.getServerOptions().get("foo"));
    }

    public void testFreezeAttributes() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("foo", "bar");
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(null, null, options, new HashMap());
        SimpleMysqldDynamicMBean myBean = new SimpleMysqldDynamicMBean(mysqld);
        MBeanInfo info = myBean.getMBeanInfo();
        MBeanAttributeInfo[] atts = info.getAttributes();
        Assert.assertTrue((boolean)atts[0].isWritable());
        myBean.freezeAttributes();
        info = myBean.getMBeanInfo();
        atts = info.getAttributes();
        Assert.assertFalse((boolean)atts[0].isWritable());
    }

    public void testAttributesFrozenWhenRunning() throws ReflectionException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("foo", "bar");
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(null, null, options, new HashMap());
        SimpleMysqldDynamicMBean myBean = new SimpleMysqldDynamicMBean(mysqld);
        MBeanInfo info = myBean.getMBeanInfo();
        MBeanAttributeInfo[] atts = info.getAttributes();
        Assert.assertTrue((boolean)atts[0].isWritable());
        myBean.invoke("startMysqld", null, null);
        info = myBean.getMBeanInfo();
        atts = info.getAttributes();
        Assert.assertFalse((boolean)atts[0].isWritable());
        myBean.invoke("stop", null, null);
        info = myBean.getMBeanInfo();
        atts = info.getAttributes();
        Assert.assertTrue((boolean)atts[0].isWritable());
    }
}

