/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.DefaultsMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;

public class DefaultsMapTest
extends TestCase {
    DefaultsMap map;

    protected void setUp() {
        this.map = new DefaultsMap();
        this.map.put("foo", "bar");
        this.map.put("stay", "unchanged");
        this.map.put("foo", "baz");
    }

    public void testGetChanged() throws Exception {
        Assert.assertEquals((int)1, (int)this.map.getChanged().size());
        Assert.assertEquals((Object)"baz", this.map.getChanged().get("foo"));
        this.map.put("foo", "bar");
        Assert.assertFalse((boolean)this.map.getChanged().containsKey("foo"));
    }

    public void testContainsValue() throws Exception {
        Assert.assertTrue((boolean)this.map.containsValue("baz"));
        Assert.assertFalse((boolean)this.map.containsValue("bar"));
        Assert.assertFalse((boolean)this.map.containsValue(null));
        this.map.put("null", (Object)null);
        Assert.assertTrue((boolean)this.map.containsValue(null));
    }

    public void testGetAndGetDefault() throws Exception {
        Assert.assertEquals((Object)"bar", (Object)this.map.getDefault("foo"));
        Assert.assertEquals((Object)"baz", (Object)this.map.get("foo"));
        Assert.assertEquals((Object)"unchanged", (Object)this.map.get("stay"));
    }

    public void testContainsKey() throws Exception {
        Assert.assertTrue((boolean)this.map.containsKey("foo"));
        Assert.assertFalse((boolean)this.map.containsKey("bogus"));
    }

    public void testClearAndIsEmpty() {
        Assert.assertFalse((boolean)this.map.isEmpty());
        this.map.clear();
        Assert.assertTrue((boolean)this.map.isEmpty());
        Assert.assertEquals((int)0, (int)this.map.getChanged().size());
        Assert.assertEquals((int)0, (int)this.map.size());
    }

    public void testEntrySet() throws Exception {
        Set entrySet = this.map.entrySet();
        Assert.assertEquals((int)2, (int)entrySet.size());
        ArrayList entries = new ArrayList(entrySet);
        Map.Entry one = (Map.Entry)entries.get(0);
        Assert.assertEquals((Object)"foo", one.getKey());
        Assert.assertEquals((Object)"baz", one.getValue());
        Map.Entry two = (Map.Entry)entries.get(1);
        Assert.assertEquals((Object)"stay", two.getKey());
        Assert.assertEquals((Object)"unchanged", two.getValue());
    }

    public void testPutAll() {
        HashMap<String, String> other = new HashMap<String, String>();
        other.put("foo", "wiz");
        other.put("new", "val");
        this.map.putAll(other);
        Assert.assertEquals((Object)"wiz", (Object)this.map.get("foo"));
        Assert.assertEquals((Object)"val", (Object)this.map.get("new"));
    }

    public void testRemove() {
        Assert.assertEquals((int)1, (int)this.map.getChanged().size());
        this.map.remove("foo");
        Assert.assertEquals((int)0, (int)this.map.getChanged().size());
        Assert.assertFalse((boolean)this.map.containsKey("foo"));
        this.map.put("foo", "two");
        Assert.assertEquals((int)0, (int)this.map.getChanged().size());
        this.map.remove("foo");
        Assert.assertFalse((boolean)this.map.containsKey("foo"));
    }

    public void testValues() {
        Collection values = this.map.values();
        Assert.assertEquals((int)2, (int)values.size());
        Assert.assertTrue((boolean)this.map.containsValue("baz"));
        Assert.assertTrue((boolean)this.map.containsValue("unchanged"));
    }

    public void testPutUnchangedOriginal() {
        Assert.assertEquals((int)1, (int)this.map.getChanged().size());
        this.map.put("stay", "unchanged");
        Assert.assertEquals((int)1, (int)this.map.getChanged().size());
    }
}

