/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.Exceptions;
import com.mysql.management.util.Shell;
import com.mysql.management.util.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;

public class Files {
    public static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    public static final String USE_TEST_DIR = "c-mxj.files.use-test-dir";
    private Shell.Factory shellFactory;
    private char separatorChar;
    private Streams streams;

    public Files() {
        this(new Shell.Factory(), File.separatorChar, new Streams());
    }

    Files(Shell.Factory shellFactory, char separatorChar, Streams streams) {
        this.shellFactory = shellFactory;
        this.separatorChar = separatorChar;
        this.streams = streams;
    }

    public File testDir() {
        return new File(this.tmp(), "test-c.mxj");
    }

    public File tmp() {
        return this.cononical(new File(System.getProperty(JAVA_IO_TMPDIR)));
    }

    public File tmp(String subdir) {
        String useTestDir = System.getProperty(USE_TEST_DIR);
        if (Boolean.TRUE.toString().equalsIgnoreCase(useTestDir)) {
            return new File(this.testDir(), subdir);
        }
        return new File(this.tmp(), subdir);
    }

    public boolean deleteTree(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                this.deleteTree(files[i]);
                ++i;
            }
        }
        return file.delete();
    }

    public void addExecutableRights(File executable, PrintStream out, PrintStream err) {
        if (this.isWindows()) {
            return;
        }
        String[] args = new String[]{"chmod", "+x", executable.getPath()};
        String tName = "make " + executable + " runable";
        this.shellFactory.newShell(args, tName, out, err).run();
    }

    public boolean isWindows() {
        return this.separatorChar == '\\';
    }

    public String asString(final File file) {
        return new Exceptions.StringBlock(){

            public String inner() throws IOException {
                String string;
                FileInputStream fis = new FileInputStream(file);
                try {
                    string = Files.this.streams.readString(fis);
                    Object var2_3 = null;
                }
                catch (Throwable throwable) {
                    Object var2_4 = null;
                    fis.close();
                    throw throwable;
                }
                fis.close();
                return string;
            }
        }.exec();
    }

    public File nullFile() {
        return new File("");
    }

    public File newFile(Object fileName) {
        if (fileName == null) {
            return this.nullFile();
        }
        return this.cononical(new File(fileName.toString()));
    }

    public File cononical(final File file) {
        if (file == null) {
            throw new IllegalArgumentException("File may not be null");
        }
        return (File)new Exceptions.Block(){

            protected Object inner() throws Exception {
                return file.getCanonicalFile();
            }
        }.exec();
    }

    public String getPath(final File file) {
        return (String)new Exceptions.Block(){

            protected Object inner() throws Exception {
                return file.getCanonicalPath();
            }
        }.exec();
    }

    public boolean cleanTestDir() {
        return this.deleteTree(this.testDir());
    }

    public File validCononicalDir(File dir, File defaultDir) {
        if (dir == null || dir.equals(this.nullFile())) {
            dir = defaultDir;
        }
        return this.validCononicalDir(dir);
    }

    public File validCononicalDir(File dir) {
        File cononical = this.cononical(dir);
        if (!cononical.exists()) {
            cononical.mkdirs();
        }
        if (!cononical.isDirectory()) {
            throw new IllegalArgumentException(cononical + " not a directory");
        }
        return cononical;
    }
}

