/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.Files;
import com.mysql.management.util.FilesTest;
import com.mysql.management.util.Shell;
import com.mysql.management.util.Streams;
import com.mysql.management.util.TestUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import junit.framework.Assert;
import junit.framework.TestCase;

public class FilesTest
extends TestCase {
    Files fileUtil;

    protected void setUp() {
        this.fileUtil = new Files();
    }

    public void testTempDir() {
        String property = System.getProperty("java.io.tmpdir");
        Assert.assertNotNull((Object)property);
        File javaTmp = new File(property);
        Assert.assertEquals((String)javaTmp.getPath(), (boolean)true, (boolean)javaTmp.exists());
        Assert.assertEquals((Object)javaTmp, (Object)this.fileUtil.testDir().getParentFile());
    }

    public void testDeleteTree() throws FileNotFoundException {
        File foo = new File(this.fileUtil.testDir(), "foo");
        File bar = new File(foo, "bar");
        bar.mkdirs();
        Assert.assertEquals((boolean)true, (boolean)bar.exists());
        File baz = new File(foo, "baz");
        FileOutputStream fos = new FileOutputStream(baz);
        PrintWriter out = new PrintWriter(fos);
        out.print("baz");
        out.close();
        Assert.assertEquals((boolean)true, (boolean)baz.exists());
        Assert.assertEquals((long)3L, (long)baz.length());
        Assert.assertEquals((boolean)true, (boolean)this.fileUtil.deleteTree(foo));
        Assert.assertEquals((boolean)false, (boolean)foo.exists());
    }

    public void testMakeExecutable() {
        class FakeShellStub
        extends Shell.Stub {
            String[] args;
            int runCalled;
            final /* synthetic */ FilesTest this$0;

            FakeShellStub(FilesTest filesTest) {
                this.this$0 = filesTest;
                this.runCalled = 0;
            }

            public void run() {
                ++this.runCalled;
            }
        }
        FakeShellStub shell = new FakeShellStub(this);
        class FakeShellFactory
        extends Shell.Factory {
            final /* synthetic */ FilesTest this$0;
            private final /* synthetic */ FakeShellStub val$shell;

            FakeShellFactory(FilesTest filesTest, FakeShellStub fakeShellStub) {
                this.this$0 = filesTest;
                this.val$shell = fakeShellStub;
            }

            public Shell newShell(String[] args, String name, PrintStream out, PrintStream err) {
                Assert.assertNotNull((Object)name);
                Assert.assertNotNull((Object)out);
                Assert.assertNotNull((Object)err);
                this.val$shell.args = args;
                return this.val$shell;
            }
        }
        this.fileUtil = new Files(new FakeShellFactory(this, shell), '\\', new Streams());
        this.fileUtil.addExecutableRights(new File("bogus"), System.out, System.err);
        Assert.assertNull((Object)shell.args);
        Assert.assertEquals((int)0, (int)shell.runCalled);
        this.fileUtil = new Files(new FakeShellFactory(this, shell), '/', new Streams());
        this.fileUtil.addExecutableRights(new File("bogus"), System.out, System.err);
        Assert.assertEquals((int)1, (int)shell.runCalled);
        Assert.assertEquals((int)3, (int)shell.args.length);
        Assert.assertEquals((String)"chmod", (String)shell.args[0]);
        Assert.assertEquals((String)"+x", (String)shell.args[1]);
        Assert.assertTrue((shell.args[2].indexOf("bogus") >= 0 ? 1 : 0) != 0);
    }

    public void testValidCononicalDir() throws Exception {
        File foo = this.fileUtil.tmp("foo");
        File cononicalFoo = foo.getCanonicalFile();
        File defaultDir = this.fileUtil.tmp("defaultDir");
        File valid = this.fileUtil.validCononicalDir(foo);
        Assert.assertEquals((Object)cononicalFoo, (Object)valid);
        valid = this.fileUtil.validCononicalDir(foo, defaultDir);
        Assert.assertEquals((Object)cononicalFoo, (Object)valid);
        valid = this.fileUtil.validCononicalDir(null, defaultDir);
        Assert.assertEquals((Object)defaultDir, (Object)valid);
        File bar = new File(this.fileUtil.testDir(), "junkFile.txt");
        bar.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(bar);
        PrintStream ps = new PrintStream(fos);
        ps.println("junk");
        ps.close();
        TestUtil testUtil = new TestUtil();
        IllegalArgumentException expected = null;
        try {
            this.fileUtil.validCononicalDir(bar);
        }
        catch (IllegalArgumentException e) {
            expected = e;
        }
        Assert.assertNotNull((Object)expected);
        testUtil.assertContainsIgnoreCase(expected.getMessage(), "directory");
        expected = null;
        try {
            this.fileUtil.validCononicalDir(null);
        }
        catch (IllegalArgumentException e) {
            expected = e;
        }
        Assert.assertNotNull((Object)expected);
        testUtil.assertContainsIgnoreCase(expected.getMessage(), "null");
    }
}

