/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.MapEntry;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;

public class MapEntryTest
extends TestCase {
    private Map.Entry entry;
    private Map.Entry hashMapEntry;

    protected void setUp() throws Exception {
        this.setEntries("foo", "bar");
    }

    private void setEntries(String key, String val) {
        this.entry = new MapEntry(key, val);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, val);
        this.hashMapEntry = map.entrySet().iterator().next();
    }

    public void testGetters() {
        Assert.assertEquals(this.hashMapEntry.getKey(), this.entry.getKey());
        Assert.assertEquals(this.hashMapEntry.getValue(), this.entry.getValue());
    }

    public void testEquallity() {
        Assert.assertTrue((boolean)this.entry.equals(this.entry));
        Assert.assertEquals((int)this.hashMapEntry.hashCode(), (int)this.entry.hashCode());
        Assert.assertTrue((boolean)this.hashMapEntry.equals(this.entry));
        Assert.assertTrue((boolean)this.entry.equals(this.hashMapEntry));
        Assert.assertFalse((boolean)this.entry.equals(this.hashMapEntry.toString()));
        Assert.assertFalse((boolean)this.entry.equals(new MapEntry(this.entry.getKey(), this.entry.getKey())));
        Assert.assertFalse((boolean)((MapEntry)this.entry).equals(null));
    }

    public void testToString() {
        Assert.assertEquals((String)this.hashMapEntry.toString(), (String)this.entry.toString());
    }

    public void testHashCode() throws Exception {
        Assert.assertEquals((int)this.hashMapEntry.hashCode(), (int)this.entry.hashCode());
        this.setEntries("foo", null);
        Assert.assertEquals((int)this.hashMapEntry.hashCode(), (int)this.entry.hashCode());
        this.setEntries(null, "bar");
        Assert.assertEquals((int)this.hashMapEntry.hashCode(), (int)this.entry.hashCode());
        this.setEntries(null, null);
        Assert.assertEquals((int)this.hashMapEntry.hashCode(), (int)this.entry.hashCode());
    }

    public void testSetter() {
        this.entry.setValue("baz");
        this.hashMapEntry.setValue("baz");
        this.testGetters();
        this.testEquallity();
    }
}

