/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.Files;
import com.mysql.management.util.NullPrintStream;
import com.mysql.management.util.ProcessUtil;
import com.mysql.management.util.TestUtil;
import com.mysql.management.util.Utils;
import java.io.File;
import java.io.PrintStream;
import junit.framework.Assert;
import junit.framework.TestCase;

public class ProcessUtilTest
extends TestCase {
    private File dir = new File(new Files().testDir(), "ProcUtiTest");
    private PrintStream devNull = new NullPrintStream();

    public void testNullPid() {
        ProcessUtil kp = new ProcessUtil(null, this.devNull, this.devNull, this.dir);
        Assert.assertEquals((String)"-1", (String)kp.pid());
    }

    public void testPidWithEOL() {
        String pid = " 3343\n";
        ProcessUtil kp = new ProcessUtil(pid, this.devNull, this.devNull, this.dir);
        Assert.assertEquals((String)"3343", (String)kp.pid());
    }

    public void testKillCommandLineUnix() {
        Utils utils = new Utils();
        utils.setFiles(new Files(){

            public boolean isWindows() {
                return false;
            }
        });
        String pid = "2342";
        ProcessUtil kp = new ProcessUtil(pid, this.devNull, this.devNull, this.dir, utils);
        String[] args = kp.killArgs(false);
        Assert.assertEquals((String)args[0], (String)"kill");
        Assert.assertEquals((String)pid, (String)args[args.length - 1]);
    }

    public void testKillCommandLineWindows() {
        Utils utils = new Utils();
        utils.setFiles(new Files(){

            public boolean isWindows() {
                return true;
            }
        });
        String pid = "2342";
        ProcessUtil kp = new ProcessUtil(pid, this.devNull, this.devNull, this.dir, utils);
        String[] args = kp.killArgs(false);
        Assert.assertTrue((String)args[0], (boolean)args[0].endsWith("kill.exe"));
        Assert.assertEquals((String)pid, (String)args[args.length - 1]);
    }

    public void testForce() {
        ProcessUtil kp = new ProcessUtil("4321", this.devNull, this.devNull, this.dir);
        String[] args = kp.killArgs(true);
        Assert.assertEquals((String)"-9", (String)args[1]);
    }

    public void testIsRunning() {
        String pid = "5234";
        ProcessUtil kp = new ProcessUtil(pid, this.devNull, this.devNull, this.dir);
        String[] args = kp.isRunningArgs();
        new TestUtil().assertContainsIgnoreCase(args[0], "kill");
        Assert.assertEquals((String)"-0", (String)args[1]);
        Assert.assertEquals((String)pid, (String)args[2]);
    }

    public void testFileCreation() {
        ProcessUtil pu = new ProcessUtil("1234", this.devNull, this.devNull, this.dir);
        File winKill = pu.getWindowsKillFile();
        Assert.assertTrue((boolean)winKill.exists());
        winKill.delete();
        Assert.assertFalse((boolean)winKill.exists());
        winKill = pu.getWindowsKillFile();
        Assert.assertTrue((boolean)winKill.exists());
    }
}

