/*
 * Copyright (c) 2015, 2024, Oracle and/or its affiliates.
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License, version 2.0, as published by
 * the Free Software Foundation.
 *
 * This program is designed to work with certain software that is licensed under separate terms, as designated in a particular file or component or in
 * included license documentation. The authors of MySQL hereby grant you an additional permission to link the program and your derivative works with the
 * separately licensed software that they have either included with the program or referenced in the documentation.
 *
 * Without limiting anything contained in the foregoing, this file, which is part of MySQL Connector/J, is also subject to the Universal FOSS Exception,
 * version 1.0, a copy of which can be found at http://oss.oracle.com/licenses/universal-foss-exception.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License, version 2.0, for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

package com.mysql.cj.x.protobuf;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: mysqlx_expr.proto
// Protobuf Java Version: 4.29.0

public final class MysqlxExpr {
  private MysqlxExpr() {}
  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
      com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
      /* major= */ 4,
      /* minor= */ 29,
      /* patch= */ 0,
      /* suffix= */ "",
      MysqlxExpr.class.getName());
  }
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  public interface ExprOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Expr.Expr)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .Mysqlx.Expr.Expr.Type type = 1;</code>
     * @return Whether the type field is set.
     */
    boolean hasType();
    /**
     * <code>required .Mysqlx.Expr.Expr.Type type = 1;</code>
     * @return The type.
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type getType();

    /**
     * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
     * @return Whether the identifier field is set.
     */
    boolean hasIdentifier();
    /**
     * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
     * @return The identifier.
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier getIdentifier();
    /**
     * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifierOrBuilder getIdentifierOrBuilder();

    /**
     * <code>optional string variable = 3;</code>
     * @return Whether the variable field is set.
     */
    boolean hasVariable();
    /**
     * <code>optional string variable = 3;</code>
     * @return The variable.
     */
    java.lang.String getVariable();
    /**
     * <code>optional string variable = 3;</code>
     * @return The bytes for variable.
     */
    com.google.protobuf.ByteString
        getVariableBytes();

    /**
     * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
     * @return Whether the literal field is set.
     */
    boolean hasLiteral();
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
     * @return The literal.
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getLiteral();
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getLiteralOrBuilder();

    /**
     * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
     * @return Whether the functionCall field is set.
     */
    boolean hasFunctionCall();
    /**
     * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
     * @return The functionCall.
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall getFunctionCall();
    /**
     * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCallOrBuilder getFunctionCallOrBuilder();

    /**
     * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
     * @return Whether the operator field is set.
     */
    boolean hasOperator();
    /**
     * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
     * @return The operator.
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Operator getOperator();
    /**
     * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.OperatorOrBuilder getOperatorOrBuilder();

    /**
     * <code>optional uint32 position = 7;</code>
     * @return Whether the position field is set.
     */
    boolean hasPosition();
    /**
     * <code>optional uint32 position = 7;</code>
     * @return The position.
     */
    int getPosition();

    /**
     * <code>optional .Mysqlx.Expr.Object object = 8;</code>
     * @return Whether the object field is set.
     */
    boolean hasObject();
    /**
     * <code>optional .Mysqlx.Expr.Object object = 8;</code>
     * @return The object.
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Object getObject();
    /**
     * <code>optional .Mysqlx.Expr.Object object = 8;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ObjectOrBuilder getObjectOrBuilder();

    /**
     * <code>optional .Mysqlx.Expr.Array array = 9;</code>
     * @return Whether the array field is set.
     */
    boolean hasArray();
    /**
     * <code>optional .Mysqlx.Expr.Array array = 9;</code>
     * @return The array.
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Array getArray();
    /**
     * <code>optional .Mysqlx.Expr.Array array = 9;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ArrayOrBuilder getArrayOrBuilder();
  }
  /**
   * <pre>
   * *
   * The "root" of the expression tree.
   *
   * If expression type is PLACEHOLDER, then it refers to the value
   * of a parameter specified when executing a statement (see args
   * field of StmtExecute command). Field position (which must be
   * present for such an expression) gives 0-based position of the
   * parameter in the parameter list.
   *
   * &#64;par production list
   * &#64;code{unparsed}
   * expr: operator |
   * : identifier |
   * : function_call |
   * : variable |
   * : literal |
   * : object |
   * : array |
   * : placeholder
   * &#64;endcode
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Expr.Expr}
   */
  public static final class Expr extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Expr.Expr)
      ExprOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        Expr.class.getName());
    }
    // Use Expr.newBuilder() to construct.
    private Expr(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private Expr() {
      type_ = 1;
      variable_ = "";
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Expr_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Expr_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr.class, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder.class);
    }

    /**
     * Protobuf enum {@code Mysqlx.Expr.Expr.Type}
     */
    public enum Type
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>IDENT = 1;</code>
       */
      IDENT(1),
      /**
       * <code>LITERAL = 2;</code>
       */
      LITERAL(2),
      /**
       * <code>VARIABLE = 3;</code>
       */
      VARIABLE(3),
      /**
       * <code>FUNC_CALL = 4;</code>
       */
      FUNC_CALL(4),
      /**
       * <code>OPERATOR = 5;</code>
       */
      OPERATOR(5),
      /**
       * <code>PLACEHOLDER = 6;</code>
       */
      PLACEHOLDER(6),
      /**
       * <code>OBJECT = 7;</code>
       */
      OBJECT(7),
      /**
       * <code>ARRAY = 8;</code>
       */
      ARRAY(8),
      ;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 29,
          /* patch= */ 0,
          /* suffix= */ "",
          Type.class.getName());
      }
      /**
       * <code>IDENT = 1;</code>
       */
      public static final int IDENT_VALUE = 1;
      /**
       * <code>LITERAL = 2;</code>
       */
      public static final int LITERAL_VALUE = 2;
      /**
       * <code>VARIABLE = 3;</code>
       */
      public static final int VARIABLE_VALUE = 3;
      /**
       * <code>FUNC_CALL = 4;</code>
       */
      public static final int FUNC_CALL_VALUE = 4;
      /**
       * <code>OPERATOR = 5;</code>
       */
      public static final int OPERATOR_VALUE = 5;
      /**
       * <code>PLACEHOLDER = 6;</code>
       */
      public static final int PLACEHOLDER_VALUE = 6;
      /**
       * <code>OBJECT = 7;</code>
       */
      public static final int OBJECT_VALUE = 7;
      /**
       * <code>ARRAY = 8;</code>
       */
      public static final int ARRAY_VALUE = 8;


      public final int getNumber() {
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Type valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Type forNumber(int value) {
        switch (value) {
          case 1: return IDENT;
          case 2: return LITERAL;
          case 3: return VARIABLE;
          case 4: return FUNC_CALL;
          case 5: return OPERATOR;
          case 6: return PLACEHOLDER;
          case 7: return OBJECT;
          case 8: return ARRAY;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          Type> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Type>() {
              public Type findValueByNumber(int number) {
                return Type.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDescriptor().getEnumTypes().get(0);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Type(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Expr.Expr.Type)
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_ = 1;
    /**
     * <code>required .Mysqlx.Expr.Expr.Type type = 1;</code>
     * @return Whether the type field is set.
     */
    @java.lang.Override public boolean hasType() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required .Mysqlx.Expr.Expr.Type type = 1;</code>
     * @return The type.
     */
    @java.lang.Override public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type getType() {
      com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type result = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type.forNumber(type_);
      return result == null ? com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type.IDENT : result;
    }

    public static final int IDENTIFIER_FIELD_NUMBER = 2;
    private com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier identifier_;
    /**
     * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
     * @return Whether the identifier field is set.
     */
    @java.lang.Override
    public boolean hasIdentifier() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
     * @return The identifier.
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier getIdentifier() {
      return identifier_ == null ? com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.getDefaultInstance() : identifier_;
    }
    /**
     * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifierOrBuilder getIdentifierOrBuilder() {
      return identifier_ == null ? com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.getDefaultInstance() : identifier_;
    }

    public static final int VARIABLE_FIELD_NUMBER = 3;
    @SuppressWarnings("serial")
    private volatile java.lang.Object variable_ = "";
    /**
     * <code>optional string variable = 3;</code>
     * @return Whether the variable field is set.
     */
    @java.lang.Override
    public boolean hasVariable() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional string variable = 3;</code>
     * @return The variable.
     */
    @java.lang.Override
    public java.lang.String getVariable() {
      java.lang.Object ref = variable_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          variable_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string variable = 3;</code>
     * @return The bytes for variable.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getVariableBytes() {
      java.lang.Object ref = variable_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        variable_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LITERAL_FIELD_NUMBER = 4;
    private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar literal_;
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
     * @return Whether the literal field is set.
     */
    @java.lang.Override
    public boolean hasLiteral() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
     * @return The literal.
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getLiteral() {
      return literal_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance() : literal_;
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getLiteralOrBuilder() {
      return literal_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance() : literal_;
    }

    public static final int FUNCTION_CALL_FIELD_NUMBER = 5;
    private com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall functionCall_;
    /**
     * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
     * @return Whether the functionCall field is set.
     */
    @java.lang.Override
    public boolean hasFunctionCall() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
     * @return The functionCall.
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall getFunctionCall() {
      return functionCall_ == null ? com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.getDefaultInstance() : functionCall_;
    }
    /**
     * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCallOrBuilder getFunctionCallOrBuilder() {
      return functionCall_ == null ? com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.getDefaultInstance() : functionCall_;
    }

    public static final int OPERATOR_FIELD_NUMBER = 6;
    private com.mysql.cj.x.protobuf.MysqlxExpr.Operator operator_;
    /**
     * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
     * @return Whether the operator field is set.
     */
    @java.lang.Override
    public boolean hasOperator() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
     * @return The operator.
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.Operator getOperator() {
      return operator_ == null ? com.mysql.cj.x.protobuf.MysqlxExpr.Operator.getDefaultInstance() : operator_;
    }
    /**
     * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.OperatorOrBuilder getOperatorOrBuilder() {
      return operator_ == null ? com.mysql.cj.x.protobuf.MysqlxExpr.Operator.getDefaultInstance() : operator_;
    }

    public static final int POSITION_FIELD_NUMBER = 7;
    private int position_ = 0;
    /**
     * <code>optional uint32 position = 7;</code>
     * @return Whether the position field is set.
     */
    @java.lang.Override
    public boolean hasPosition() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <code>optional uint32 position = 7;</code>
     * @return The position.
     */
    @java.lang.Override
    public int getPosition() {
      return position_;
    }

    public static final int OBJECT_FIELD_NUMBER = 8;
    private com.mysql.cj.x.protobuf.MysqlxExpr.Object object_;
    /**
     * <code>optional .Mysqlx.Expr.Object object = 8;</code>
     * @return Whether the object field is set.
     */
    @java.lang.Override
    public boolean hasObject() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     * <code>optional .Mysqlx.Expr.Object object = 8;</code>
     * @return The object.
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.Object getObject() {
      return object_ == null ? com.mysql.cj.x.protobuf.MysqlxExpr.Object.getDefaultInstance() : object_;
    }
    /**
     * <code>optional .Mysqlx.Expr.Object object = 8;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.ObjectOrBuilder getObjectOrBuilder() {
      return object_ == null ? com.mysql.cj.x.protobuf.MysqlxExpr.Object.getDefaultInstance() : object_;
    }

    public static final int ARRAY_FIELD_NUMBER = 9;
    private com.mysql.cj.x.protobuf.MysqlxExpr.Array array_;
    /**
     * <code>optional .Mysqlx.Expr.Array array = 9;</code>
     * @return Whether the array field is set.
     */
    @java.lang.Override
    public boolean hasArray() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     * <code>optional .Mysqlx.Expr.Array array = 9;</code>
     * @return The array.
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.Array getArray() {
      return array_ == null ? com.mysql.cj.x.protobuf.MysqlxExpr.Array.getDefaultInstance() : array_;
    }
    /**
     * <code>optional .Mysqlx.Expr.Array array = 9;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.ArrayOrBuilder getArrayOrBuilder() {
      return array_ == null ? com.mysql.cj.x.protobuf.MysqlxExpr.Array.getDefaultInstance() : array_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasType()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasIdentifier()) {
        if (!getIdentifier().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasLiteral()) {
        if (!getLiteral().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasFunctionCall()) {
        if (!getFunctionCall().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasOperator()) {
        if (!getOperator().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasObject()) {
        if (!getObject().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasArray()) {
        if (!getArray().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(1, type_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getIdentifier());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 3, variable_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeMessage(4, getLiteral());
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        output.writeMessage(5, getFunctionCall());
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        output.writeMessage(6, getOperator());
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        output.writeUInt32(7, position_);
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        output.writeMessage(8, getObject());
      }
      if (((bitField0_ & 0x00000100) != 0)) {
        output.writeMessage(9, getArray());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, type_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getIdentifier());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(3, variable_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getLiteral());
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, getFunctionCall());
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, getOperator());
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(7, position_);
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(8, getObject());
      }
      if (((bitField0_ & 0x00000100) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(9, getArray());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxExpr.Expr)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxExpr.Expr other = (com.mysql.cj.x.protobuf.MysqlxExpr.Expr) obj;

      if (hasType() != other.hasType()) return false;
      if (hasType()) {
        if (type_ != other.type_) return false;
      }
      if (hasIdentifier() != other.hasIdentifier()) return false;
      if (hasIdentifier()) {
        if (!getIdentifier()
            .equals(other.getIdentifier())) return false;
      }
      if (hasVariable() != other.hasVariable()) return false;
      if (hasVariable()) {
        if (!getVariable()
            .equals(other.getVariable())) return false;
      }
      if (hasLiteral() != other.hasLiteral()) return false;
      if (hasLiteral()) {
        if (!getLiteral()
            .equals(other.getLiteral())) return false;
      }
      if (hasFunctionCall() != other.hasFunctionCall()) return false;
      if (hasFunctionCall()) {
        if (!getFunctionCall()
            .equals(other.getFunctionCall())) return false;
      }
      if (hasOperator() != other.hasOperator()) return false;
      if (hasOperator()) {
        if (!getOperator()
            .equals(other.getOperator())) return false;
      }
      if (hasPosition() != other.hasPosition()) return false;
      if (hasPosition()) {
        if (getPosition()
            != other.getPosition()) return false;
      }
      if (hasObject() != other.hasObject()) return false;
      if (hasObject()) {
        if (!getObject()
            .equals(other.getObject())) return false;
      }
      if (hasArray() != other.hasArray()) return false;
      if (hasArray()) {
        if (!getArray()
            .equals(other.getArray())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasType()) {
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + type_;
      }
      if (hasIdentifier()) {
        hash = (37 * hash) + IDENTIFIER_FIELD_NUMBER;
        hash = (53 * hash) + getIdentifier().hashCode();
      }
      if (hasVariable()) {
        hash = (37 * hash) + VARIABLE_FIELD_NUMBER;
        hash = (53 * hash) + getVariable().hashCode();
      }
      if (hasLiteral()) {
        hash = (37 * hash) + LITERAL_FIELD_NUMBER;
        hash = (53 * hash) + getLiteral().hashCode();
      }
      if (hasFunctionCall()) {
        hash = (37 * hash) + FUNCTION_CALL_FIELD_NUMBER;
        hash = (53 * hash) + getFunctionCall().hashCode();
      }
      if (hasOperator()) {
        hash = (37 * hash) + OPERATOR_FIELD_NUMBER;
        hash = (53 * hash) + getOperator().hashCode();
      }
      if (hasPosition()) {
        hash = (37 * hash) + POSITION_FIELD_NUMBER;
        hash = (53 * hash) + getPosition();
      }
      if (hasObject()) {
        hash = (37 * hash) + OBJECT_FIELD_NUMBER;
        hash = (53 * hash) + getObject().hashCode();
      }
      if (hasArray()) {
        hash = (37 * hash) + ARRAY_FIELD_NUMBER;
        hash = (53 * hash) + getArray().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxExpr.Expr prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * The "root" of the expression tree.
     *
     * If expression type is PLACEHOLDER, then it refers to the value
     * of a parameter specified when executing a statement (see args
     * field of StmtExecute command). Field position (which must be
     * present for such an expression) gives 0-based position of the
     * parameter in the parameter list.
     *
     * &#64;par production list
     * &#64;code{unparsed}
     * expr: operator |
     * : identifier |
     * : function_call |
     * : variable |
     * : literal |
     * : object |
     * : array |
     * : placeholder
     * &#64;endcode
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Expr.Expr}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Expr.Expr)
        com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Expr_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Expr_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxExpr.Expr.class, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxExpr.Expr.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage
                .alwaysUseFieldBuilders) {
          getIdentifierFieldBuilder();
          getLiteralFieldBuilder();
          getFunctionCallFieldBuilder();
          getOperatorFieldBuilder();
          getObjectFieldBuilder();
          getArrayFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        type_ = 1;
        identifier_ = null;
        if (identifierBuilder_ != null) {
          identifierBuilder_.dispose();
          identifierBuilder_ = null;
        }
        variable_ = "";
        literal_ = null;
        if (literalBuilder_ != null) {
          literalBuilder_.dispose();
          literalBuilder_ = null;
        }
        functionCall_ = null;
        if (functionCallBuilder_ != null) {
          functionCallBuilder_.dispose();
          functionCallBuilder_ = null;
        }
        operator_ = null;
        if (operatorBuilder_ != null) {
          operatorBuilder_.dispose();
          operatorBuilder_ = null;
        }
        position_ = 0;
        object_ = null;
        if (objectBuilder_ != null) {
          objectBuilder_.dispose();
          objectBuilder_ = null;
        }
        array_ = null;
        if (arrayBuilder_ != null) {
          arrayBuilder_.dispose();
          arrayBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Expr_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr build() {
        com.mysql.cj.x.protobuf.MysqlxExpr.Expr result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxExpr.Expr result = new com.mysql.cj.x.protobuf.MysqlxExpr.Expr(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxExpr.Expr result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.type_ = type_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.identifier_ = identifierBuilder_ == null
              ? identifier_
              : identifierBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.variable_ = variable_;
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.literal_ = literalBuilder_ == null
              ? literal_
              : literalBuilder_.build();
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.functionCall_ = functionCallBuilder_ == null
              ? functionCall_
              : functionCallBuilder_.build();
          to_bitField0_ |= 0x00000010;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.operator_ = operatorBuilder_ == null
              ? operator_
              : operatorBuilder_.build();
          to_bitField0_ |= 0x00000020;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.position_ = position_;
          to_bitField0_ |= 0x00000040;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.object_ = objectBuilder_ == null
              ? object_
              : objectBuilder_.build();
          to_bitField0_ |= 0x00000080;
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.array_ = arrayBuilder_ == null
              ? array_
              : arrayBuilder_.build();
          to_bitField0_ |= 0x00000100;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxExpr.Expr) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxExpr.Expr)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxExpr.Expr other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance()) return this;
        if (other.hasType()) {
          setType(other.getType());
        }
        if (other.hasIdentifier()) {
          mergeIdentifier(other.getIdentifier());
        }
        if (other.hasVariable()) {
          variable_ = other.variable_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.hasLiteral()) {
          mergeLiteral(other.getLiteral());
        }
        if (other.hasFunctionCall()) {
          mergeFunctionCall(other.getFunctionCall());
        }
        if (other.hasOperator()) {
          mergeOperator(other.getOperator());
        }
        if (other.hasPosition()) {
          setPosition(other.getPosition());
        }
        if (other.hasObject()) {
          mergeObject(other.getObject());
        }
        if (other.hasArray()) {
          mergeArray(other.getArray());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasType()) {
          return false;
        }
        if (hasIdentifier()) {
          if (!getIdentifier().isInitialized()) {
            return false;
          }
        }
        if (hasLiteral()) {
          if (!getLiteral().isInitialized()) {
            return false;
          }
        }
        if (hasFunctionCall()) {
          if (!getFunctionCall().isInitialized()) {
            return false;
          }
        }
        if (hasOperator()) {
          if (!getOperator().isInitialized()) {
            return false;
          }
        }
        if (hasObject()) {
          if (!getObject().isInitialized()) {
            return false;
          }
        }
        if (hasArray()) {
          if (!getArray().isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                int tmpRaw = input.readEnum();
                com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type tmpValue =
                    com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type.forNumber(tmpRaw);
                if (tmpValue == null) {
                  mergeUnknownVarintField(1, tmpRaw);
                } else {
                  type_ = tmpRaw;
                  bitField0_ |= 0x00000001;
                }
                break;
              } // case 8
              case 18: {
                input.readMessage(
                    getIdentifierFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                variable_ = input.readBytes();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              case 34: {
                input.readMessage(
                    getLiteralFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
              case 42: {
                input.readMessage(
                    getFunctionCallFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
              case 50: {
                input.readMessage(
                    getOperatorFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
              case 56: {
                position_ = input.readUInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
              case 66: {
                input.readMessage(
                    getObjectFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
              case 74: {
                input.readMessage(
                    getArrayFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int type_ = 1;
      /**
       * <code>required .Mysqlx.Expr.Expr.Type type = 1;</code>
       * @return Whether the type field is set.
       */
      @java.lang.Override public boolean hasType() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .Mysqlx.Expr.Expr.Type type = 1;</code>
       * @return The type.
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type getType() {
        com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type result = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type.forNumber(type_);
        return result == null ? com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type.IDENT : result;
      }
      /**
       * <code>required .Mysqlx.Expr.Expr.Type type = 1;</code>
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>required .Mysqlx.Expr.Expr.Type type = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = 1;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier identifier_;
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier, com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifierOrBuilder> identifierBuilder_;
      /**
       * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
       * @return Whether the identifier field is set.
       */
      public boolean hasIdentifier() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
       * @return The identifier.
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier getIdentifier() {
        if (identifierBuilder_ == null) {
          return identifier_ == null ? com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.getDefaultInstance() : identifier_;
        } else {
          return identifierBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
       */
      public Builder setIdentifier(com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier value) {
        if (identifierBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          identifier_ = value;
        } else {
          identifierBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
       */
      public Builder setIdentifier(
          com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.Builder builderForValue) {
        if (identifierBuilder_ == null) {
          identifier_ = builderForValue.build();
        } else {
          identifierBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
       */
      public Builder mergeIdentifier(com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier value) {
        if (identifierBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
            identifier_ != null &&
            identifier_ != com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.getDefaultInstance()) {
            getIdentifierBuilder().mergeFrom(value);
          } else {
            identifier_ = value;
          }
        } else {
          identifierBuilder_.mergeFrom(value);
        }
        if (identifier_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
       */
      public Builder clearIdentifier() {
        bitField0_ = (bitField0_ & ~0x00000002);
        identifier_ = null;
        if (identifierBuilder_ != null) {
          identifierBuilder_.dispose();
          identifierBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.Builder getIdentifierBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getIdentifierFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifierOrBuilder getIdentifierOrBuilder() {
        if (identifierBuilder_ != null) {
          return identifierBuilder_.getMessageOrBuilder();
        } else {
          return identifier_ == null ?
              com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.getDefaultInstance() : identifier_;
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.ColumnIdentifier identifier = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier, com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifierOrBuilder> 
          getIdentifierFieldBuilder() {
        if (identifierBuilder_ == null) {
          identifierBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier, com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifierOrBuilder>(
                  getIdentifier(),
                  getParentForChildren(),
                  isClean());
          identifier_ = null;
        }
        return identifierBuilder_;
      }

      private java.lang.Object variable_ = "";
      /**
       * <code>optional string variable = 3;</code>
       * @return Whether the variable field is set.
       */
      public boolean hasVariable() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional string variable = 3;</code>
       * @return The variable.
       */
      public java.lang.String getVariable() {
        java.lang.Object ref = variable_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            variable_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string variable = 3;</code>
       * @return The bytes for variable.
       */
      public com.google.protobuf.ByteString
          getVariableBytes() {
        java.lang.Object ref = variable_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          variable_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string variable = 3;</code>
       * @param value The variable to set.
       * @return This builder for chaining.
       */
      public Builder setVariable(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        variable_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>optional string variable = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearVariable() {
        variable_ = getDefaultInstance().getVariable();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       * <code>optional string variable = 3;</code>
       * @param value The bytes for variable to set.
       * @return This builder for chaining.
       */
      public Builder setVariableBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        variable_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar literal_;
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> literalBuilder_;
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
       * @return Whether the literal field is set.
       */
      public boolean hasLiteral() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
       * @return The literal.
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getLiteral() {
        if (literalBuilder_ == null) {
          return literal_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance() : literal_;
        } else {
          return literalBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
       */
      public Builder setLiteral(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (literalBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          literal_ = value;
        } else {
          literalBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
       */
      public Builder setLiteral(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder builderForValue) {
        if (literalBuilder_ == null) {
          literal_ = builderForValue.build();
        } else {
          literalBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
       */
      public Builder mergeLiteral(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (literalBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0) &&
            literal_ != null &&
            literal_ != com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance()) {
            getLiteralBuilder().mergeFrom(value);
          } else {
            literal_ = value;
          }
        } else {
          literalBuilder_.mergeFrom(value);
        }
        if (literal_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
       */
      public Builder clearLiteral() {
        bitField0_ = (bitField0_ & ~0x00000008);
        literal_ = null;
        if (literalBuilder_ != null) {
          literalBuilder_.dispose();
          literalBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder getLiteralBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getLiteralFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getLiteralOrBuilder() {
        if (literalBuilder_ != null) {
          return literalBuilder_.getMessageOrBuilder();
        } else {
          return literal_ == null ?
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance() : literal_;
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar literal = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
          getLiteralFieldBuilder() {
        if (literalBuilder_ == null) {
          literalBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder>(
                  getLiteral(),
                  getParentForChildren(),
                  isClean());
          literal_ = null;
        }
        return literalBuilder_;
      }

      private com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall functionCall_;
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall, com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCallOrBuilder> functionCallBuilder_;
      /**
       * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
       * @return Whether the functionCall field is set.
       */
      public boolean hasFunctionCall() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
       * @return The functionCall.
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall getFunctionCall() {
        if (functionCallBuilder_ == null) {
          return functionCall_ == null ? com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.getDefaultInstance() : functionCall_;
        } else {
          return functionCallBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
       */
      public Builder setFunctionCall(com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall value) {
        if (functionCallBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          functionCall_ = value;
        } else {
          functionCallBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
       */
      public Builder setFunctionCall(
          com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.Builder builderForValue) {
        if (functionCallBuilder_ == null) {
          functionCall_ = builderForValue.build();
        } else {
          functionCallBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
       */
      public Builder mergeFunctionCall(com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall value) {
        if (functionCallBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0) &&
            functionCall_ != null &&
            functionCall_ != com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.getDefaultInstance()) {
            getFunctionCallBuilder().mergeFrom(value);
          } else {
            functionCall_ = value;
          }
        } else {
          functionCallBuilder_.mergeFrom(value);
        }
        if (functionCall_ != null) {
          bitField0_ |= 0x00000010;
          onChanged();
        }
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
       */
      public Builder clearFunctionCall() {
        bitField0_ = (bitField0_ & ~0x00000010);
        functionCall_ = null;
        if (functionCallBuilder_ != null) {
          functionCallBuilder_.dispose();
          functionCallBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.Builder getFunctionCallBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getFunctionCallFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCallOrBuilder getFunctionCallOrBuilder() {
        if (functionCallBuilder_ != null) {
          return functionCallBuilder_.getMessageOrBuilder();
        } else {
          return functionCall_ == null ?
              com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.getDefaultInstance() : functionCall_;
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.FunctionCall function_call = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall, com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCallOrBuilder> 
          getFunctionCallFieldBuilder() {
        if (functionCallBuilder_ == null) {
          functionCallBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall, com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCallOrBuilder>(
                  getFunctionCall(),
                  getParentForChildren(),
                  isClean());
          functionCall_ = null;
        }
        return functionCallBuilder_;
      }

      private com.mysql.cj.x.protobuf.MysqlxExpr.Operator operator_;
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Operator, com.mysql.cj.x.protobuf.MysqlxExpr.Operator.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.OperatorOrBuilder> operatorBuilder_;
      /**
       * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
       * @return Whether the operator field is set.
       */
      public boolean hasOperator() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
       * @return The operator.
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Operator getOperator() {
        if (operatorBuilder_ == null) {
          return operator_ == null ? com.mysql.cj.x.protobuf.MysqlxExpr.Operator.getDefaultInstance() : operator_;
        } else {
          return operatorBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
       */
      public Builder setOperator(com.mysql.cj.x.protobuf.MysqlxExpr.Operator value) {
        if (operatorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          operator_ = value;
        } else {
          operatorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
       */
      public Builder setOperator(
          com.mysql.cj.x.protobuf.MysqlxExpr.Operator.Builder builderForValue) {
        if (operatorBuilder_ == null) {
          operator_ = builderForValue.build();
        } else {
          operatorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
       */
      public Builder mergeOperator(com.mysql.cj.x.protobuf.MysqlxExpr.Operator value) {
        if (operatorBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0) &&
            operator_ != null &&
            operator_ != com.mysql.cj.x.protobuf.MysqlxExpr.Operator.getDefaultInstance()) {
            getOperatorBuilder().mergeFrom(value);
          } else {
            operator_ = value;
          }
        } else {
          operatorBuilder_.mergeFrom(value);
        }
        if (operator_ != null) {
          bitField0_ |= 0x00000020;
          onChanged();
        }
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
       */
      public Builder clearOperator() {
        bitField0_ = (bitField0_ & ~0x00000020);
        operator_ = null;
        if (operatorBuilder_ != null) {
          operatorBuilder_.dispose();
          operatorBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Operator.Builder getOperatorBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getOperatorFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.OperatorOrBuilder getOperatorOrBuilder() {
        if (operatorBuilder_ != null) {
          return operatorBuilder_.getMessageOrBuilder();
        } else {
          return operator_ == null ?
              com.mysql.cj.x.protobuf.MysqlxExpr.Operator.getDefaultInstance() : operator_;
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.Operator operator = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Operator, com.mysql.cj.x.protobuf.MysqlxExpr.Operator.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.OperatorOrBuilder> 
          getOperatorFieldBuilder() {
        if (operatorBuilder_ == null) {
          operatorBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Operator, com.mysql.cj.x.protobuf.MysqlxExpr.Operator.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.OperatorOrBuilder>(
                  getOperator(),
                  getParentForChildren(),
                  isClean());
          operator_ = null;
        }
        return operatorBuilder_;
      }

      private int position_ ;
      /**
       * <code>optional uint32 position = 7;</code>
       * @return Whether the position field is set.
       */
      @java.lang.Override
      public boolean hasPosition() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       * <code>optional uint32 position = 7;</code>
       * @return The position.
       */
      @java.lang.Override
      public int getPosition() {
        return position_;
      }
      /**
       * <code>optional uint32 position = 7;</code>
       * @param value The position to set.
       * @return This builder for chaining.
       */
      public Builder setPosition(int value) {

        position_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 position = 7;</code>
       * @return This builder for chaining.
       */
      public Builder clearPosition() {
        bitField0_ = (bitField0_ & ~0x00000040);
        position_ = 0;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxExpr.Object object_;
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Object, com.mysql.cj.x.protobuf.MysqlxExpr.Object.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ObjectOrBuilder> objectBuilder_;
      /**
       * <code>optional .Mysqlx.Expr.Object object = 8;</code>
       * @return Whether the object field is set.
       */
      public boolean hasObject() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       * <code>optional .Mysqlx.Expr.Object object = 8;</code>
       * @return The object.
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Object getObject() {
        if (objectBuilder_ == null) {
          return object_ == null ? com.mysql.cj.x.protobuf.MysqlxExpr.Object.getDefaultInstance() : object_;
        } else {
          return objectBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.Object object = 8;</code>
       */
      public Builder setObject(com.mysql.cj.x.protobuf.MysqlxExpr.Object value) {
        if (objectBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          object_ = value;
        } else {
          objectBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Object object = 8;</code>
       */
      public Builder setObject(
          com.mysql.cj.x.protobuf.MysqlxExpr.Object.Builder builderForValue) {
        if (objectBuilder_ == null) {
          object_ = builderForValue.build();
        } else {
          objectBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Object object = 8;</code>
       */
      public Builder mergeObject(com.mysql.cj.x.protobuf.MysqlxExpr.Object value) {
        if (objectBuilder_ == null) {
          if (((bitField0_ & 0x00000080) != 0) &&
            object_ != null &&
            object_ != com.mysql.cj.x.protobuf.MysqlxExpr.Object.getDefaultInstance()) {
            getObjectBuilder().mergeFrom(value);
          } else {
            object_ = value;
          }
        } else {
          objectBuilder_.mergeFrom(value);
        }
        if (object_ != null) {
          bitField0_ |= 0x00000080;
          onChanged();
        }
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Object object = 8;</code>
       */
      public Builder clearObject() {
        bitField0_ = (bitField0_ & ~0x00000080);
        object_ = null;
        if (objectBuilder_ != null) {
          objectBuilder_.dispose();
          objectBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Object object = 8;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Object.Builder getObjectBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getObjectFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Expr.Object object = 8;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ObjectOrBuilder getObjectOrBuilder() {
        if (objectBuilder_ != null) {
          return objectBuilder_.getMessageOrBuilder();
        } else {
          return object_ == null ?
              com.mysql.cj.x.protobuf.MysqlxExpr.Object.getDefaultInstance() : object_;
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.Object object = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Object, com.mysql.cj.x.protobuf.MysqlxExpr.Object.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ObjectOrBuilder> 
          getObjectFieldBuilder() {
        if (objectBuilder_ == null) {
          objectBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Object, com.mysql.cj.x.protobuf.MysqlxExpr.Object.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ObjectOrBuilder>(
                  getObject(),
                  getParentForChildren(),
                  isClean());
          object_ = null;
        }
        return objectBuilder_;
      }

      private com.mysql.cj.x.protobuf.MysqlxExpr.Array array_;
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Array, com.mysql.cj.x.protobuf.MysqlxExpr.Array.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ArrayOrBuilder> arrayBuilder_;
      /**
       * <code>optional .Mysqlx.Expr.Array array = 9;</code>
       * @return Whether the array field is set.
       */
      public boolean hasArray() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       * <code>optional .Mysqlx.Expr.Array array = 9;</code>
       * @return The array.
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Array getArray() {
        if (arrayBuilder_ == null) {
          return array_ == null ? com.mysql.cj.x.protobuf.MysqlxExpr.Array.getDefaultInstance() : array_;
        } else {
          return arrayBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.Array array = 9;</code>
       */
      public Builder setArray(com.mysql.cj.x.protobuf.MysqlxExpr.Array value) {
        if (arrayBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          array_ = value;
        } else {
          arrayBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Array array = 9;</code>
       */
      public Builder setArray(
          com.mysql.cj.x.protobuf.MysqlxExpr.Array.Builder builderForValue) {
        if (arrayBuilder_ == null) {
          array_ = builderForValue.build();
        } else {
          arrayBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Array array = 9;</code>
       */
      public Builder mergeArray(com.mysql.cj.x.protobuf.MysqlxExpr.Array value) {
        if (arrayBuilder_ == null) {
          if (((bitField0_ & 0x00000100) != 0) &&
            array_ != null &&
            array_ != com.mysql.cj.x.protobuf.MysqlxExpr.Array.getDefaultInstance()) {
            getArrayBuilder().mergeFrom(value);
          } else {
            array_ = value;
          }
        } else {
          arrayBuilder_.mergeFrom(value);
        }
        if (array_ != null) {
          bitField0_ |= 0x00000100;
          onChanged();
        }
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Array array = 9;</code>
       */
      public Builder clearArray() {
        bitField0_ = (bitField0_ & ~0x00000100);
        array_ = null;
        if (arrayBuilder_ != null) {
          arrayBuilder_.dispose();
          arrayBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Array array = 9;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Array.Builder getArrayBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getArrayFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Expr.Array array = 9;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ArrayOrBuilder getArrayOrBuilder() {
        if (arrayBuilder_ != null) {
          return arrayBuilder_.getMessageOrBuilder();
        } else {
          return array_ == null ?
              com.mysql.cj.x.protobuf.MysqlxExpr.Array.getDefaultInstance() : array_;
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.Array array = 9;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Array, com.mysql.cj.x.protobuf.MysqlxExpr.Array.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ArrayOrBuilder> 
          getArrayFieldBuilder() {
        if (arrayBuilder_ == null) {
          arrayBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Array, com.mysql.cj.x.protobuf.MysqlxExpr.Array.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ArrayOrBuilder>(
                  getArray(),
                  getParentForChildren(),
                  isClean());
          array_ = null;
        }
        return arrayBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Expr.Expr)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Expr.Expr)
    private static final com.mysql.cj.x.protobuf.MysqlxExpr.Expr DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxExpr.Expr();
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Expr getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Expr>
        PARSER = new com.google.protobuf.AbstractParser<Expr>() {
      @java.lang.Override
      public Expr parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Expr> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Expr> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface IdentifierOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Expr.Identifier)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required string name = 1;</code>
     * @return Whether the name field is set.
     */
    boolean hasName();
    /**
     * <code>required string name = 1;</code>
     * @return The name.
     */
    java.lang.String getName();
    /**
     * <code>required string name = 1;</code>
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <code>optional string schema_name = 2;</code>
     * @return Whether the schemaName field is set.
     */
    boolean hasSchemaName();
    /**
     * <code>optional string schema_name = 2;</code>
     * @return The schemaName.
     */
    java.lang.String getSchemaName();
    /**
     * <code>optional string schema_name = 2;</code>
     * @return The bytes for schemaName.
     */
    com.google.protobuf.ByteString
        getSchemaNameBytes();
  }
  /**
   * <pre>
   * *
   * Identifier: name, schame.name
   *
   * &#64;par production list
   * &#64;code{unparsed}
   * identifier: string "." string |
   * : string
   * &#64;endcode
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Expr.Identifier}
   */
  public static final class Identifier extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Expr.Identifier)
      IdentifierOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        Identifier.class.getName());
    }
    // Use Identifier.newBuilder() to construct.
    private Identifier(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private Identifier() {
      name_ = "";
      schemaName_ = "";
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Identifier_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Identifier_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.class, com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.Builder.class);
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     * <code>required string name = 1;</code>
     * @return Whether the name field is set.
     */
    @java.lang.Override
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required string name = 1;</code>
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string name = 1;</code>
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCHEMA_NAME_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private volatile java.lang.Object schemaName_ = "";
    /**
     * <code>optional string schema_name = 2;</code>
     * @return Whether the schemaName field is set.
     */
    @java.lang.Override
    public boolean hasSchemaName() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional string schema_name = 2;</code>
     * @return The schemaName.
     */
    @java.lang.Override
    public java.lang.String getSchemaName() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          schemaName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string schema_name = 2;</code>
     * @return The bytes for schemaName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getSchemaNameBytes() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        schemaName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasName()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 1, name_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 2, schemaName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(1, name_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(2, schemaName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxExpr.Identifier)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxExpr.Identifier other = (com.mysql.cj.x.protobuf.MysqlxExpr.Identifier) obj;

      if (hasName() != other.hasName()) return false;
      if (hasName()) {
        if (!getName()
            .equals(other.getName())) return false;
      }
      if (hasSchemaName() != other.hasSchemaName()) return false;
      if (hasSchemaName()) {
        if (!getSchemaName()
            .equals(other.getSchemaName())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasName()) {
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
      }
      if (hasSchemaName()) {
        hash = (37 * hash) + SCHEMA_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getSchemaName().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxExpr.Identifier prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Identifier: name, schame.name
     *
     * &#64;par production list
     * &#64;code{unparsed}
     * identifier: string "." string |
     * : string
     * &#64;endcode
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Expr.Identifier}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Expr.Identifier)
        com.mysql.cj.x.protobuf.MysqlxExpr.IdentifierOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Identifier_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Identifier_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.class, com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        schemaName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Identifier_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.Identifier getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.Identifier build() {
        com.mysql.cj.x.protobuf.MysqlxExpr.Identifier result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.Identifier buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxExpr.Identifier result = new com.mysql.cj.x.protobuf.MysqlxExpr.Identifier(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxExpr.Identifier result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.schemaName_ = schemaName_;
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxExpr.Identifier) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxExpr.Identifier)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxExpr.Identifier other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.getDefaultInstance()) return this;
        if (other.hasName()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasSchemaName()) {
          schemaName_ = other.schemaName_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasName()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                name_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                schemaName_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <code>required string name = 1;</code>
       * @return Whether the name field is set.
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required string name = 1;</code>
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object schemaName_ = "";
      /**
       * <code>optional string schema_name = 2;</code>
       * @return Whether the schemaName field is set.
       */
      public boolean hasSchemaName() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional string schema_name = 2;</code>
       * @return The schemaName.
       */
      public java.lang.String getSchemaName() {
        java.lang.Object ref = schemaName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            schemaName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string schema_name = 2;</code>
       * @return The bytes for schemaName.
       */
      public com.google.protobuf.ByteString
          getSchemaNameBytes() {
        java.lang.Object ref = schemaName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          schemaName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string schema_name = 2;</code>
       * @param value The schemaName to set.
       * @return This builder for chaining.
       */
      public Builder setSchemaName(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        schemaName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema_name = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearSchemaName() {
        schemaName_ = getDefaultInstance().getSchemaName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema_name = 2;</code>
       * @param value The bytes for schemaName to set.
       * @return This builder for chaining.
       */
      public Builder setSchemaNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        schemaName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Expr.Identifier)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Expr.Identifier)
    private static final com.mysql.cj.x.protobuf.MysqlxExpr.Identifier DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxExpr.Identifier();
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Identifier getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Identifier>
        PARSER = new com.google.protobuf.AbstractParser<Identifier>() {
      @java.lang.Override
      public Identifier parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Identifier> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Identifier> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.Identifier getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface DocumentPathItemOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Expr.DocumentPathItem)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .Mysqlx.Expr.DocumentPathItem.Type type = 1;</code>
     * @return Whether the type field is set.
     */
    boolean hasType();
    /**
     * <code>required .Mysqlx.Expr.DocumentPathItem.Type type = 1;</code>
     * @return The type.
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type getType();

    /**
     * <code>optional string value = 2;</code>
     * @return Whether the value field is set.
     */
    boolean hasValue();
    /**
     * <code>optional string value = 2;</code>
     * @return The value.
     */
    java.lang.String getValue();
    /**
     * <code>optional string value = 2;</code>
     * @return The bytes for value.
     */
    com.google.protobuf.ByteString
        getValueBytes();

    /**
     * <pre>
     * * used in case of ARRY_INDEX 
     * </pre>
     *
     * <code>optional uint32 index = 3;</code>
     * @return Whether the index field is set.
     */
    boolean hasIndex();
    /**
     * <pre>
     * * used in case of ARRY_INDEX 
     * </pre>
     *
     * <code>optional uint32 index = 3;</code>
     * @return The index.
     */
    int getIndex();
  }
  /**
   * <pre>
   * *
   * Document path item
   *
   * &#64;par production list
   * &#64;code{unparsed}
   * document_path: path_item | path_item document_path
   * path_item    : member | array_index | "**"
   * member       : "." string | "." "*"
   * array_index  : "[" number "]" | "[" "*" "]"
   * &#64;endcode
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Expr.DocumentPathItem}
   */
  public static final class DocumentPathItem extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Expr.DocumentPathItem)
      DocumentPathItemOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        DocumentPathItem.class.getName());
    }
    // Use DocumentPathItem.newBuilder() to construct.
    private DocumentPathItem(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private DocumentPathItem() {
      type_ = 1;
      value_ = "";
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_DocumentPathItem_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_DocumentPathItem_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.class, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder.class);
    }

    /**
     * Protobuf enum {@code Mysqlx.Expr.DocumentPathItem.Type}
     */
    public enum Type
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <pre>
       * *  .member 
       * </pre>
       *
       * <code>MEMBER = 1;</code>
       */
      MEMBER(1),
      /**
       * <pre>
       * * &#92;.* 
       * </pre>
       *
       * <code>MEMBER_ASTERISK = 2;</code>
       */
      MEMBER_ASTERISK(2),
      /**
       * <pre>
       * * [index] 
       * </pre>
       *
       * <code>ARRAY_INDEX = 3;</code>
       */
      ARRAY_INDEX(3),
      /**
       * <pre>
       * * [*] 
       * </pre>
       *
       * <code>ARRAY_INDEX_ASTERISK = 4;</code>
       */
      ARRAY_INDEX_ASTERISK(4),
      /**
       * <pre>
       * * ** 
       * </pre>
       *
       * <code>DOUBLE_ASTERISK = 5;</code>
       */
      DOUBLE_ASTERISK(5),
      ;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 29,
          /* patch= */ 0,
          /* suffix= */ "",
          Type.class.getName());
      }
      /**
       * <pre>
       * *  .member 
       * </pre>
       *
       * <code>MEMBER = 1;</code>
       */
      public static final int MEMBER_VALUE = 1;
      /**
       * <pre>
       * * &#92;.* 
       * </pre>
       *
       * <code>MEMBER_ASTERISK = 2;</code>
       */
      public static final int MEMBER_ASTERISK_VALUE = 2;
      /**
       * <pre>
       * * [index] 
       * </pre>
       *
       * <code>ARRAY_INDEX = 3;</code>
       */
      public static final int ARRAY_INDEX_VALUE = 3;
      /**
       * <pre>
       * * [*] 
       * </pre>
       *
       * <code>ARRAY_INDEX_ASTERISK = 4;</code>
       */
      public static final int ARRAY_INDEX_ASTERISK_VALUE = 4;
      /**
       * <pre>
       * * ** 
       * </pre>
       *
       * <code>DOUBLE_ASTERISK = 5;</code>
       */
      public static final int DOUBLE_ASTERISK_VALUE = 5;


      public final int getNumber() {
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Type valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Type forNumber(int value) {
        switch (value) {
          case 1: return MEMBER;
          case 2: return MEMBER_ASTERISK;
          case 3: return ARRAY_INDEX;
          case 4: return ARRAY_INDEX_ASTERISK;
          case 5: return DOUBLE_ASTERISK;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          Type> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Type>() {
              public Type findValueByNumber(int number) {
                return Type.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.getDescriptor().getEnumTypes().get(0);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Type(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Expr.DocumentPathItem.Type)
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_ = 1;
    /**
     * <code>required .Mysqlx.Expr.DocumentPathItem.Type type = 1;</code>
     * @return Whether the type field is set.
     */
    @java.lang.Override public boolean hasType() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required .Mysqlx.Expr.DocumentPathItem.Type type = 1;</code>
     * @return The type.
     */
    @java.lang.Override public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type getType() {
      com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type result = com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type.forNumber(type_);
      return result == null ? com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type.MEMBER : result;
    }

    public static final int VALUE_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private volatile java.lang.Object value_ = "";
    /**
     * <code>optional string value = 2;</code>
     * @return Whether the value field is set.
     */
    @java.lang.Override
    public boolean hasValue() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional string value = 2;</code>
     * @return The value.
     */
    @java.lang.Override
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          value_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string value = 2;</code>
     * @return The bytes for value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INDEX_FIELD_NUMBER = 3;
    private int index_ = 0;
    /**
     * <pre>
     * * used in case of ARRY_INDEX 
     * </pre>
     *
     * <code>optional uint32 index = 3;</code>
     * @return Whether the index field is set.
     */
    @java.lang.Override
    public boolean hasIndex() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * * used in case of ARRY_INDEX 
     * </pre>
     *
     * <code>optional uint32 index = 3;</code>
     * @return The index.
     */
    @java.lang.Override
    public int getIndex() {
      return index_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasType()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(1, type_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 2, value_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeUInt32(3, index_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, type_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(2, value_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(3, index_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem other = (com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem) obj;

      if (hasType() != other.hasType()) return false;
      if (hasType()) {
        if (type_ != other.type_) return false;
      }
      if (hasValue() != other.hasValue()) return false;
      if (hasValue()) {
        if (!getValue()
            .equals(other.getValue())) return false;
      }
      if (hasIndex() != other.hasIndex()) return false;
      if (hasIndex()) {
        if (getIndex()
            != other.getIndex()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasType()) {
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + type_;
      }
      if (hasValue()) {
        hash = (37 * hash) + VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getValue().hashCode();
      }
      if (hasIndex()) {
        hash = (37 * hash) + INDEX_FIELD_NUMBER;
        hash = (53 * hash) + getIndex();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Document path item
     *
     * &#64;par production list
     * &#64;code{unparsed}
     * document_path: path_item | path_item document_path
     * path_item    : member | array_index | "**"
     * member       : "." string | "." "*"
     * array_index  : "[" number "]" | "[" "*" "]"
     * &#64;endcode
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Expr.DocumentPathItem}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Expr.DocumentPathItem)
        com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_DocumentPathItem_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_DocumentPathItem_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.class, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        type_ = 1;
        value_ = "";
        index_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_DocumentPathItem_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem build() {
        com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem result = new com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.type_ = type_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.value_ = value_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.index_ = index_;
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.getDefaultInstance()) return this;
        if (other.hasType()) {
          setType(other.getType());
        }
        if (other.hasValue()) {
          value_ = other.value_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasIndex()) {
          setIndex(other.getIndex());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasType()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                int tmpRaw = input.readEnum();
                com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type tmpValue =
                    com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type.forNumber(tmpRaw);
                if (tmpValue == null) {
                  mergeUnknownVarintField(1, tmpRaw);
                } else {
                  type_ = tmpRaw;
                  bitField0_ |= 0x00000001;
                }
                break;
              } // case 8
              case 18: {
                value_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 24: {
                index_ = input.readUInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int type_ = 1;
      /**
       * <code>required .Mysqlx.Expr.DocumentPathItem.Type type = 1;</code>
       * @return Whether the type field is set.
       */
      @java.lang.Override public boolean hasType() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .Mysqlx.Expr.DocumentPathItem.Type type = 1;</code>
       * @return The type.
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type getType() {
        com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type result = com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type.forNumber(type_);
        return result == null ? com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type.MEMBER : result;
      }
      /**
       * <code>required .Mysqlx.Expr.DocumentPathItem.Type type = 1;</code>
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>required .Mysqlx.Expr.DocumentPathItem.Type type = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = 1;
        onChanged();
        return this;
      }

      private java.lang.Object value_ = "";
      /**
       * <code>optional string value = 2;</code>
       * @return Whether the value field is set.
       */
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional string value = 2;</code>
       * @return The value.
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            value_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string value = 2;</code>
       * @return The bytes for value.
       */
      public com.google.protobuf.ByteString
          getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string value = 2;</code>
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        value_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>optional string value = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        value_ = getDefaultInstance().getValue();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <code>optional string value = 2;</code>
       * @param value The bytes for value to set.
       * @return This builder for chaining.
       */
      public Builder setValueBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        value_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private int index_ ;
      /**
       * <pre>
       * * used in case of ARRY_INDEX 
       * </pre>
       *
       * <code>optional uint32 index = 3;</code>
       * @return Whether the index field is set.
       */
      @java.lang.Override
      public boolean hasIndex() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * * used in case of ARRY_INDEX 
       * </pre>
       *
       * <code>optional uint32 index = 3;</code>
       * @return The index.
       */
      @java.lang.Override
      public int getIndex() {
        return index_;
      }
      /**
       * <pre>
       * * used in case of ARRY_INDEX 
       * </pre>
       *
       * <code>optional uint32 index = 3;</code>
       * @param value The index to set.
       * @return This builder for chaining.
       */
      public Builder setIndex(int value) {

        index_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * used in case of ARRY_INDEX 
       * </pre>
       *
       * <code>optional uint32 index = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearIndex() {
        bitField0_ = (bitField0_ & ~0x00000004);
        index_ = 0;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Expr.DocumentPathItem)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Expr.DocumentPathItem)
    private static final com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem();
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DocumentPathItem>
        PARSER = new com.google.protobuf.AbstractParser<DocumentPathItem>() {
      @java.lang.Override
      public DocumentPathItem parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<DocumentPathItem> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DocumentPathItem> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ColumnIdentifierOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Expr.ColumnIdentifier)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * * document path 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem> 
        getDocumentPathList();
    /**
     * <pre>
     * * document path 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem getDocumentPath(int index);
    /**
     * <pre>
     * * document path 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
     */
    int getDocumentPathCount();
    /**
     * <pre>
     * * document path 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder> 
        getDocumentPathOrBuilderList();
    /**
     * <pre>
     * * document path 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder getDocumentPathOrBuilder(
        int index);

    /**
     * <pre>
     * * name of column 
     * </pre>
     *
     * <code>optional string name = 2;</code>
     * @return Whether the name field is set.
     */
    boolean hasName();
    /**
     * <pre>
     * * name of column 
     * </pre>
     *
     * <code>optional string name = 2;</code>
     * @return The name.
     */
    java.lang.String getName();
    /**
     * <pre>
     * * name of column 
     * </pre>
     *
     * <code>optional string name = 2;</code>
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <pre>
     * * name of table 
     * </pre>
     *
     * <code>optional string table_name = 3;</code>
     * @return Whether the tableName field is set.
     */
    boolean hasTableName();
    /**
     * <pre>
     * * name of table 
     * </pre>
     *
     * <code>optional string table_name = 3;</code>
     * @return The tableName.
     */
    java.lang.String getTableName();
    /**
     * <pre>
     * * name of table 
     * </pre>
     *
     * <code>optional string table_name = 3;</code>
     * @return The bytes for tableName.
     */
    com.google.protobuf.ByteString
        getTableNameBytes();

    /**
     * <pre>
     * * name of schema 
     * </pre>
     *
     * <code>optional string schema_name = 4;</code>
     * @return Whether the schemaName field is set.
     */
    boolean hasSchemaName();
    /**
     * <pre>
     * * name of schema 
     * </pre>
     *
     * <code>optional string schema_name = 4;</code>
     * @return The schemaName.
     */
    java.lang.String getSchemaName();
    /**
     * <pre>
     * * name of schema 
     * </pre>
     *
     * <code>optional string schema_name = 4;</code>
     * @return The bytes for schemaName.
     */
    com.google.protobuf.ByteString
        getSchemaNameBytes();
  }
  /**
   * <pre>
   * *
   * Column identifier
   *
   * for table: col&#92;&#64;doc_path, tbl.col&#92;&#64;doc_path col, tbl.col, schema.tbl.col
   * for document collection: doc_path
   * //
   * &#64;par production list
   * &#64;code{unparsed}
   * col_identifier: string "." string "." string |
   * : string "." string |
   * : string |
   * : string "." string "." string "&#64;" document_path |
   * : string "." string "&#64;" document_path |
   * : string "&#64;" document_path |
   * : document_path
   * document_path: member | arrayLocation | doubleAsterisk
   * member = "." string | "." "*"
   * arrayLocation = "[" index "]" | "[" "*" "]"
   * doubleAsterisk = "**"
   * &#64;endcode
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Expr.ColumnIdentifier}
   */
  public static final class ColumnIdentifier extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Expr.ColumnIdentifier)
      ColumnIdentifierOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        ColumnIdentifier.class.getName());
    }
    // Use ColumnIdentifier.newBuilder() to construct.
    private ColumnIdentifier(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private ColumnIdentifier() {
      documentPath_ = java.util.Collections.emptyList();
      name_ = "";
      tableName_ = "";
      schemaName_ = "";
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_ColumnIdentifier_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_ColumnIdentifier_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.class, com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.Builder.class);
    }

    private int bitField0_;
    public static final int DOCUMENT_PATH_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem> documentPath_;
    /**
     * <pre>
     * * document path 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem> getDocumentPathList() {
      return documentPath_;
    }
    /**
     * <pre>
     * * document path 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder> 
        getDocumentPathOrBuilderList() {
      return documentPath_;
    }
    /**
     * <pre>
     * * document path 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
     */
    @java.lang.Override
    public int getDocumentPathCount() {
      return documentPath_.size();
    }
    /**
     * <pre>
     * * document path 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem getDocumentPath(int index) {
      return documentPath_.get(index);
    }
    /**
     * <pre>
     * * document path 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder getDocumentPathOrBuilder(
        int index) {
      return documentPath_.get(index);
    }

    public static final int NAME_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     * <pre>
     * * name of column 
     * </pre>
     *
     * <code>optional string name = 2;</code>
     * @return Whether the name field is set.
     */
    @java.lang.Override
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * * name of column 
     * </pre>
     *
     * <code>optional string name = 2;</code>
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * * name of column 
     * </pre>
     *
     * <code>optional string name = 2;</code>
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TABLE_NAME_FIELD_NUMBER = 3;
    @SuppressWarnings("serial")
    private volatile java.lang.Object tableName_ = "";
    /**
     * <pre>
     * * name of table 
     * </pre>
     *
     * <code>optional string table_name = 3;</code>
     * @return Whether the tableName field is set.
     */
    @java.lang.Override
    public boolean hasTableName() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * * name of table 
     * </pre>
     *
     * <code>optional string table_name = 3;</code>
     * @return The tableName.
     */
    @java.lang.Override
    public java.lang.String getTableName() {
      java.lang.Object ref = tableName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          tableName_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * * name of table 
     * </pre>
     *
     * <code>optional string table_name = 3;</code>
     * @return The bytes for tableName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getTableNameBytes() {
      java.lang.Object ref = tableName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        tableName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCHEMA_NAME_FIELD_NUMBER = 4;
    @SuppressWarnings("serial")
    private volatile java.lang.Object schemaName_ = "";
    /**
     * <pre>
     * * name of schema 
     * </pre>
     *
     * <code>optional string schema_name = 4;</code>
     * @return Whether the schemaName field is set.
     */
    @java.lang.Override
    public boolean hasSchemaName() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * * name of schema 
     * </pre>
     *
     * <code>optional string schema_name = 4;</code>
     * @return The schemaName.
     */
    @java.lang.Override
    public java.lang.String getSchemaName() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          schemaName_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * * name of schema 
     * </pre>
     *
     * <code>optional string schema_name = 4;</code>
     * @return The bytes for schemaName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getSchemaNameBytes() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        schemaName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getDocumentPathCount(); i++) {
        if (!getDocumentPath(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < documentPath_.size(); i++) {
        output.writeMessage(1, documentPath_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 2, name_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 3, tableName_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 4, schemaName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < documentPath_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, documentPath_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(2, name_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(3, tableName_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(4, schemaName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier other = (com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier) obj;

      if (!getDocumentPathList()
          .equals(other.getDocumentPathList())) return false;
      if (hasName() != other.hasName()) return false;
      if (hasName()) {
        if (!getName()
            .equals(other.getName())) return false;
      }
      if (hasTableName() != other.hasTableName()) return false;
      if (hasTableName()) {
        if (!getTableName()
            .equals(other.getTableName())) return false;
      }
      if (hasSchemaName() != other.hasSchemaName()) return false;
      if (hasSchemaName()) {
        if (!getSchemaName()
            .equals(other.getSchemaName())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getDocumentPathCount() > 0) {
        hash = (37 * hash) + DOCUMENT_PATH_FIELD_NUMBER;
        hash = (53 * hash) + getDocumentPathList().hashCode();
      }
      if (hasName()) {
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
      }
      if (hasTableName()) {
        hash = (37 * hash) + TABLE_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getTableName().hashCode();
      }
      if (hasSchemaName()) {
        hash = (37 * hash) + SCHEMA_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getSchemaName().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Column identifier
     *
     * for table: col&#92;&#64;doc_path, tbl.col&#92;&#64;doc_path col, tbl.col, schema.tbl.col
     * for document collection: doc_path
     * //
     * &#64;par production list
     * &#64;code{unparsed}
     * col_identifier: string "." string "." string |
     * : string "." string |
     * : string |
     * : string "." string "." string "&#64;" document_path |
     * : string "." string "&#64;" document_path |
     * : string "&#64;" document_path |
     * : document_path
     * document_path: member | arrayLocation | doubleAsterisk
     * member = "." string | "." "*"
     * arrayLocation = "[" index "]" | "[" "*" "]"
     * doubleAsterisk = "**"
     * &#64;endcode
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Expr.ColumnIdentifier}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Expr.ColumnIdentifier)
        com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifierOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_ColumnIdentifier_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_ColumnIdentifier_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.class, com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (documentPathBuilder_ == null) {
          documentPath_ = java.util.Collections.emptyList();
        } else {
          documentPath_ = null;
          documentPathBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        name_ = "";
        tableName_ = "";
        schemaName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_ColumnIdentifier_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier build() {
        com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier result = new com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier result) {
        if (documentPathBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            documentPath_ = java.util.Collections.unmodifiableList(documentPath_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.documentPath_ = documentPath_;
        } else {
          result.documentPath_ = documentPathBuilder_.build();
        }
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.name_ = name_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.tableName_ = tableName_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.schemaName_ = schemaName_;
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.getDefaultInstance()) return this;
        if (documentPathBuilder_ == null) {
          if (!other.documentPath_.isEmpty()) {
            if (documentPath_.isEmpty()) {
              documentPath_ = other.documentPath_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureDocumentPathIsMutable();
              documentPath_.addAll(other.documentPath_);
            }
            onChanged();
          }
        } else {
          if (!other.documentPath_.isEmpty()) {
            if (documentPathBuilder_.isEmpty()) {
              documentPathBuilder_.dispose();
              documentPathBuilder_ = null;
              documentPath_ = other.documentPath_;
              bitField0_ = (bitField0_ & ~0x00000001);
              documentPathBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getDocumentPathFieldBuilder() : null;
            } else {
              documentPathBuilder_.addAllMessages(other.documentPath_);
            }
          }
        }
        if (other.hasName()) {
          name_ = other.name_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasTableName()) {
          tableName_ = other.tableName_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.hasSchemaName()) {
          schemaName_ = other.schemaName_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        for (int i = 0; i < getDocumentPathCount(); i++) {
          if (!getDocumentPath(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem m =
                    input.readMessage(
                        com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.parser(),
                        extensionRegistry);
                if (documentPathBuilder_ == null) {
                  ensureDocumentPathIsMutable();
                  documentPath_.add(m);
                } else {
                  documentPathBuilder_.addMessage(m);
                }
                break;
              } // case 10
              case 18: {
                name_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                tableName_ = input.readBytes();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              case 34: {
                schemaName_ = input.readBytes();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem> documentPath_ =
        java.util.Collections.emptyList();
      private void ensureDocumentPathIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          documentPath_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem>(documentPath_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder> documentPathBuilder_;

      /**
       * <pre>
       * * document path 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem> getDocumentPathList() {
        if (documentPathBuilder_ == null) {
          return java.util.Collections.unmodifiableList(documentPath_);
        } else {
          return documentPathBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * * document path 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public int getDocumentPathCount() {
        if (documentPathBuilder_ == null) {
          return documentPath_.size();
        } else {
          return documentPathBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * * document path 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem getDocumentPath(int index) {
        if (documentPathBuilder_ == null) {
          return documentPath_.get(index);
        } else {
          return documentPathBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * * document path 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public Builder setDocumentPath(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem value) {
        if (documentPathBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentPathIsMutable();
          documentPath_.set(index, value);
          onChanged();
        } else {
          documentPathBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * * document path 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public Builder setDocumentPath(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder builderForValue) {
        if (documentPathBuilder_ == null) {
          ensureDocumentPathIsMutable();
          documentPath_.set(index, builderForValue.build());
          onChanged();
        } else {
          documentPathBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * * document path 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public Builder addDocumentPath(com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem value) {
        if (documentPathBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentPathIsMutable();
          documentPath_.add(value);
          onChanged();
        } else {
          documentPathBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * * document path 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public Builder addDocumentPath(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem value) {
        if (documentPathBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentPathIsMutable();
          documentPath_.add(index, value);
          onChanged();
        } else {
          documentPathBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * * document path 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public Builder addDocumentPath(
          com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder builderForValue) {
        if (documentPathBuilder_ == null) {
          ensureDocumentPathIsMutable();
          documentPath_.add(builderForValue.build());
          onChanged();
        } else {
          documentPathBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * * document path 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public Builder addDocumentPath(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder builderForValue) {
        if (documentPathBuilder_ == null) {
          ensureDocumentPathIsMutable();
          documentPath_.add(index, builderForValue.build());
          onChanged();
        } else {
          documentPathBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * * document path 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public Builder addAllDocumentPath(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem> values) {
        if (documentPathBuilder_ == null) {
          ensureDocumentPathIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, documentPath_);
          onChanged();
        } else {
          documentPathBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * * document path 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public Builder clearDocumentPath() {
        if (documentPathBuilder_ == null) {
          documentPath_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          documentPathBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * * document path 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public Builder removeDocumentPath(int index) {
        if (documentPathBuilder_ == null) {
          ensureDocumentPathIsMutable();
          documentPath_.remove(index);
          onChanged();
        } else {
          documentPathBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * * document path 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder getDocumentPathBuilder(
          int index) {
        return getDocumentPathFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * * document path 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder getDocumentPathOrBuilder(
          int index) {
        if (documentPathBuilder_ == null) {
          return documentPath_.get(index);  } else {
          return documentPathBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * * document path 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder> 
           getDocumentPathOrBuilderList() {
        if (documentPathBuilder_ != null) {
          return documentPathBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(documentPath_);
        }
      }
      /**
       * <pre>
       * * document path 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder addDocumentPathBuilder() {
        return getDocumentPathFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.getDefaultInstance());
      }
      /**
       * <pre>
       * * document path 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder addDocumentPathBuilder(
          int index) {
        return getDocumentPathFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.getDefaultInstance());
      }
      /**
       * <pre>
       * * document path 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 1;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder> 
           getDocumentPathBuilderList() {
        return getDocumentPathFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder> 
          getDocumentPathFieldBuilder() {
        if (documentPathBuilder_ == null) {
          documentPathBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder>(
                  documentPath_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          documentPath_ = null;
        }
        return documentPathBuilder_;
      }

      private java.lang.Object name_ = "";
      /**
       * <pre>
       * * name of column 
       * </pre>
       *
       * <code>optional string name = 2;</code>
       * @return Whether the name field is set.
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * * name of column 
       * </pre>
       *
       * <code>optional string name = 2;</code>
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * * name of column 
       * </pre>
       *
       * <code>optional string name = 2;</code>
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * * name of column 
       * </pre>
       *
       * <code>optional string name = 2;</code>
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        name_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * name of column 
       * </pre>
       *
       * <code>optional string name = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * name of column 
       * </pre>
       *
       * <code>optional string name = 2;</code>
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        name_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object tableName_ = "";
      /**
       * <pre>
       * * name of table 
       * </pre>
       *
       * <code>optional string table_name = 3;</code>
       * @return Whether the tableName field is set.
       */
      public boolean hasTableName() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * * name of table 
       * </pre>
       *
       * <code>optional string table_name = 3;</code>
       * @return The tableName.
       */
      public java.lang.String getTableName() {
        java.lang.Object ref = tableName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            tableName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * * name of table 
       * </pre>
       *
       * <code>optional string table_name = 3;</code>
       * @return The bytes for tableName.
       */
      public com.google.protobuf.ByteString
          getTableNameBytes() {
        java.lang.Object ref = tableName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          tableName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * * name of table 
       * </pre>
       *
       * <code>optional string table_name = 3;</code>
       * @param value The tableName to set.
       * @return This builder for chaining.
       */
      public Builder setTableName(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        tableName_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * name of table 
       * </pre>
       *
       * <code>optional string table_name = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearTableName() {
        tableName_ = getDefaultInstance().getTableName();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * name of table 
       * </pre>
       *
       * <code>optional string table_name = 3;</code>
       * @param value The bytes for tableName to set.
       * @return This builder for chaining.
       */
      public Builder setTableNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        tableName_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object schemaName_ = "";
      /**
       * <pre>
       * * name of schema 
       * </pre>
       *
       * <code>optional string schema_name = 4;</code>
       * @return Whether the schemaName field is set.
       */
      public boolean hasSchemaName() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <pre>
       * * name of schema 
       * </pre>
       *
       * <code>optional string schema_name = 4;</code>
       * @return The schemaName.
       */
      public java.lang.String getSchemaName() {
        java.lang.Object ref = schemaName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            schemaName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * * name of schema 
       * </pre>
       *
       * <code>optional string schema_name = 4;</code>
       * @return The bytes for schemaName.
       */
      public com.google.protobuf.ByteString
          getSchemaNameBytes() {
        java.lang.Object ref = schemaName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          schemaName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * * name of schema 
       * </pre>
       *
       * <code>optional string schema_name = 4;</code>
       * @param value The schemaName to set.
       * @return This builder for chaining.
       */
      public Builder setSchemaName(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        schemaName_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * name of schema 
       * </pre>
       *
       * <code>optional string schema_name = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearSchemaName() {
        schemaName_ = getDefaultInstance().getSchemaName();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * name of schema 
       * </pre>
       *
       * <code>optional string schema_name = 4;</code>
       * @param value The bytes for schemaName to set.
       * @return This builder for chaining.
       */
      public Builder setSchemaNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        schemaName_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Expr.ColumnIdentifier)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Expr.ColumnIdentifier)
    private static final com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier();
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ColumnIdentifier>
        PARSER = new com.google.protobuf.AbstractParser<ColumnIdentifier>() {
      @java.lang.Override
      public ColumnIdentifier parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<ColumnIdentifier> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ColumnIdentifier> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface FunctionCallOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Expr.FunctionCall)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * * identifier of function; at least name of it 
     * </pre>
     *
     * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
     * @return Whether the name field is set.
     */
    boolean hasName();
    /**
     * <pre>
     * * identifier of function; at least name of it 
     * </pre>
     *
     * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
     * @return The name.
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Identifier getName();
    /**
     * <pre>
     * * identifier of function; at least name of it 
     * </pre>
     *
     * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.IdentifierOrBuilder getNameOrBuilder();

    /**
     * <pre>
     * * list of parameters 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> 
        getParamList();
    /**
     * <pre>
     * * list of parameters 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Expr getParam(int index);
    /**
     * <pre>
     * * list of parameters 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    int getParamCount();
    /**
     * <pre>
     * * list of parameters 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
        getParamOrBuilderList();
    /**
     * <pre>
     * * list of parameters 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getParamOrBuilder(
        int index);
  }
  /**
   * <pre>
   * *
   * Function call: ``func(a, b, "1", 3)``
   *
   * &#64;par production list
   * &#64;code{unparsed}
   * function_call: `identifier` "(" [ `expr` ["," `expr` ]* ] ")"
   * &#64;endcode
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Expr.FunctionCall}
   */
  public static final class FunctionCall extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Expr.FunctionCall)
      FunctionCallOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        FunctionCall.class.getName());
    }
    // Use FunctionCall.newBuilder() to construct.
    private FunctionCall(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private FunctionCall() {
      param_ = java.util.Collections.emptyList();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_FunctionCall_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_FunctionCall_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.class, com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.Builder.class);
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private com.mysql.cj.x.protobuf.MysqlxExpr.Identifier name_;
    /**
     * <pre>
     * * identifier of function; at least name of it 
     * </pre>
     *
     * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
     * @return Whether the name field is set.
     */
    @java.lang.Override
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * * identifier of function; at least name of it 
     * </pre>
     *
     * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
     * @return The name.
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.Identifier getName() {
      return name_ == null ? com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.getDefaultInstance() : name_;
    }
    /**
     * <pre>
     * * identifier of function; at least name of it 
     * </pre>
     *
     * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.IdentifierOrBuilder getNameOrBuilder() {
      return name_ == null ? com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.getDefaultInstance() : name_;
    }

    public static final int PARAM_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> param_;
    /**
     * <pre>
     * * list of parameters 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> getParamList() {
      return param_;
    }
    /**
     * <pre>
     * * list of parameters 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
        getParamOrBuilderList() {
      return param_;
    }
    /**
     * <pre>
     * * list of parameters 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    @java.lang.Override
    public int getParamCount() {
      return param_.size();
    }
    /**
     * <pre>
     * * list of parameters 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getParam(int index) {
      return param_.get(index);
    }
    /**
     * <pre>
     * * list of parameters 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getParamOrBuilder(
        int index) {
      return param_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasName()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getName().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getParamCount(); i++) {
        if (!getParam(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getName());
      }
      for (int i = 0; i < param_.size(); i++) {
        output.writeMessage(2, param_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getName());
      }
      for (int i = 0; i < param_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, param_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall other = (com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall) obj;

      if (hasName() != other.hasName()) return false;
      if (hasName()) {
        if (!getName()
            .equals(other.getName())) return false;
      }
      if (!getParamList()
          .equals(other.getParamList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasName()) {
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
      }
      if (getParamCount() > 0) {
        hash = (37 * hash) + PARAM_FIELD_NUMBER;
        hash = (53 * hash) + getParamList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Function call: ``func(a, b, "1", 3)``
     *
     * &#64;par production list
     * &#64;code{unparsed}
     * function_call: `identifier` "(" [ `expr` ["," `expr` ]* ] ")"
     * &#64;endcode
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Expr.FunctionCall}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Expr.FunctionCall)
        com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCallOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_FunctionCall_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_FunctionCall_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.class, com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage
                .alwaysUseFieldBuilders) {
          getNameFieldBuilder();
          getParamFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = null;
        if (nameBuilder_ != null) {
          nameBuilder_.dispose();
          nameBuilder_ = null;
        }
        if (paramBuilder_ == null) {
          param_ = java.util.Collections.emptyList();
        } else {
          param_ = null;
          paramBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_FunctionCall_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall build() {
        com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall result = new com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall result) {
        if (paramBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            param_ = java.util.Collections.unmodifiableList(param_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.param_ = param_;
        } else {
          result.param_ = paramBuilder_.build();
        }
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = nameBuilder_ == null
              ? name_
              : nameBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall.getDefaultInstance()) return this;
        if (other.hasName()) {
          mergeName(other.getName());
        }
        if (paramBuilder_ == null) {
          if (!other.param_.isEmpty()) {
            if (param_.isEmpty()) {
              param_ = other.param_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureParamIsMutable();
              param_.addAll(other.param_);
            }
            onChanged();
          }
        } else {
          if (!other.param_.isEmpty()) {
            if (paramBuilder_.isEmpty()) {
              paramBuilder_.dispose();
              paramBuilder_ = null;
              param_ = other.param_;
              bitField0_ = (bitField0_ & ~0x00000002);
              paramBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getParamFieldBuilder() : null;
            } else {
              paramBuilder_.addAllMessages(other.param_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasName()) {
          return false;
        }
        if (!getName().isInitialized()) {
          return false;
        }
        for (int i = 0; i < getParamCount(); i++) {
          if (!getParam(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getNameFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                com.mysql.cj.x.protobuf.MysqlxExpr.Expr m =
                    input.readMessage(
                        com.mysql.cj.x.protobuf.MysqlxExpr.Expr.parser(),
                        extensionRegistry);
                if (paramBuilder_ == null) {
                  ensureParamIsMutable();
                  param_.add(m);
                } else {
                  paramBuilder_.addMessage(m);
                }
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private com.mysql.cj.x.protobuf.MysqlxExpr.Identifier name_;
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Identifier, com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.IdentifierOrBuilder> nameBuilder_;
      /**
       * <pre>
       * * identifier of function; at least name of it 
       * </pre>
       *
       * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
       * @return Whether the name field is set.
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * * identifier of function; at least name of it 
       * </pre>
       *
       * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
       * @return The name.
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Identifier getName() {
        if (nameBuilder_ == null) {
          return name_ == null ? com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.getDefaultInstance() : name_;
        } else {
          return nameBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * * identifier of function; at least name of it 
       * </pre>
       *
       * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
       */
      public Builder setName(com.mysql.cj.x.protobuf.MysqlxExpr.Identifier value) {
        if (nameBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          name_ = value;
        } else {
          nameBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * identifier of function; at least name of it 
       * </pre>
       *
       * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
       */
      public Builder setName(
          com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.Builder builderForValue) {
        if (nameBuilder_ == null) {
          name_ = builderForValue.build();
        } else {
          nameBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * identifier of function; at least name of it 
       * </pre>
       *
       * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
       */
      public Builder mergeName(com.mysql.cj.x.protobuf.MysqlxExpr.Identifier value) {
        if (nameBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            name_ != null &&
            name_ != com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.getDefaultInstance()) {
            getNameBuilder().mergeFrom(value);
          } else {
            name_ = value;
          }
        } else {
          nameBuilder_.mergeFrom(value);
        }
        if (name_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * * identifier of function; at least name of it 
       * </pre>
       *
       * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        name_ = null;
        if (nameBuilder_ != null) {
          nameBuilder_.dispose();
          nameBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * identifier of function; at least name of it 
       * </pre>
       *
       * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.Builder getNameBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getNameFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * * identifier of function; at least name of it 
       * </pre>
       *
       * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.IdentifierOrBuilder getNameOrBuilder() {
        if (nameBuilder_ != null) {
          return nameBuilder_.getMessageOrBuilder();
        } else {
          return name_ == null ?
              com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.getDefaultInstance() : name_;
        }
      }
      /**
       * <pre>
       * * identifier of function; at least name of it 
       * </pre>
       *
       * <code>required .Mysqlx.Expr.Identifier name = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Identifier, com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.IdentifierOrBuilder> 
          getNameFieldBuilder() {
        if (nameBuilder_ == null) {
          nameBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Identifier, com.mysql.cj.x.protobuf.MysqlxExpr.Identifier.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.IdentifierOrBuilder>(
                  getName(),
                  getParentForChildren(),
                  isClean());
          name_ = null;
        }
        return nameBuilder_;
      }

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> param_ =
        java.util.Collections.emptyList();
      private void ensureParamIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          param_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpr.Expr>(param_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> paramBuilder_;

      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> getParamList() {
        if (paramBuilder_ == null) {
          return java.util.Collections.unmodifiableList(param_);
        } else {
          return paramBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public int getParamCount() {
        if (paramBuilder_ == null) {
          return param_.size();
        } else {
          return paramBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getParam(int index) {
        if (paramBuilder_ == null) {
          return param_.get(index);
        } else {
          return paramBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder setParam(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (paramBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParamIsMutable();
          param_.set(index, value);
          onChanged();
        } else {
          paramBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder setParam(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (paramBuilder_ == null) {
          ensureParamIsMutable();
          param_.set(index, builderForValue.build());
          onChanged();
        } else {
          paramBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder addParam(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (paramBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParamIsMutable();
          param_.add(value);
          onChanged();
        } else {
          paramBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder addParam(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (paramBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParamIsMutable();
          param_.add(index, value);
          onChanged();
        } else {
          paramBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder addParam(
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (paramBuilder_ == null) {
          ensureParamIsMutable();
          param_.add(builderForValue.build());
          onChanged();
        } else {
          paramBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder addParam(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (paramBuilder_ == null) {
          ensureParamIsMutable();
          param_.add(index, builderForValue.build());
          onChanged();
        } else {
          paramBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder addAllParam(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxExpr.Expr> values) {
        if (paramBuilder_ == null) {
          ensureParamIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, param_);
          onChanged();
        } else {
          paramBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder clearParam() {
        if (paramBuilder_ == null) {
          param_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          paramBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder removeParam(int index) {
        if (paramBuilder_ == null) {
          ensureParamIsMutable();
          param_.remove(index);
          onChanged();
        } else {
          paramBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder getParamBuilder(
          int index) {
        return getParamFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getParamOrBuilder(
          int index) {
        if (paramBuilder_ == null) {
          return param_.get(index);  } else {
          return paramBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
           getParamOrBuilderList() {
        if (paramBuilder_ != null) {
          return paramBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(param_);
        }
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder addParamBuilder() {
        return getParamFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance());
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder addParamBuilder(
          int index) {
        return getParamFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance());
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder> 
           getParamBuilderList() {
        return getParamFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
          getParamFieldBuilder() {
        if (paramBuilder_ == null) {
          paramBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder>(
                  param_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          param_ = null;
        }
        return paramBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Expr.FunctionCall)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Expr.FunctionCall)
    private static final com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall();
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FunctionCall>
        PARSER = new com.google.protobuf.AbstractParser<FunctionCall>() {
      @java.lang.Override
      public FunctionCall parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<FunctionCall> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FunctionCall> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.FunctionCall getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface OperatorOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Expr.Operator)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * * name of operator 
     * </pre>
     *
     * <code>required string name = 1;</code>
     * @return Whether the name field is set.
     */
    boolean hasName();
    /**
     * <pre>
     * * name of operator 
     * </pre>
     *
     * <code>required string name = 1;</code>
     * @return The name.
     */
    java.lang.String getName();
    /**
     * <pre>
     * * name of operator 
     * </pre>
     *
     * <code>required string name = 1;</code>
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <pre>
     * * list of parameters 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> 
        getParamList();
    /**
     * <pre>
     * * list of parameters 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Expr getParam(int index);
    /**
     * <pre>
     * * list of parameters 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    int getParamCount();
    /**
     * <pre>
     * * list of parameters 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
        getParamOrBuilderList();
    /**
     * <pre>
     * * list of parameters 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getParamOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code Mysqlx.Expr.Operator}
   */
  public static final class Operator extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Expr.Operator)
      OperatorOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        Operator.class.getName());
    }
    // Use Operator.newBuilder() to construct.
    private Operator(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private Operator() {
      name_ = "";
      param_ = java.util.Collections.emptyList();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Operator_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Operator_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxExpr.Operator.class, com.mysql.cj.x.protobuf.MysqlxExpr.Operator.Builder.class);
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     * <pre>
     * * name of operator 
     * </pre>
     *
     * <code>required string name = 1;</code>
     * @return Whether the name field is set.
     */
    @java.lang.Override
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * * name of operator 
     * </pre>
     *
     * <code>required string name = 1;</code>
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * * name of operator 
     * </pre>
     *
     * <code>required string name = 1;</code>
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PARAM_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> param_;
    /**
     * <pre>
     * * list of parameters 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> getParamList() {
      return param_;
    }
    /**
     * <pre>
     * * list of parameters 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
        getParamOrBuilderList() {
      return param_;
    }
    /**
     * <pre>
     * * list of parameters 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    @java.lang.Override
    public int getParamCount() {
      return param_.size();
    }
    /**
     * <pre>
     * * list of parameters 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getParam(int index) {
      return param_.get(index);
    }
    /**
     * <pre>
     * * list of parameters 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getParamOrBuilder(
        int index) {
      return param_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasName()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getParamCount(); i++) {
        if (!getParam(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 1, name_);
      }
      for (int i = 0; i < param_.size(); i++) {
        output.writeMessage(2, param_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(1, name_);
      }
      for (int i = 0; i < param_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, param_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxExpr.Operator)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxExpr.Operator other = (com.mysql.cj.x.protobuf.MysqlxExpr.Operator) obj;

      if (hasName() != other.hasName()) return false;
      if (hasName()) {
        if (!getName()
            .equals(other.getName())) return false;
      }
      if (!getParamList()
          .equals(other.getParamList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasName()) {
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
      }
      if (getParamCount() > 0) {
        hash = (37 * hash) + PARAM_FIELD_NUMBER;
        hash = (53 * hash) + getParamList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxExpr.Operator prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Expr.Operator}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Expr.Operator)
        com.mysql.cj.x.protobuf.MysqlxExpr.OperatorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Operator_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Operator_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxExpr.Operator.class, com.mysql.cj.x.protobuf.MysqlxExpr.Operator.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxExpr.Operator.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        if (paramBuilder_ == null) {
          param_ = java.util.Collections.emptyList();
        } else {
          param_ = null;
          paramBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Operator_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.Operator getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.Operator.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.Operator build() {
        com.mysql.cj.x.protobuf.MysqlxExpr.Operator result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.Operator buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxExpr.Operator result = new com.mysql.cj.x.protobuf.MysqlxExpr.Operator(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(com.mysql.cj.x.protobuf.MysqlxExpr.Operator result) {
        if (paramBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            param_ = java.util.Collections.unmodifiableList(param_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.param_ = param_;
        } else {
          result.param_ = paramBuilder_.build();
        }
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxExpr.Operator result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxExpr.Operator) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxExpr.Operator)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxExpr.Operator other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxExpr.Operator.getDefaultInstance()) return this;
        if (other.hasName()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (paramBuilder_ == null) {
          if (!other.param_.isEmpty()) {
            if (param_.isEmpty()) {
              param_ = other.param_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureParamIsMutable();
              param_.addAll(other.param_);
            }
            onChanged();
          }
        } else {
          if (!other.param_.isEmpty()) {
            if (paramBuilder_.isEmpty()) {
              paramBuilder_.dispose();
              paramBuilder_ = null;
              param_ = other.param_;
              bitField0_ = (bitField0_ & ~0x00000002);
              paramBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getParamFieldBuilder() : null;
            } else {
              paramBuilder_.addAllMessages(other.param_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasName()) {
          return false;
        }
        for (int i = 0; i < getParamCount(); i++) {
          if (!getParam(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                name_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                com.mysql.cj.x.protobuf.MysqlxExpr.Expr m =
                    input.readMessage(
                        com.mysql.cj.x.protobuf.MysqlxExpr.Expr.parser(),
                        extensionRegistry);
                if (paramBuilder_ == null) {
                  ensureParamIsMutable();
                  param_.add(m);
                } else {
                  paramBuilder_.addMessage(m);
                }
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <pre>
       * * name of operator 
       * </pre>
       *
       * <code>required string name = 1;</code>
       * @return Whether the name field is set.
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * * name of operator 
       * </pre>
       *
       * <code>required string name = 1;</code>
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * * name of operator 
       * </pre>
       *
       * <code>required string name = 1;</code>
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * * name of operator 
       * </pre>
       *
       * <code>required string name = 1;</code>
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * name of operator 
       * </pre>
       *
       * <code>required string name = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * name of operator 
       * </pre>
       *
       * <code>required string name = 1;</code>
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> param_ =
        java.util.Collections.emptyList();
      private void ensureParamIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          param_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpr.Expr>(param_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> paramBuilder_;

      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> getParamList() {
        if (paramBuilder_ == null) {
          return java.util.Collections.unmodifiableList(param_);
        } else {
          return paramBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public int getParamCount() {
        if (paramBuilder_ == null) {
          return param_.size();
        } else {
          return paramBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getParam(int index) {
        if (paramBuilder_ == null) {
          return param_.get(index);
        } else {
          return paramBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder setParam(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (paramBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParamIsMutable();
          param_.set(index, value);
          onChanged();
        } else {
          paramBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder setParam(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (paramBuilder_ == null) {
          ensureParamIsMutable();
          param_.set(index, builderForValue.build());
          onChanged();
        } else {
          paramBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder addParam(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (paramBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParamIsMutable();
          param_.add(value);
          onChanged();
        } else {
          paramBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder addParam(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (paramBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParamIsMutable();
          param_.add(index, value);
          onChanged();
        } else {
          paramBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder addParam(
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (paramBuilder_ == null) {
          ensureParamIsMutable();
          param_.add(builderForValue.build());
          onChanged();
        } else {
          paramBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder addParam(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (paramBuilder_ == null) {
          ensureParamIsMutable();
          param_.add(index, builderForValue.build());
          onChanged();
        } else {
          paramBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder addAllParam(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxExpr.Expr> values) {
        if (paramBuilder_ == null) {
          ensureParamIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, param_);
          onChanged();
        } else {
          paramBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder clearParam() {
        if (paramBuilder_ == null) {
          param_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          paramBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public Builder removeParam(int index) {
        if (paramBuilder_ == null) {
          ensureParamIsMutable();
          param_.remove(index);
          onChanged();
        } else {
          paramBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder getParamBuilder(
          int index) {
        return getParamFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getParamOrBuilder(
          int index) {
        if (paramBuilder_ == null) {
          return param_.get(index);  } else {
          return paramBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
           getParamOrBuilderList() {
        if (paramBuilder_ != null) {
          return paramBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(param_);
        }
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder addParamBuilder() {
        return getParamFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance());
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder addParamBuilder(
          int index) {
        return getParamFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance());
      }
      /**
       * <pre>
       * * list of parameters 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr param = 2;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder> 
           getParamBuilderList() {
        return getParamFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
          getParamFieldBuilder() {
        if (paramBuilder_ == null) {
          paramBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder>(
                  param_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          param_ = null;
        }
        return paramBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Expr.Operator)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Expr.Operator)
    private static final com.mysql.cj.x.protobuf.MysqlxExpr.Operator DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxExpr.Operator();
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Operator getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Operator>
        PARSER = new com.google.protobuf.AbstractParser<Operator>() {
      @java.lang.Override
      public Operator parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Operator> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Operator> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.Operator getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ObjectOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Expr.Object)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * * list of fields 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField> 
        getFldList();
    /**
     * <pre>
     * * list of fields 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField getFld(int index);
    /**
     * <pre>
     * * list of fields 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
     */
    int getFldCount();
    /**
     * <pre>
     * * list of fields 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectFieldOrBuilder> 
        getFldOrBuilderList();
    /**
     * <pre>
     * * list of fields 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectFieldOrBuilder getFldOrBuilder(
        int index);
  }
  /**
   * <pre>
   * *
   * An object (with expression values)
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Expr.Object}
   */
  public static final class Object extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Expr.Object)
      ObjectOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        Object.class.getName());
    }
    // Use Object.newBuilder() to construct.
    private Object(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private Object() {
      fld_ = java.util.Collections.emptyList();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Object_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Object_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxExpr.Object.class, com.mysql.cj.x.protobuf.MysqlxExpr.Object.Builder.class);
    }

    public interface ObjectFieldOrBuilder extends
        // @@protoc_insertion_point(interface_extends:Mysqlx.Expr.Object.ObjectField)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * * identifier of field 
       * </pre>
       *
       * <code>required string key = 1;</code>
       * @return Whether the key field is set.
       */
      boolean hasKey();
      /**
       * <pre>
       * * identifier of field 
       * </pre>
       *
       * <code>required string key = 1;</code>
       * @return The key.
       */
      java.lang.String getKey();
      /**
       * <pre>
       * * identifier of field 
       * </pre>
       *
       * <code>required string key = 1;</code>
       * @return The bytes for key.
       */
      com.google.protobuf.ByteString
          getKeyBytes();

      /**
       * <pre>
       * * value of field 
       * </pre>
       *
       * <code>required .Mysqlx.Expr.Expr value = 2;</code>
       * @return Whether the value field is set.
       */
      boolean hasValue();
      /**
       * <pre>
       * * value of field 
       * </pre>
       *
       * <code>required .Mysqlx.Expr.Expr value = 2;</code>
       * @return The value.
       */
      com.mysql.cj.x.protobuf.MysqlxExpr.Expr getValue();
      /**
       * <pre>
       * * value of field 
       * </pre>
       *
       * <code>required .Mysqlx.Expr.Expr value = 2;</code>
       */
      com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getValueOrBuilder();
    }
    /**
     * Protobuf type {@code Mysqlx.Expr.Object.ObjectField}
     */
    public static final class ObjectField extends
        com.google.protobuf.GeneratedMessage implements
        // @@protoc_insertion_point(message_implements:Mysqlx.Expr.Object.ObjectField)
        ObjectFieldOrBuilder {
    private static final long serialVersionUID = 0L;
      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 29,
          /* patch= */ 0,
          /* suffix= */ "",
          ObjectField.class.getName());
      }
      // Use ObjectField.newBuilder() to construct.
      private ObjectField(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
      }
      private ObjectField() {
        key_ = "";
      }

      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Object_ObjectField_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Object_ObjectField_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.class, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder.class);
      }

      private int bitField0_;
      public static final int KEY_FIELD_NUMBER = 1;
      @SuppressWarnings("serial")
      private volatile java.lang.Object key_ = "";
      /**
       * <pre>
       * * identifier of field 
       * </pre>
       *
       * <code>required string key = 1;</code>
       * @return Whether the key field is set.
       */
      @java.lang.Override
      public boolean hasKey() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * * identifier of field 
       * </pre>
       *
       * <code>required string key = 1;</code>
       * @return The key.
       */
      @java.lang.Override
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            key_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * * identifier of field 
       * </pre>
       *
       * <code>required string key = 1;</code>
       * @return The bytes for key.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int VALUE_FIELD_NUMBER = 2;
      private com.mysql.cj.x.protobuf.MysqlxExpr.Expr value_;
      /**
       * <pre>
       * * value of field 
       * </pre>
       *
       * <code>required .Mysqlx.Expr.Expr value = 2;</code>
       * @return Whether the value field is set.
       */
      @java.lang.Override
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * * value of field 
       * </pre>
       *
       * <code>required .Mysqlx.Expr.Expr value = 2;</code>
       * @return The value.
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getValue() {
        return value_ == null ? com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance() : value_;
      }
      /**
       * <pre>
       * * value of field 
       * </pre>
       *
       * <code>required .Mysqlx.Expr.Expr value = 2;</code>
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getValueOrBuilder() {
        return value_ == null ? com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance() : value_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!hasKey()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!hasValue()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!getValue().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessage.writeString(output, 1, key_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(2, getValue());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessage.computeStringSize(1, key_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(2, getValue());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField)) {
          return super.equals(obj);
        }
        com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField other = (com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField) obj;

        if (hasKey() != other.hasKey()) return false;
        if (hasKey()) {
          if (!getKey()
              .equals(other.getKey())) return false;
        }
        if (hasValue() != other.hasValue()) return false;
        if (hasValue()) {
          if (!getValue()
              .equals(other.getValue())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasKey()) {
          hash = (37 * hash) + KEY_FIELD_NUMBER;
          hash = (53 * hash) + getKey().hashCode();
        }
        if (hasValue()) {
          hash = (37 * hash) + VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getValue().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseDelimitedWithIOException(PARSER, input);
      }

      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code Mysqlx.Expr.Object.ObjectField}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessage.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:Mysqlx.Expr.Object.ObjectField)
          com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectFieldOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Object_ObjectField_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Object_ObjectField_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.class, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder.class);
        }

        // Construct using com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessage
                  .alwaysUseFieldBuilders) {
            getValueFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          key_ = "";
          value_ = null;
          if (valueBuilder_ != null) {
            valueBuilder_.dispose();
            valueBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Object_ObjectField_descriptor;
        }

        @java.lang.Override
        public com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField getDefaultInstanceForType() {
          return com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.getDefaultInstance();
        }

        @java.lang.Override
        public com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField build() {
          com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField buildPartial() {
          com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField result = new com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField(this);
          if (bitField0_ != 0) { buildPartial0(result); }
          onBuilt();
          return result;
        }

        private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.key_ = key_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.value_ = valueBuilder_ == null
                ? value_
                : valueBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField) {
            return mergeFrom((com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField other) {
          if (other == com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.getDefaultInstance()) return this;
          if (other.hasKey()) {
            key_ = other.key_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasValue()) {
            mergeValue(other.getValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          if (!hasKey()) {
            return false;
          }
          if (!hasValue()) {
            return false;
          }
          if (!getValue().isInitialized()) {
            return false;
          }
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10: {
                  key_ = input.readBytes();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
                case 18: {
                  input.readMessage(
                      getValueFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
                default: {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }
        private int bitField0_;

        private java.lang.Object key_ = "";
        /**
         * <pre>
         * * identifier of field 
         * </pre>
         *
         * <code>required string key = 1;</code>
         * @return Whether the key field is set.
         */
        public boolean hasKey() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <pre>
         * * identifier of field 
         * </pre>
         *
         * <code>required string key = 1;</code>
         * @return The key.
         */
        public java.lang.String getKey() {
          java.lang.Object ref = key_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              key_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * * identifier of field 
         * </pre>
         *
         * <code>required string key = 1;</code>
         * @return The bytes for key.
         */
        public com.google.protobuf.ByteString
            getKeyBytes() {
          java.lang.Object ref = key_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            key_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * * identifier of field 
         * </pre>
         *
         * <code>required string key = 1;</code>
         * @param value The key to set.
         * @return This builder for chaining.
         */
        public Builder setKey(
            java.lang.String value) {
          if (value == null) { throw new NullPointerException(); }
          key_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * * identifier of field 
         * </pre>
         *
         * <code>required string key = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearKey() {
          key_ = getDefaultInstance().getKey();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         * <pre>
         * * identifier of field 
         * </pre>
         *
         * <code>required string key = 1;</code>
         * @param value The bytes for key to set.
         * @return This builder for chaining.
         */
        public Builder setKeyBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) { throw new NullPointerException(); }
          key_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.mysql.cj.x.protobuf.MysqlxExpr.Expr value_;
        private com.google.protobuf.SingleFieldBuilder<
            com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> valueBuilder_;
        /**
         * <pre>
         * * value of field 
         * </pre>
         *
         * <code>required .Mysqlx.Expr.Expr value = 2;</code>
         * @return Whether the value field is set.
         */
        public boolean hasValue() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <pre>
         * * value of field 
         * </pre>
         *
         * <code>required .Mysqlx.Expr.Expr value = 2;</code>
         * @return The value.
         */
        public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getValue() {
          if (valueBuilder_ == null) {
            return value_ == null ? com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance() : value_;
          } else {
            return valueBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * * value of field 
         * </pre>
         *
         * <code>required .Mysqlx.Expr.Expr value = 2;</code>
         */
        public Builder setValue(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
          if (valueBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            value_ = value;
          } else {
            valueBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * * value of field 
         * </pre>
         *
         * <code>required .Mysqlx.Expr.Expr value = 2;</code>
         */
        public Builder setValue(
            com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
          if (valueBuilder_ == null) {
            value_ = builderForValue.build();
          } else {
            valueBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * * value of field 
         * </pre>
         *
         * <code>required .Mysqlx.Expr.Expr value = 2;</code>
         */
        public Builder mergeValue(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
          if (valueBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0) &&
              value_ != null &&
              value_ != com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance()) {
              getValueBuilder().mergeFrom(value);
            } else {
              value_ = value;
            }
          } else {
            valueBuilder_.mergeFrom(value);
          }
          if (value_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         * <pre>
         * * value of field 
         * </pre>
         *
         * <code>required .Mysqlx.Expr.Expr value = 2;</code>
         */
        public Builder clearValue() {
          bitField0_ = (bitField0_ & ~0x00000002);
          value_ = null;
          if (valueBuilder_ != null) {
            valueBuilder_.dispose();
            valueBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <pre>
         * * value of field 
         * </pre>
         *
         * <code>required .Mysqlx.Expr.Expr value = 2;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder getValueBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getValueFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * * value of field 
         * </pre>
         *
         * <code>required .Mysqlx.Expr.Expr value = 2;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getValueOrBuilder() {
          if (valueBuilder_ != null) {
            return valueBuilder_.getMessageOrBuilder();
          } else {
            return value_ == null ?
                com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance() : value_;
          }
        }
        /**
         * <pre>
         * * value of field 
         * </pre>
         *
         * <code>required .Mysqlx.Expr.Expr value = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilder<
            com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
            getValueFieldBuilder() {
          if (valueBuilder_ == null) {
            valueBuilder_ = new com.google.protobuf.SingleFieldBuilder<
                com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder>(
                    getValue(),
                    getParentForChildren(),
                    isClean());
            value_ = null;
          }
          return valueBuilder_;
        }

        // @@protoc_insertion_point(builder_scope:Mysqlx.Expr.Object.ObjectField)
      }

      // @@protoc_insertion_point(class_scope:Mysqlx.Expr.Object.ObjectField)
      private static final com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField();
      }

      public static com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ObjectField>
          PARSER = new com.google.protobuf.AbstractParser<ObjectField>() {
        @java.lang.Override
        public ObjectField parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

      public static com.google.protobuf.Parser<ObjectField> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ObjectField> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public static final int FLD_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField> fld_;
    /**
     * <pre>
     * * list of fields 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField> getFldList() {
      return fld_;
    }
    /**
     * <pre>
     * * list of fields 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectFieldOrBuilder> 
        getFldOrBuilderList() {
      return fld_;
    }
    /**
     * <pre>
     * * list of fields 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
     */
    @java.lang.Override
    public int getFldCount() {
      return fld_.size();
    }
    /**
     * <pre>
     * * list of fields 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField getFld(int index) {
      return fld_.get(index);
    }
    /**
     * <pre>
     * * list of fields 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectFieldOrBuilder getFldOrBuilder(
        int index) {
      return fld_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getFldCount(); i++) {
        if (!getFld(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < fld_.size(); i++) {
        output.writeMessage(1, fld_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < fld_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, fld_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxExpr.Object)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxExpr.Object other = (com.mysql.cj.x.protobuf.MysqlxExpr.Object) obj;

      if (!getFldList()
          .equals(other.getFldList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getFldCount() > 0) {
        hash = (37 * hash) + FLD_FIELD_NUMBER;
        hash = (53 * hash) + getFldList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxExpr.Object prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * An object (with expression values)
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Expr.Object}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Expr.Object)
        com.mysql.cj.x.protobuf.MysqlxExpr.ObjectOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Object_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Object_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxExpr.Object.class, com.mysql.cj.x.protobuf.MysqlxExpr.Object.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxExpr.Object.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (fldBuilder_ == null) {
          fld_ = java.util.Collections.emptyList();
        } else {
          fld_ = null;
          fldBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Object_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.Object getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.Object.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.Object build() {
        com.mysql.cj.x.protobuf.MysqlxExpr.Object result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.Object buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxExpr.Object result = new com.mysql.cj.x.protobuf.MysqlxExpr.Object(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(com.mysql.cj.x.protobuf.MysqlxExpr.Object result) {
        if (fldBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            fld_ = java.util.Collections.unmodifiableList(fld_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.fld_ = fld_;
        } else {
          result.fld_ = fldBuilder_.build();
        }
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxExpr.Object result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxExpr.Object) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxExpr.Object)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxExpr.Object other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxExpr.Object.getDefaultInstance()) return this;
        if (fldBuilder_ == null) {
          if (!other.fld_.isEmpty()) {
            if (fld_.isEmpty()) {
              fld_ = other.fld_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureFldIsMutable();
              fld_.addAll(other.fld_);
            }
            onChanged();
          }
        } else {
          if (!other.fld_.isEmpty()) {
            if (fldBuilder_.isEmpty()) {
              fldBuilder_.dispose();
              fldBuilder_ = null;
              fld_ = other.fld_;
              bitField0_ = (bitField0_ & ~0x00000001);
              fldBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getFldFieldBuilder() : null;
            } else {
              fldBuilder_.addAllMessages(other.fld_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        for (int i = 0; i < getFldCount(); i++) {
          if (!getFld(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField m =
                    input.readMessage(
                        com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.parser(),
                        extensionRegistry);
                if (fldBuilder_ == null) {
                  ensureFldIsMutable();
                  fld_.add(m);
                } else {
                  fldBuilder_.addMessage(m);
                }
                break;
              } // case 10
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField> fld_ =
        java.util.Collections.emptyList();
      private void ensureFldIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          fld_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField>(fld_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectFieldOrBuilder> fldBuilder_;

      /**
       * <pre>
       * * list of fields 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField> getFldList() {
        if (fldBuilder_ == null) {
          return java.util.Collections.unmodifiableList(fld_);
        } else {
          return fldBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * * list of fields 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public int getFldCount() {
        if (fldBuilder_ == null) {
          return fld_.size();
        } else {
          return fldBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * * list of fields 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField getFld(int index) {
        if (fldBuilder_ == null) {
          return fld_.get(index);
        } else {
          return fldBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * * list of fields 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public Builder setFld(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField value) {
        if (fldBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFldIsMutable();
          fld_.set(index, value);
          onChanged();
        } else {
          fldBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * * list of fields 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public Builder setFld(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder builderForValue) {
        if (fldBuilder_ == null) {
          ensureFldIsMutable();
          fld_.set(index, builderForValue.build());
          onChanged();
        } else {
          fldBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * * list of fields 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public Builder addFld(com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField value) {
        if (fldBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFldIsMutable();
          fld_.add(value);
          onChanged();
        } else {
          fldBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * * list of fields 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public Builder addFld(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField value) {
        if (fldBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFldIsMutable();
          fld_.add(index, value);
          onChanged();
        } else {
          fldBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * * list of fields 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public Builder addFld(
          com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder builderForValue) {
        if (fldBuilder_ == null) {
          ensureFldIsMutable();
          fld_.add(builderForValue.build());
          onChanged();
        } else {
          fldBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * * list of fields 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public Builder addFld(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder builderForValue) {
        if (fldBuilder_ == null) {
          ensureFldIsMutable();
          fld_.add(index, builderForValue.build());
          onChanged();
        } else {
          fldBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * * list of fields 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public Builder addAllFld(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField> values) {
        if (fldBuilder_ == null) {
          ensureFldIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, fld_);
          onChanged();
        } else {
          fldBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * * list of fields 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public Builder clearFld() {
        if (fldBuilder_ == null) {
          fld_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          fldBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * * list of fields 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public Builder removeFld(int index) {
        if (fldBuilder_ == null) {
          ensureFldIsMutable();
          fld_.remove(index);
          onChanged();
        } else {
          fldBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * * list of fields 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder getFldBuilder(
          int index) {
        return getFldFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * * list of fields 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectFieldOrBuilder getFldOrBuilder(
          int index) {
        if (fldBuilder_ == null) {
          return fld_.get(index);  } else {
          return fldBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * * list of fields 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectFieldOrBuilder> 
           getFldOrBuilderList() {
        if (fldBuilder_ != null) {
          return fldBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(fld_);
        }
      }
      /**
       * <pre>
       * * list of fields 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder addFldBuilder() {
        return getFldFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.getDefaultInstance());
      }
      /**
       * <pre>
       * * list of fields 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder addFldBuilder(
          int index) {
        return getFldFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.getDefaultInstance());
      }
      /**
       * <pre>
       * * list of fields 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Object.ObjectField fld = 1;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder> 
           getFldBuilderList() {
        return getFldFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectFieldOrBuilder> 
          getFldFieldBuilder() {
        if (fldBuilder_ == null) {
          fldBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectField.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.Object.ObjectFieldOrBuilder>(
                  fld_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          fld_ = null;
        }
        return fldBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Expr.Object)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Expr.Object)
    private static final com.mysql.cj.x.protobuf.MysqlxExpr.Object DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxExpr.Object();
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Object getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Object>
        PARSER = new com.google.protobuf.AbstractParser<Object>() {
      @java.lang.Override
      public Object parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Object> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Object> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.Object getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ArrayOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Expr.Array)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * * list of values 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> 
        getValueList();
    /**
     * <pre>
     * * list of values 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Expr getValue(int index);
    /**
     * <pre>
     * * list of values 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
     */
    int getValueCount();
    /**
     * <pre>
     * * list of values 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
        getValueOrBuilderList();
    /**
     * <pre>
     * * list of values 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getValueOrBuilder(
        int index);
  }
  /**
   * <pre>
   * *
   * An array of expressions
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Expr.Array}
   */
  public static final class Array extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Expr.Array)
      ArrayOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        Array.class.getName());
    }
    // Use Array.newBuilder() to construct.
    private Array(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private Array() {
      value_ = java.util.Collections.emptyList();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Array_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Array_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxExpr.Array.class, com.mysql.cj.x.protobuf.MysqlxExpr.Array.Builder.class);
    }

    public static final int VALUE_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> value_;
    /**
     * <pre>
     * * list of values 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> getValueList() {
      return value_;
    }
    /**
     * <pre>
     * * list of values 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
        getValueOrBuilderList() {
      return value_;
    }
    /**
     * <pre>
     * * list of values 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
     */
    @java.lang.Override
    public int getValueCount() {
      return value_.size();
    }
    /**
     * <pre>
     * * list of values 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getValue(int index) {
      return value_.get(index);
    }
    /**
     * <pre>
     * * list of values 
     * </pre>
     *
     * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getValueOrBuilder(
        int index) {
      return value_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getValueCount(); i++) {
        if (!getValue(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < value_.size(); i++) {
        output.writeMessage(1, value_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < value_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, value_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxExpr.Array)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxExpr.Array other = (com.mysql.cj.x.protobuf.MysqlxExpr.Array) obj;

      if (!getValueList()
          .equals(other.getValueList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getValueCount() > 0) {
        hash = (37 * hash) + VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getValueList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxExpr.Array prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * An array of expressions
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Expr.Array}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Expr.Array)
        com.mysql.cj.x.protobuf.MysqlxExpr.ArrayOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Array_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Array_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxExpr.Array.class, com.mysql.cj.x.protobuf.MysqlxExpr.Array.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxExpr.Array.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (valueBuilder_ == null) {
          value_ = java.util.Collections.emptyList();
        } else {
          value_ = null;
          valueBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.internal_static_Mysqlx_Expr_Array_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.Array getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpr.Array.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.Array build() {
        com.mysql.cj.x.protobuf.MysqlxExpr.Array result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxExpr.Array buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxExpr.Array result = new com.mysql.cj.x.protobuf.MysqlxExpr.Array(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(com.mysql.cj.x.protobuf.MysqlxExpr.Array result) {
        if (valueBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            value_ = java.util.Collections.unmodifiableList(value_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.value_ = value_;
        } else {
          result.value_ = valueBuilder_.build();
        }
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxExpr.Array result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxExpr.Array) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxExpr.Array)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxExpr.Array other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxExpr.Array.getDefaultInstance()) return this;
        if (valueBuilder_ == null) {
          if (!other.value_.isEmpty()) {
            if (value_.isEmpty()) {
              value_ = other.value_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureValueIsMutable();
              value_.addAll(other.value_);
            }
            onChanged();
          }
        } else {
          if (!other.value_.isEmpty()) {
            if (valueBuilder_.isEmpty()) {
              valueBuilder_.dispose();
              valueBuilder_ = null;
              value_ = other.value_;
              bitField0_ = (bitField0_ & ~0x00000001);
              valueBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getValueFieldBuilder() : null;
            } else {
              valueBuilder_.addAllMessages(other.value_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        for (int i = 0; i < getValueCount(); i++) {
          if (!getValue(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                com.mysql.cj.x.protobuf.MysqlxExpr.Expr m =
                    input.readMessage(
                        com.mysql.cj.x.protobuf.MysqlxExpr.Expr.parser(),
                        extensionRegistry);
                if (valueBuilder_ == null) {
                  ensureValueIsMutable();
                  value_.add(m);
                } else {
                  valueBuilder_.addMessage(m);
                }
                break;
              } // case 10
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> value_ =
        java.util.Collections.emptyList();
      private void ensureValueIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          value_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpr.Expr>(value_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> valueBuilder_;

      /**
       * <pre>
       * * list of values 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> getValueList() {
        if (valueBuilder_ == null) {
          return java.util.Collections.unmodifiableList(value_);
        } else {
          return valueBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * * list of values 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public int getValueCount() {
        if (valueBuilder_ == null) {
          return value_.size();
        } else {
          return valueBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * * list of values 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getValue(int index) {
        if (valueBuilder_ == null) {
          return value_.get(index);
        } else {
          return valueBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * * list of values 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public Builder setValue(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValueIsMutable();
          value_.set(index, value);
          onChanged();
        } else {
          valueBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * * list of values 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public Builder setValue(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.set(index, builderForValue.build());
          onChanged();
        } else {
          valueBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * * list of values 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public Builder addValue(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValueIsMutable();
          value_.add(value);
          onChanged();
        } else {
          valueBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * * list of values 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public Builder addValue(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValueIsMutable();
          value_.add(index, value);
          onChanged();
        } else {
          valueBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * * list of values 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public Builder addValue(
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.add(builderForValue.build());
          onChanged();
        } else {
          valueBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * * list of values 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public Builder addValue(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.add(index, builderForValue.build());
          onChanged();
        } else {
          valueBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * * list of values 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public Builder addAllValue(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxExpr.Expr> values) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, value_);
          onChanged();
        } else {
          valueBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * * list of values 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public Builder clearValue() {
        if (valueBuilder_ == null) {
          value_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          valueBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * * list of values 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public Builder removeValue(int index) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.remove(index);
          onChanged();
        } else {
          valueBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * * list of values 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder getValueBuilder(
          int index) {
        return getValueFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * * list of values 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getValueOrBuilder(
          int index) {
        if (valueBuilder_ == null) {
          return value_.get(index);  } else {
          return valueBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * * list of values 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
           getValueOrBuilderList() {
        if (valueBuilder_ != null) {
          return valueBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(value_);
        }
      }
      /**
       * <pre>
       * * list of values 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder addValueBuilder() {
        return getValueFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance());
      }
      /**
       * <pre>
       * * list of values 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder addValueBuilder(
          int index) {
        return getValueFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance());
      }
      /**
       * <pre>
       * * list of values 
       * </pre>
       *
       * <code>repeated .Mysqlx.Expr.Expr value = 1;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder> 
           getValueBuilderList() {
        return getValueFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
          getValueFieldBuilder() {
        if (valueBuilder_ == null) {
          valueBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder>(
                  value_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          value_ = null;
        }
        return valueBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Expr.Array)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Expr.Array)
    private static final com.mysql.cj.x.protobuf.MysqlxExpr.Array DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxExpr.Array();
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpr.Array getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Array>
        PARSER = new com.google.protobuf.AbstractParser<Array>() {
      @java.lang.Override
      public Array parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Array> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Array> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxExpr.Array getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Expr_Expr_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Expr_Expr_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Expr_Identifier_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Expr_Identifier_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Expr_DocumentPathItem_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Expr_DocumentPathItem_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Expr_ColumnIdentifier_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Expr_ColumnIdentifier_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Expr_FunctionCall_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Expr_FunctionCall_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Expr_Operator_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Expr_Operator_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Expr_Object_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Expr_Object_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Expr_Object_ObjectField_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Expr_Object_ObjectField_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Expr_Array_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Expr_Array_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\021mysqlx_expr.proto\022\013Mysqlx.Expr\032\026mysqlx" +
      "_datatypes.proto\"\304\003\n\004Expr\022$\n\004type\030\001 \002(\0162" +
      "\026.Mysqlx.Expr.Expr.Type\0221\n\nidentifier\030\002 " +
      "\001(\0132\035.Mysqlx.Expr.ColumnIdentifier\022\020\n\010va" +
      "riable\030\003 \001(\t\022)\n\007literal\030\004 \001(\0132\030.Mysqlx.D" +
      "atatypes.Scalar\0220\n\rfunction_call\030\005 \001(\0132\031" +
      ".Mysqlx.Expr.FunctionCall\022\'\n\010operator\030\006 " +
      "\001(\0132\025.Mysqlx.Expr.Operator\022\020\n\010position\030\007" +
      " \001(\r\022#\n\006object\030\010 \001(\0132\023.Mysqlx.Expr.Objec" +
      "t\022!\n\005array\030\t \001(\0132\022.Mysqlx.Expr.Array\"q\n\004" +
      "Type\022\t\n\005IDENT\020\001\022\013\n\007LITERAL\020\002\022\014\n\010VARIABLE" +
      "\020\003\022\r\n\tFUNC_CALL\020\004\022\014\n\010OPERATOR\020\005\022\017\n\013PLACE" +
      "HOLDER\020\006\022\n\n\006OBJECT\020\007\022\t\n\005ARRAY\020\010\"/\n\nIdent" +
      "ifier\022\014\n\004name\030\001 \002(\t\022\023\n\013schema_name\030\002 \001(\t" +
      "\"\313\001\n\020DocumentPathItem\0220\n\004type\030\001 \002(\0162\".My" +
      "sqlx.Expr.DocumentPathItem.Type\022\r\n\005value" +
      "\030\002 \001(\t\022\r\n\005index\030\003 \001(\r\"g\n\004Type\022\n\n\006MEMBER\020" +
      "\001\022\023\n\017MEMBER_ASTERISK\020\002\022\017\n\013ARRAY_INDEX\020\003\022" +
      "\030\n\024ARRAY_INDEX_ASTERISK\020\004\022\023\n\017DOUBLE_ASTE" +
      "RISK\020\005\"\177\n\020ColumnIdentifier\0224\n\rdocument_p" +
      "ath\030\001 \003(\0132\035.Mysqlx.Expr.DocumentPathItem" +
      "\022\014\n\004name\030\002 \001(\t\022\022\n\ntable_name\030\003 \001(\t\022\023\n\013sc" +
      "hema_name\030\004 \001(\t\"W\n\014FunctionCall\022%\n\004name\030" +
      "\001 \002(\0132\027.Mysqlx.Expr.Identifier\022 \n\005param\030" +
      "\002 \003(\0132\021.Mysqlx.Expr.Expr\":\n\010Operator\022\014\n\004" +
      "name\030\001 \002(\t\022 \n\005param\030\002 \003(\0132\021.Mysqlx.Expr." +
      "Expr\"t\n\006Object\022,\n\003fld\030\001 \003(\0132\037.Mysqlx.Exp" +
      "r.Object.ObjectField\032<\n\013ObjectField\022\013\n\003k" +
      "ey\030\001 \002(\t\022 \n\005value\030\002 \002(\0132\021.Mysqlx.Expr.Ex" +
      "pr\")\n\005Array\022 \n\005value\030\001 \003(\0132\021.Mysqlx.Expr" +
      ".ExprB\031\n\027com.mysql.cj.x.protobuf"
    };
    descriptor = com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          com.mysql.cj.x.protobuf.MysqlxDatatypes.getDescriptor(),
        });
    internal_static_Mysqlx_Expr_Expr_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_Mysqlx_Expr_Expr_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Expr_Expr_descriptor,
        new java.lang.String[] { "Type", "Identifier", "Variable", "Literal", "FunctionCall", "Operator", "Position", "Object", "Array", });
    internal_static_Mysqlx_Expr_Identifier_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_Mysqlx_Expr_Identifier_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Expr_Identifier_descriptor,
        new java.lang.String[] { "Name", "SchemaName", });
    internal_static_Mysqlx_Expr_DocumentPathItem_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_Mysqlx_Expr_DocumentPathItem_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Expr_DocumentPathItem_descriptor,
        new java.lang.String[] { "Type", "Value", "Index", });
    internal_static_Mysqlx_Expr_ColumnIdentifier_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_Mysqlx_Expr_ColumnIdentifier_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Expr_ColumnIdentifier_descriptor,
        new java.lang.String[] { "DocumentPath", "Name", "TableName", "SchemaName", });
    internal_static_Mysqlx_Expr_FunctionCall_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_Mysqlx_Expr_FunctionCall_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Expr_FunctionCall_descriptor,
        new java.lang.String[] { "Name", "Param", });
    internal_static_Mysqlx_Expr_Operator_descriptor =
      getDescriptor().getMessageTypes().get(5);
    internal_static_Mysqlx_Expr_Operator_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Expr_Operator_descriptor,
        new java.lang.String[] { "Name", "Param", });
    internal_static_Mysqlx_Expr_Object_descriptor =
      getDescriptor().getMessageTypes().get(6);
    internal_static_Mysqlx_Expr_Object_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Expr_Object_descriptor,
        new java.lang.String[] { "Fld", });
    internal_static_Mysqlx_Expr_Object_ObjectField_descriptor =
      internal_static_Mysqlx_Expr_Object_descriptor.getNestedTypes().get(0);
    internal_static_Mysqlx_Expr_Object_ObjectField_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Expr_Object_ObjectField_descriptor,
        new java.lang.String[] { "Key", "Value", });
    internal_static_Mysqlx_Expr_Array_descriptor =
      getDescriptor().getMessageTypes().get(7);
    internal_static_Mysqlx_Expr_Array_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Expr_Array_descriptor,
        new java.lang.String[] { "Value", });
    descriptor.resolveAllFeaturesImmutable();
    com.mysql.cj.x.protobuf.MysqlxDatatypes.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
