/*
 * Decompiled with CFR 0.152.
 */
package com.mytechia.robobo.framework.hri.vision.basicCamera;

import android.util.Log;
import com.mytechia.robobo.framework.hri.vision.basicCamera.Frame;
import com.mytechia.robobo.framework.hri.vision.basicCamera.ICameraListener;
import com.mytechia.robobo.framework.hri.vision.basicCamera.ICameraModule;
import java.util.HashSet;
import org.opencv.core.Mat;

public abstract class ACameraModule
implements ICameraModule {
    private HashSet<ICameraListener> listeners = new HashSet();

    protected void notifyFrame(Frame frame) {
        for (ICameraListener listener : this.listeners) {
            listener.onNewFrame(frame);
        }
    }

    protected void notifyMat(Mat mat) {
        for (ICameraListener listener : this.listeners) {
            listener.onNewMat(mat);
        }
    }

    @Override
    public void suscribe(ICameraListener listener) {
        Log.d((String)"Cam_module", (String)("Suscribed:" + listener.toString()));
        this.listeners.add(listener);
    }

    @Override
    public void unsuscribe(ICameraListener listener) {
        this.listeners.remove(listener);
    }
}

