/*
 * Decompiled with CFR 0.152.
 */
package com.mytechia.robobo.framework.hri.vision.basicCamera.android;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.v4.app.ActivityCompat;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import android.util.SparseIntArray;
import android.view.Display;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.WindowManager;
import com.mytechia.commons.framework.exception.InternalErrorException;
import com.mytechia.robobo.framework.RoboboManager;
import com.mytechia.robobo.framework.hri.vision.basicCamera.ACameraModule;
import com.mytechia.robobo.framework.hri.vision.basicCamera.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.opencv.android.CameraBridgeViewBase;

public class AndroidCameraModule
extends ACameraModule {
    private static final String LOGGER = "Camera";
    private static final int BUFFER_NUM_IMAGE = 15;
    public static final String CAMERA = "camera";
    public static final String IMAGE_COMPRESSED = "image/compressed";
    public static final String CAMERA_INFO = "/camera_info";
    public static final String JPEG = "jpeg";
    private ChannelBufferOutputStream stream;
    private Context context;
    private HandlerThread mBackgroundThread;
    private Handler mBackgroundHandler;
    private CameraDevice cameraDevice;
    private ImageReader imageReader;
    private CameraCaptureSession mCaptureSession;
    private int resolution_height = 640;
    private int resolution_width = 480;
    private Semaphore mCameraOpenCloseLock = new Semaphore(1);
    private Surface jpegCaptureSurface;
    private String cameraId = "0";
    private int sequence = 0;
    private static final SparseIntArray ORIENTATIONS = new SparseIntArray();
    private CameraCharacteristics characteristics;

    public void startup(RoboboManager manager) throws InternalErrorException {
        this.context = manager.getApplicationContext();
        Properties properties = new Properties();
        AssetManager assetManager = manager.getApplicationContext().getAssets();
        try {
            InputStream inputStream = assetManager.open("vision.properties");
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.resolution_height = Integer.parseInt(properties.getProperty("resolution_height"));
        this.resolution_width = Integer.parseInt(properties.getProperty("resolution_width"));
        PackageManager pm = this.context.getPackageManager();
        if (!pm.hasSystemFeature("android.hardware.camera.any")) {
            throw new RuntimeException("The device has no camera");
        }
        this.stream = new ChannelBufferOutputStream(ChannelBuffers.dynamicBuffer((ByteOrder)ByteOrder.LITTLE_ENDIAN, (int)256));
        this.configureCamera();
    }

    public void shutdown() throws InternalErrorException {
        this.closeCamera();
        this.stopBackgroundThread();
    }

    public String getModuleInfo() {
        return null;
    }

    public String getModuleVersion() {
        return null;
    }

    private void configureCamera() {
        this.startBackgroundThread();
        CameraManager mCameraManager = (CameraManager)this.context.getSystemService(CAMERA);
        if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.CAMERA") != 0) {
            Log.e((String)LOGGER, (String)"Permission camera not granted");
            return;
        }
        try {
            if (!this.mCameraOpenCloseLock.tryAcquire(2500L, TimeUnit.MILLISECONDS)) {
                Log.e((String)LOGGER, (String)"Time out waiting to lock camera opening.");
            }
        }
        catch (InterruptedException e) {
            Log.e((String)LOGGER, (String)"Time out waiting to lock camera opening.");
            return;
        }
        try {
            PackageManager pm = this.context.getPackageManager();
            this.cameraId = pm.hasSystemFeature("android.hardware.camera.front") ? this.getFrontFacingCameraId(mCameraManager) : this.getBackFacingCameraId(mCameraManager);
            mCameraManager.openCamera(this.cameraId, (CameraDevice.StateCallback)new CameraDeviceStateCallback(mCameraManager), this.mBackgroundHandler);
        }
        catch (CameraAccessException ex) {
            Log.e((String)LOGGER, (String)"Error open camera", (Throwable)ex);
        }
    }

    @Override
    public void signalInit() {
    }

    @Override
    public void passSurfaceView(SurfaceView view) {
    }

    @Override
    public void passOCVthings(CameraBridgeViewBase bridgebase) {
    }

    @Override
    public void changeCamera() {
    }

    private String getBackFacingCameraId(CameraManager cManager) throws CameraAccessException {
        for (String cameraId : cManager.getCameraIdList()) {
            CameraCharacteristics characteristics = cManager.getCameraCharacteristics(cameraId);
            int cOrientation = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
            if (cOrientation != 1) continue;
            return cameraId;
        }
        return null;
    }

    private String getFrontFacingCameraId(CameraManager cManager) throws CameraAccessException {
        PackageManager pm = this.context.getPackageManager();
        for (String cameraId : cManager.getCameraIdList()) {
            CameraCharacteristics characteristics = cManager.getCameraCharacteristics(cameraId);
            int cOrientation = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
            if (cOrientation != 0) continue;
            return cameraId;
        }
        return null;
    }

    private void startBackgroundThread() {
        this.mBackgroundThread = new HandlerThread("CameraBackgroundThread");
        this.mBackgroundThread.setPriority(10);
        this.mBackgroundThread.start();
        this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
    }

    private void stopBackgroundThread() {
        Log.d((String)LOGGER, (String)"Stopping background thread");
        if (this.mBackgroundThread == null) {
            return;
        }
        this.mBackgroundThread.quitSafely();
        try {
            this.mBackgroundThread.join();
            this.mBackgroundThread = null;
            this.mBackgroundHandler = null;
        }
        catch (InterruptedException e) {
            Log.w((String)LOGGER, (Throwable)e);
        }
    }

    private synchronized void sendImage(Image mImage) {
        Frame frame = new Frame();
        String frameId = CAMERA;
        int width = mImage.getWidth();
        int height = mImage.getHeight();
        frame.setFrameId(frameId);
        frame.setSeqNum(this.sequence);
        frame.setHeight(mImage.getHeight());
        frame.setWidth(mImage.getWidth());
        this.stream.buffer().writeBytes(mImage.getPlanes()[0].getBuffer());
        mImage.close();
        frame.setBitmap(Frame.decodeBytes(this.stream.buffer().array()));
        this.stream.buffer().clear();
        this.notifyFrame(frame);
        ++this.sequence;
    }

    private static int sensorToDeviceRotation(int sensorOrientation, int deviceOrientation) {
        int angleDeviceOrientation = ORIENTATIONS.get(deviceOrientation);
        return Math.abs(sensorOrientation - angleDeviceOrientation);
    }

    private void closeCamera() {
        Log.d((String)LOGGER, (String)"Closing camera");
        try {
            this.mCameraOpenCloseLock.acquire();
            if (null != this.mCaptureSession) {
                this.mCaptureSession.close();
                this.mCaptureSession = null;
            }
            if (null != this.cameraDevice) {
                this.cameraDevice.close();
                this.cameraDevice = null;
            }
            if (null != this.imageReader) {
                this.imageReader.close();
                this.imageReader = null;
            }
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException e) {
                    Log.w((String)LOGGER, (Throwable)e);
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to lock camera closing.", e);
        }
        finally {
            this.mCameraOpenCloseLock.release();
        }
    }

    static {
        ORIENTATIONS.append(0, 0);
        ORIENTATIONS.append(1, 90);
        ORIENTATIONS.append(2, 180);
        ORIENTATIONS.append(3, 270);
    }

    static class CompareSizesByArea
    implements Comparator<Size> {
        CompareSizesByArea() {
        }

        @Override
        public int compare(Size lhs, Size rhs) {
            return Long.signum((long)lhs.getWidth() * (long)lhs.getHeight() - (long)rhs.getWidth() * (long)rhs.getHeight());
        }
    }

    private class ImageAvailableListener
    implements ImageReader.OnImageAvailableListener {
        private ImageAvailableListener() {
        }

        public void onImageAvailable(ImageReader reader) {
            Image mImage = reader.acquireNextImage();
            AndroidCameraModule.this.sendImage(mImage);
        }
    }

    private class CameraCaptureSessionCaptureCallback
    extends CameraCaptureSession.CaptureCallback {
        private CameraCaptureSessionCaptureCallback() {
        }

        public void onCaptureStarted(CameraCaptureSession session, CaptureRequest request, long timestamp, long frameNumber) {
            super.onCaptureStarted(session, request, timestamp, frameNumber);
        }
    }

    private class CaptureSessionStateCallback
    extends CameraCaptureSession.StateCallback {
        private CaptureSessionStateCallback() {
        }

        public void onConfigured(CameraCaptureSession session) {
            AndroidCameraModule.this.mCaptureSession = session;
            CaptureRequest captureRequest = null;
            CaptureRequest.Builder captureRequestBuilder = null;
            try {
                captureRequestBuilder = AndroidCameraModule.this.cameraDevice.createCaptureRequest(1);
            }
            catch (CameraAccessException ex) {
                Log.e((String)AndroidCameraModule.LOGGER, (String)"Error create capture request", (Throwable)ex);
                return;
            }
            captureRequestBuilder.addTarget(AndroidCameraModule.this.jpegCaptureSurface);
            Integer mSensorOrientation = (Integer)AndroidCameraModule.this.characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
            Display display = ((WindowManager)AndroidCameraModule.this.context.getSystemService("window")).getDefaultDisplay();
            int displayOrientation = display.getRotation();
            captureRequestBuilder.set(CaptureRequest.JPEG_ORIENTATION, (Object)AndroidCameraModule.sensorToDeviceRotation(mSensorOrientation, displayOrientation));
            captureRequestBuilder.set(CaptureRequest.JPEG_QUALITY, (Object)75);
            captureRequestBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)Range.create((Comparable)Integer.valueOf(20), (Comparable)Integer.valueOf(30)));
            captureRequest = captureRequestBuilder.build();
            try {
                session.setRepeatingRequest(captureRequest, (CameraCaptureSession.CaptureCallback)new CameraCaptureSessionCaptureCallback(), AndroidCameraModule.this.mBackgroundHandler);
            }
            catch (CameraAccessException ex) {
                Log.e((String)AndroidCameraModule.LOGGER, (String)"Error create capture request", (Throwable)ex);
                return;
            }
        }

        public void onConfigureFailed(CameraCaptureSession session) {
            Log.e((String)AndroidCameraModule.LOGGER, (String)"Error configuration camera capture session");
        }
    }

    private class CameraDeviceStateCallback
    extends CameraDevice.StateCallback {
        private CameraManager mCameraManager;

        public CameraDeviceStateCallback(CameraManager mCameraManager) {
            this.mCameraManager = mCameraManager;
        }

        public void onOpened(CameraDevice camera) {
            Size size;
            AndroidCameraModule.this.mCameraOpenCloseLock.release();
            AndroidCameraModule.this.cameraDevice = camera;
            AndroidCameraModule.this.characteristics = null;
            try {
                AndroidCameraModule.this.characteristics = this.mCameraManager.getCameraCharacteristics(AndroidCameraModule.this.cameraId);
            }
            catch (CameraAccessException ex) {
                Log.e((String)AndroidCameraModule.LOGGER, (String)"Error camera access exception", (Throwable)ex);
            }
            StreamConfigurationMap configs = (StreamConfigurationMap)AndroidCameraModule.this.characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            Size[] sizes = configs.getOutputSizes(256);
            Arrays.sort(sizes, new CompareSizesByArea());
            Size preferredSize = new Size(AndroidCameraModule.this.resolution_height, AndroidCameraModule.this.resolution_height);
            int indexSelectedSize = 0;
            int index = 0;
            while (index < sizes.length && (size = sizes[indexSelectedSize = index++]).getWidth() <= preferredSize.getWidth()) {
            }
            Size capturedSize = sizes[indexSelectedSize];
            AndroidCameraModule.this.imageReader = ImageReader.newInstance((int)capturedSize.getWidth(), (int)capturedSize.getHeight(), (int)256, (int)15);
            AndroidCameraModule.this.imageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)new ImageAvailableListener(), AndroidCameraModule.this.mBackgroundHandler);
            AndroidCameraModule.this.jpegCaptureSurface = AndroidCameraModule.this.imageReader.getSurface();
            ArrayList<Surface> surfaces = new ArrayList<Surface>();
            surfaces.add(AndroidCameraModule.this.jpegCaptureSurface);
            try {
                AndroidCameraModule.this.cameraDevice.createCaptureSession(surfaces, (CameraCaptureSession.StateCallback)new CaptureSessionStateCallback(), AndroidCameraModule.this.mBackgroundHandler);
            }
            catch (CameraAccessException ex) {
                Log.e((String)AndroidCameraModule.LOGGER, (String)"Error create camera capture session", (Throwable)ex);
            }
        }

        public void onDisconnected(CameraDevice camera) {
            AndroidCameraModule.this.mCameraOpenCloseLock.release();
            AndroidCameraModule.this.cameraDevice.close();
            AndroidCameraModule.this.cameraDevice = null;
            Log.w((String)AndroidCameraModule.LOGGER, (String)("Disconnected camera[id=" + camera.getId() + "]"));
        }

        public void onError(CameraDevice camera, int error) {
            AndroidCameraModule.this.mCameraOpenCloseLock.release();
            AndroidCameraModule.this.cameraDevice = null;
            Log.e((String)AndroidCameraModule.LOGGER, (String)("Error openning camera[id=" + camera.getId() + "], error=" + error));
        }
    }
}

