/*
 * Decompiled with CFR 0.152.
 */
package com.mytechia.robobo.framework.hri.vision.basicCamera.opencv;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.os.Looper;
import android.util.Log;
import android.view.SurfaceView;
import android.view.ViewGroup;
import com.mytechia.commons.framework.exception.InternalErrorException;
import com.mytechia.robobo.framework.RoboboManager;
import com.mytechia.robobo.framework.hri.vision.basicCamera.ACameraModule;
import com.mytechia.robobo.framework.hri.vision.basicCamera.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.opencv.android.BaseLoaderCallback;
import org.opencv.android.CameraBridgeViewBase;
import org.opencv.android.LoaderCallbackInterface;
import org.opencv.android.OpenCVLoader;
import org.opencv.android.Utils;
import org.opencv.core.Core;
import org.opencv.core.Mat;

public class OpenCVCameraModule
extends ACameraModule
implements CameraBridgeViewBase.CvCameraViewListener2 {
    private static final String TAG = "OpenCVCameraModule";
    private CameraBridgeViewBase mOpenCvCameraView;
    private Context context;
    private boolean notifyBitmap = true;
    private boolean notifyMat = true;
    private int index = 98;
    private int resolution_height = 640;
    private int resolution_width = 480;
    private BaseLoaderCallback mLoaderCallback = new BaseLoaderCallback(this.context){

        public void onManagerConnected(int status) {
            switch (status) {
                case 0: {
                    Log.i((String)OpenCVCameraModule.TAG, (String)"OpenCV loaded successfully");
                    OpenCVCameraModule.this.mOpenCvCameraView.enableView();
                    break;
                }
                default: {
                    super.onManagerConnected(status);
                }
            }
        }
    };

    public void startup(RoboboManager manager) throws InternalErrorException {
        this.context = manager.getApplicationContext();
        Looper.prepare();
        Properties properties = new Properties();
        AssetManager assetManager = manager.getApplicationContext().getAssets();
        try {
            InputStream inputStream = assetManager.open("vision.properties");
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.resolution_height = Integer.parseInt(properties.getProperty("resolution_height"));
        this.resolution_width = Integer.parseInt(properties.getProperty("resolution_width"));
    }

    public void shutdown() throws InternalErrorException {
        if (this.mOpenCvCameraView != null) {
            this.mOpenCvCameraView.disableView();
        }
    }

    public String getModuleInfo() {
        return "OpenCvCameraModule";
    }

    public String getModuleVersion() {
        return "v0.1";
    }

    @Override
    public void signalInit() {
        this.mOpenCvCameraView.setCvCameraViewListener((CameraBridgeViewBase.CvCameraViewListener2)this);
        this.mOpenCvCameraView.disableFpsMeter();
        if (!OpenCVLoader.initDebug()) {
            Log.d((String)TAG, (String)"Internal OpenCV library not found. Using OpenCV Manager for initialization");
            OpenCVLoader.initAsync((String)"3.0.0", (Context)this.context, (LoaderCallbackInterface)this.mLoaderCallback);
        } else {
            Log.d((String)TAG, (String)"OpenCV library found inside package. Using it!");
            this.mLoaderCallback.onManagerConnected(0);
        }
    }

    @Override
    public void passSurfaceView(SurfaceView view) {
    }

    @Override
    public void passOCVthings(CameraBridgeViewBase bridgebase) {
        this.mOpenCvCameraView = bridgebase;
        ViewGroup.LayoutParams params = bridgebase.getLayoutParams();
        params.height = this.resolution_height;
        params.width = this.resolution_width;
        bridgebase.setLayoutParams(params);
    }

    @Override
    public void changeCamera() {
        switch (this.index) {
            case 99: {
                this.index = 98;
                break;
            }
            case 98: {
                this.index = 99;
            }
        }
        Log.d((String)TAG, (String)("New camera index: " + this.index));
        this.mOpenCvCameraView.disableView();
        this.mOpenCvCameraView.setCameraIndex(this.index);
        this.mOpenCvCameraView.enableView();
    }

    public Mat onCameraFrame(CameraBridgeViewBase.CvCameraViewFrame inputFrame) {
        Mat mat = inputFrame.rgba();
        Core.flip((Mat)mat.t(), (Mat)mat, (int)1);
        Bitmap bmp = Bitmap.createBitmap((int)mat.cols(), (int)mat.rows(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Utils.matToBitmap((Mat)mat, (Bitmap)bmp);
        Frame frame = new Frame();
        frame.setHeight(bmp.getHeight());
        frame.setWidth(bmp.getWidth());
        frame.setBitmap(bmp);
        this.notifyFrame(frame);
        if (this.notifyMat) {
            this.notifyMat(mat);
        }
        return null;
    }

    public void onCameraViewStarted(int width, int height) {
        Log.d((String)TAG, (String)("Camera view started, resolution: " + height + "x" + width));
    }

    public void onCameraViewStopped() {
        Log.d((String)TAG, (String)"Camera view stopped");
    }
}

