/*
 * Decompiled with CFR 0.152.
 */
package com.mytechia.robobo.framework.hri.vision.colorDetection;

import com.mytechia.robobo.framework.hri.vision.colorDetection.IColorDetectionModule;
import com.mytechia.robobo.framework.hri.vision.colorDetection.IColorListener;
import com.mytechia.robobo.framework.remote_control.remotemodule.IRemoteControlModule;
import com.mytechia.robobo.framework.remote_control.remotemodule.Status;
import java.util.HashSet;

public abstract class AColorDetectionModule
implements IColorDetectionModule {
    private HashSet<IColorListener> listeners = new HashSet();
    protected IRemoteControlModule rcmodule = null;

    @Override
    public void suscribe(IColorListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unsuscribe(IColorListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyColor(int colorrgb, int nearest_color) {
        for (IColorListener listener : this.listeners) {
            listener.onNewColor(colorrgb, nearest_color);
        }
        if (this.rcmodule != null) {
            Status status = new Status("NEWCOLOR");
            switch (nearest_color) {
                case -16776961: {
                    status.putContents("color", "blue");
                    break;
                }
                case -16711681: {
                    status.putContents("color", "cyan");
                    break;
                }
                case -65281: {
                    status.putContents("color", "magenta");
                    break;
                }
                case -16711936: {
                    status.putContents("color", "green");
                    break;
                }
                case -256: {
                    status.putContents("color", "yellow");
                    break;
                }
                case -65536: {
                    status.putContents("color", "red");
                }
            }
            this.rcmodule.postStatus(status);
        }
    }
}

