/*
 * Decompiled with CFR 0.152.
 */
package com.mytechia.robobo.framework.hri.vision.colorDetection.opencv;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.util.Log;
import com.mytechia.commons.framework.exception.InternalErrorException;
import com.mytechia.robobo.framework.RoboboManager;
import com.mytechia.robobo.framework.hri.vision.basicCamera.Frame;
import com.mytechia.robobo.framework.hri.vision.basicCamera.ICameraListener;
import com.mytechia.robobo.framework.hri.vision.basicCamera.ICameraModule;
import com.mytechia.robobo.framework.hri.vision.colorDetection.AColorDetectionModule;
import com.mytechia.robobo.framework.remote_control.remotemodule.IRemoteControlModule;
import java.util.ArrayList;
import org.opencv.android.BaseLoaderCallback;
import org.opencv.android.LoaderCallbackInterface;
import org.opencv.android.OpenCVLoader;
import org.opencv.android.Utils;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;

public class OpenCvColorDetectionModule
extends AColorDetectionModule
implements ICameraListener {
    private String TAG = "OCVCOolormodule";
    private Context context;
    private int cuentaframes = 0;
    private boolean paused = true;
    private ICameraModule cameraModule;
    private boolean rcpresent = false;
    private BaseLoaderCallback mLoaderCallback = new BaseLoaderCallback(this.context){

        public void onManagerConnected(int status) {
            switch (status) {
                case 0: {
                    Log.i((String)OpenCvColorDetectionModule.this.TAG, (String)"OpenCV loaded successfully");
                    break;
                }
                default: {
                    super.onManagerConnected(status);
                }
            }
        }
    };

    public void startup(RoboboManager manager) throws InternalErrorException {
        this.context = manager.getApplicationContext();
        if (!OpenCVLoader.initDebug()) {
            Log.d((String)this.TAG, (String)"Internal OpenCV library not found. Using OpenCV Manager for initialization");
            OpenCVLoader.initAsync((String)"3.0.0", (Context)this.context, (LoaderCallbackInterface)this.mLoaderCallback);
        } else {
            Log.d((String)this.TAG, (String)"OpenCV library found inside package. Using it!");
            this.mLoaderCallback.onManagerConnected(0);
        }
        this.cameraModule = (ICameraModule)manager.getModuleInstance(ICameraModule.class);
        this.rcmodule = (IRemoteControlModule)manager.getModuleInstance(IRemoteControlModule.class);
        this.cameraModule.suscribe(this);
    }

    public void shutdown() throws InternalErrorException {
    }

    public String getModuleInfo() {
        return null;
    }

    public String getModuleVersion() {
        return null;
    }

    private void processFrame(Bitmap bmp) {
        Scalar mBlobColorHsv = new Scalar(0.0, 0.0, 0.0);
        Bitmap bmp32 = bmp.copy(Bitmap.Config.ARGB_8888, true);
        Mat imageMat = new Mat(bmp.getHeight(), bmp.getWidth(), CvType.CV_8UC3);
        Mat hsvMat = new Mat(bmp.getHeight(), bmp.getWidth(), CvType.CV_8UC3);
        Mat bwimage = new Mat(bmp.getHeight(), bmp.getWidth(), CvType.CV_8UC1);
        Imgproc.equalizeHist((Mat)bwimage, (Mat)bwimage);
        Utils.bitmapToMat((Bitmap)bmp32, (Mat)imageMat);
        Imgproc.cvtColor((Mat)imageMat, (Mat)hsvMat, (int)41, (int)3);
        Imgproc.cvtColor((Mat)imageMat, (Mat)bwimage, (int)7, (int)1);
        ArrayList contours = new ArrayList();
        Imgproc.Canny((Mat)bwimage, (Mat)bwimage, (double)75.0, (double)100.0);
        Imgproc.findContours((Mat)bwimage, contours, (Mat)new Mat(), (int)1, (int)2);
        bwimage.release();
        double maxArea = -1.0;
        int maxAreaIdx = -1;
        for (int idx = 0; idx < contours.size(); ++idx) {
            Mat contour = (Mat)contours.get(idx);
            double contourarea = Imgproc.contourArea((Mat)contour);
            if (!(contourarea > maxArea)) continue;
            maxArea = contourarea;
            maxAreaIdx = idx;
        }
        if (maxArea > 500.0) {
            MatOfPoint contour = (MatOfPoint)contours.get(maxAreaIdx);
            Mat contourMat = Mat.zeros((int)bmp.getHeight(), (int)bmp.getWidth(), (int)CvType.CV_8UC1);
            Imgproc.drawContours((Mat)contourMat, contours, (int)maxAreaIdx, (Scalar)new Scalar(1.0), (int)-1);
            Rect boundingRect = Imgproc.boundingRect((MatOfPoint)contour);
            ArrayList lHsv = new ArrayList(3);
            Core.split((Mat)hsvMat, lHsv);
            Mat mH = (Mat)lHsv.get(0);
            Mat mS = (Mat)lHsv.get(1);
            Mat mV = (Mat)lHsv.get(2);
            double meansum = 0.0;
            double means = 0.0;
            double meanv = 0.0;
            double squaredsum = 0.0;
            double squaredsumv = 0.0;
            double count = 0.0;
            for (int i = 0; i < contourMat.rows(); ++i) {
                for (int j = 0; j < contourMat.cols(); ++j) {
                    if (contourMat.get(i, j)[0] == 0.0) continue;
                    count += 1.0;
                    double pixel = mH.get(i, j)[0];
                    double pixelv = mH.get(i, j)[0];
                    meansum += pixel;
                    meanv += mH.get(i, j)[0];
                    means += mS.get(i, j)[0];
                    squaredsum += Math.pow(pixel, 2.0);
                    squaredsumv += Math.pow(pixel, 2.0);
                }
            }
            double mean = meansum / count;
            means /= count;
            double meansquearedvalues = squaredsum / count;
            double meansquearedvaluesv = squaredsumv / count;
            double variance = meansquearedvalues / Math.pow(mean, 2.0);
            double variancev = meansquearedvaluesv / Math.pow(meanv /= count, 2.0);
            double variances = meansquearedvalues / Math.pow(meanv, 2.0);
            Log.d((String)this.TAG, (String)("Variance: " + variance + " Mean: " + mean + " Variance v: " + variancev + " Mean v: " + meanv));
            if (variance < 1.03) {
                hsvMat.release();
                float[] floatHsv = new float[]{(float)mean * 2.0f, (float)means, (float)meanv};
                Imgproc.drawContours((Mat)imageMat, contours, (int)maxAreaIdx, (Scalar)new Scalar(255.0));
                Utils.matToBitmap((Mat)imageMat, (Bitmap)bmp);
                mBlobColorHsv.val[0] = mean * 2.0;
                int colorrgb = Color.HSVToColor((float[])floatHsv);
                mean -= 8.0;
                if (mean < 0.0) {
                    mean = 171.0 + Math.abs(mean);
                }
                if (mean > 166.0 && mean <= 179.0) {
                    Log.d((String)this.TAG, (String)("RED" + mean));
                    this.notifyColor(colorrgb, -65536);
                }
                if (mean > 0.0 && mean <= 29.0) {
                    Log.d((String)this.TAG, (String)("YELLOW" + mean));
                    this.notifyColor(colorrgb, -256);
                }
                if (mean > 30.0 && mean <= 66.0) {
                    Log.d((String)this.TAG, (String)("GREEN" + mean));
                    this.notifyColor(colorrgb, -16711936);
                }
                if (mean > 67.0 && mean <= 96.0) {
                    Log.d((String)this.TAG, (String)("CYAN" + mean));
                    this.notifyColor(colorrgb, -16711681);
                }
                if (mean > 97.0 && mean <= 141.0) {
                    Log.d((String)this.TAG, (String)("BLUE" + mean));
                    this.notifyColor(colorrgb, -16776961);
                }
                if (mean > 142.0 && mean <= 165.0) {
                    Log.d((String)this.TAG, (String)("MAGENTA" + mean));
                    this.notifyColor(colorrgb, -65281);
                }
            }
        }
    }

    @Override
    public void startDetection() {
        this.paused = false;
    }

    @Override
    public void pauseDetection() {
        this.paused = true;
    }

    @Override
    public void onNewFrame(Frame frame) {
        if (!this.paused) {
            this.processFrame(frame.getBitmap());
        }
    }

    @Override
    public void onNewMat(Mat mat) {
    }
}

