/*
 * Decompiled with CFR 0.152.
 */
package com.mytechia.robobo.framework.hri.vision.colorMesaurement.opencv;

import com.mytechia.commons.framework.exception.InternalErrorException;
import com.mytechia.robobo.framework.RoboboManager;
import com.mytechia.robobo.framework.hri.vision.basicCamera.Frame;
import com.mytechia.robobo.framework.hri.vision.basicCamera.ICameraListener;
import com.mytechia.robobo.framework.hri.vision.basicCamera.ICameraModule;
import com.mytechia.robobo.framework.hri.vision.colorMesaurement.AColorMesaurementModule;
import com.mytechia.robobo.framework.remote_control.remotemodule.IRemoteControlModule;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.imgproc.Imgproc;

public class OpenCVColorMesaurementModule
extends AColorMesaurementModule
implements ICameraListener {
    private ICameraModule cameraModule;
    private String TAG = "OCVColorMesaurement";

    public void startup(RoboboManager manager) throws InternalErrorException {
        this.cameraModule = (ICameraModule)manager.getModuleInstance(ICameraModule.class);
        this.rcmodule = (IRemoteControlModule)manager.getModuleInstance(IRemoteControlModule.class);
        this.cameraModule.suscribe(this);
    }

    public void shutdown() throws InternalErrorException {
    }

    public String getModuleInfo() {
        return null;
    }

    public String getModuleVersion() {
        return null;
    }

    @Override
    public void onNewFrame(Frame frame) {
    }

    @Override
    public void onNewMat(Mat mat) {
        int r = 0;
        int g = 0;
        int b = 0;
        long pixels = mat.rows() / 4 * mat.cols() / 4;
        long count = 0L;
        Mat hsvMat = new Mat(mat.rows(), mat.cols(), CvType.CV_8UC3);
        Imgproc.cvtColor((Mat)mat, (Mat)hsvMat, (int)41, (int)3);
        for (int row = 0; row < hsvMat.rows(); row += 4) {
            for (int col = 0; col < hsvMat.cols(); col += 4) {
                double[] pixel = hsvMat.get(row, col);
                int hue = (int)Math.round(pixel[0]);
                int saturation = (int)Math.round(pixel[1]);
                int value = (int)Math.round(pixel[2]);
                if (value <= 120 || saturation <= 160) continue;
                ++count;
                if ((hue -= 8) < 0) {
                    hue = 171 + Math.abs(hue);
                }
                if (hue > 166 && hue <= 179) {
                    ++r;
                }
                if (hue > 0 && hue <= 29) {
                    --count;
                }
                if (hue > 30 && hue <= 89) {
                    ++g;
                }
                if (hue > 90 && hue <= 141) {
                    ++b;
                }
                if (hue <= 142 || hue > 165) continue;
                ++r;
            }
        }
        int sum = r + g + b;
        if (sum != 0 && count > 3L) {
            r = Math.round((float)r / (float)sum * 100.0f);
            g = Math.round((float)g / (float)sum * 100.0f);
            b = Math.round((float)b / (float)sum * 100.0f);
            this.notifyColorMesaured(r, g, b);
        } else {
            this.notifyColorMesaured(0, 0, 0);
        }
        mat.release();
        hsvMat.release();
    }
}

