/*
 * Decompiled with CFR 0.152.
 */
package com.mytechia.robobo.framework.hri.vision.faceDetection;

import android.graphics.PointF;
import android.util.Log;
import com.mytechia.robobo.framework.hri.vision.faceDetection.IFaceDetectionModule;
import com.mytechia.robobo.framework.hri.vision.faceDetection.IFaceListener;
import com.mytechia.robobo.framework.remote_control.remotemodule.IRemoteControlModule;
import com.mytechia.robobo.framework.remote_control.remotemodule.Status;
import java.util.HashSet;

public abstract class AFaceDetectionModule
implements IFaceDetectionModule {
    private HashSet<IFaceListener> listeners = new HashSet();
    protected IRemoteControlModule rcmodule = null;

    protected void notifyFace(PointF coords, float eyesDistance) {
        for (IFaceListener listener : this.listeners) {
            listener.onFaceDetected(coords, eyesDistance);
        }
        if (this.rcmodule != null) {
            Status status = new Status("NEWFACE");
            status.putContents("coordx", Math.round(coords.x) + "");
            status.putContents("coordy", Math.round(coords.y) + "");
            status.putContents("distance", Math.round(eyesDistance) + "");
            this.rcmodule.postStatus(status);
        }
    }

    protected void notifyFaceAppear(PointF coords, float eyesDistance) {
        for (IFaceListener listener : this.listeners) {
            listener.onFaceAppear(coords, eyesDistance);
        }
        if (this.rcmodule != null) {
            Status status = new Status("FOUNDFACE");
            status.putContents("coordx", Math.round(coords.x) + "");
            status.putContents("coordy", Math.round(coords.y) + "");
            status.putContents("distance", Math.round(eyesDistance) + "");
            this.rcmodule.postStatus(status);
        }
    }

    protected void notifyFaceDisappear() {
        for (IFaceListener listener : this.listeners) {
            listener.onFaceDissapear();
        }
        if (this.rcmodule != null) {
            Status status = new Status("LOSTFACE");
            this.rcmodule.postStatus(status);
        }
    }

    @Override
    public void suscribe(IFaceListener listener) {
        Log.d((String)"FD_module", (String)("Suscribed:" + listener.toString()));
        this.listeners.add(listener);
    }

    @Override
    public void unsuscribe(IFaceListener listener) {
        this.listeners.remove(listener);
    }
}

