/*
 * Decompiled with CFR 0.152.
 */
package com.mytechia.robobo.framework.hri.vision.faceDetection.android;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.media.FaceDetector;
import com.mytechia.commons.framework.exception.InternalErrorException;
import com.mytechia.robobo.framework.RoboboManager;
import com.mytechia.robobo.framework.exception.ModuleNotFoundException;
import com.mytechia.robobo.framework.hri.vision.basicCamera.Frame;
import com.mytechia.robobo.framework.hri.vision.basicCamera.ICameraListener;
import com.mytechia.robobo.framework.hri.vision.basicCamera.ICameraModule;
import com.mytechia.robobo.framework.hri.vision.faceDetection.AFaceDetectionModule;
import com.mytechia.robobo.framework.remote_control.remotemodule.IRemoteControlModule;
import org.opencv.core.Mat;

public class AndroidFaceDetectionModule
extends AFaceDetectionModule
implements ICameraListener {
    private String TAG = "FaceDetectionModule";
    private int LOST_THRESHOLD = 5;
    private FaceDetector faceDetector;
    private FaceDetector.Face[] faces;
    float myEyesDistance;
    int numberOfFaceDetected;
    private boolean processing = false;
    private ICameraModule cameraModule;
    private int noDetectionCount = 0;
    private boolean lostFace = true;

    public void startup(RoboboManager manager) {
        try {
            this.cameraModule = (ICameraModule)manager.getModuleInstance(ICameraModule.class);
            this.rcmodule = (IRemoteControlModule)manager.getModuleInstance(IRemoteControlModule.class);
        }
        catch (ModuleNotFoundException e) {
            e.printStackTrace();
        }
        this.cameraModule.suscribe(this);
        this.faces = new FaceDetector.Face[5];
    }

    public void shutdown() throws InternalErrorException {
    }

    public String getModuleInfo() {
        return "Android Face Detection Module";
    }

    public String getModuleVersion() {
        return "v2.3";
    }

    private Bitmap convert(Bitmap bitmap, Bitmap.Config config) {
        Bitmap convertedBitmap = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)config);
        Canvas canvas = new Canvas(convertedBitmap);
        Paint paint = new Paint();
        paint.setColor(-16777216);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        return convertedBitmap;
    }

    @Override
    public void onNewFrame(Frame frame) {
        if (!this.processing) {
            this.processing = true;
            Bitmap convertedBitmap = this.convert(frame.getBitmap(), Bitmap.Config.RGB_565);
            this.faceDetector = new FaceDetector(convertedBitmap.getWidth(), convertedBitmap.getHeight(), 1);
            int facenumber = this.faceDetector.findFaces(convertedBitmap, this.faces);
            if (facenumber > 0) {
                PointF facecoord = new PointF();
                float eyesDistance = 0.0f;
                this.faces[0].getMidPoint(facecoord);
                facecoord.x = facecoord.x / (float)convertedBitmap.getWidth() * 100.0f;
                facecoord.y = facecoord.y / (float)convertedBitmap.getHeight() * 100.0f;
                eyesDistance = this.faces[0].eyesDistance();
                if (this.lostFace) {
                    this.lostFace = false;
                    this.notifyFaceAppear(facecoord, eyesDistance);
                }
                this.notifyFace(facecoord, eyesDistance);
                this.noDetectionCount = 0;
            } else {
                ++this.noDetectionCount;
                if (this.noDetectionCount > this.LOST_THRESHOLD && !this.lostFace) {
                    this.notifyFaceDisappear();
                    this.lostFace = true;
                }
            }
            this.processing = false;
        }
    }

    @Override
    public void onNewMat(Mat mat) {
    }
}

