/*
 * Decompiled with CFR 0.152.
 */
package com.mytechia.robobo.framework.hri.vision.faceDetection.googlevision;

import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.FaceDetector;
import com.mytechia.commons.framework.exception.InternalErrorException;
import com.mytechia.robobo.framework.RoboboManager;
import com.mytechia.robobo.framework.hri.vision.basicCamera.Frame;
import com.mytechia.robobo.framework.hri.vision.basicCamera.ICameraListener;
import com.mytechia.robobo.framework.hri.vision.basicCamera.ICameraModule;
import com.mytechia.robobo.framework.hri.vision.faceDetection.AFaceDetectionModule;
import org.opencv.core.Mat;

public class GoogleVisionFaceDetector
extends AFaceDetectionModule
implements ICameraListener {
    private FaceDetector detector;
    private ICameraModule cameraModule;
    private boolean processing = false;
    private String TAG = "GoogleFaceModule";

    public void startup(RoboboManager manager) throws InternalErrorException {
        this.cameraModule = (ICameraModule)manager.getModuleInstance(ICameraModule.class);
        this.cameraModule.suscribe(this);
        this.detector = new FaceDetector.Builder(manager.getApplicationContext()).setTrackingEnabled(false).setLandmarkType(1).setProminentFaceOnly(true).setClassificationType(0).setMode(0).build();
    }

    public void shutdown() throws InternalErrorException {
        if (this.detector != null) {
            this.detector.release();
        }
    }

    public String getModuleInfo() {
        return "GoogleFaceDetector";
    }

    public String getModuleVersion() {
        return "0.1";
    }

    @Override
    public void onNewFrame(Frame frame) {
        if (!this.processing) {
            this.processing = true;
            com.google.android.gms.vision.Frame f = new Frame.Builder().setBitmap(frame.getBitmap()).build();
            SparseArray faces = this.detector.detect(f);
            if (faces.size() > 0) {
                Face face = (Face)faces.get(0);
                Log.d((String)this.TAG, (String)face.toString());
                this.notifyFace(face.getPosition(), face.getWidth());
            }
            this.processing = false;
        }
    }

    @Override
    public void onNewMat(Mat mat) {
    }
}

