/*
 * Decompiled with CFR 0.152.
 */
package com.n1analytics.paillier;

import com.n1analytics.paillier.EncryptedNumber;
import com.n1analytics.paillier.PaillierContext;
import com.n1analytics.paillier.PaillierContextMismatchException;
import com.n1analytics.paillier.util.HashChain;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class EncodedNumber {
    protected final PaillierContext context;
    protected final BigInteger value;
    protected final int exponent;

    protected EncodedNumber(PaillierContext paillierContext, BigInteger bigInteger, int n) {
        if (paillierContext == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (bigInteger == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        if (bigInteger.signum() < 0) {
            throw new IllegalArgumentException("value must be non-negative");
        }
        if (bigInteger.compareTo(paillierContext.getPublicKey().getModulus()) >= 0) {
            throw new IllegalArgumentException("value must be less than modulus");
        }
        this.context = paillierContext;
        this.value = bigInteger;
        this.exponent = n;
    }

    public PaillierContext getContext() {
        return this.context;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public int getExponent() {
        return this.exponent;
    }

    public boolean isValid() {
        return this.context.isValid(this);
    }

    public int signum() {
        return this.context.signum(this);
    }

    public EncryptedNumber checkSameContext(EncryptedNumber encryptedNumber) throws PaillierContextMismatchException {
        return this.context.checkSameContext(encryptedNumber);
    }

    public EncodedNumber checkSameContext(EncodedNumber encodedNumber) throws PaillierContextMismatchException {
        return this.context.checkSameContext(encodedNumber);
    }

    public BigInteger decodeBigInteger() throws ArithmeticException {
        return this.context.decodeBigInteger(this);
    }

    public double decodeDouble() throws ArithmeticException {
        return this.context.decodeDouble(this);
    }

    public long decodeLong() throws ArithmeticException {
        return this.context.decodeLong(this);
    }

    public BigDecimal decodeBigDecimal() throws ArithmeticException {
        return this.context.decodeBigDecimal(this);
    }

    public EncodedNumber decreaseExponentTo(int n) {
        return this.context.decreaseExponentTo(this, n);
    }

    public EncryptedNumber encrypt() {
        return this.context.encrypt(this);
    }

    public EncryptedNumber add(EncryptedNumber encryptedNumber) {
        return this.context.add(this, encryptedNumber);
    }

    public EncodedNumber add(EncodedNumber encodedNumber) {
        return this.context.add(this, encodedNumber);
    }

    public EncodedNumber add(BigInteger bigInteger) {
        return this.add(this.context.encode(bigInteger));
    }

    public EncodedNumber add(double d) {
        return this.add(this.context.encode(d));
    }

    public EncodedNumber add(long l) {
        return this.add(this.context.encode(l));
    }

    public EncodedNumber additiveInverse() {
        return this.context.additiveInverse(this);
    }

    public EncryptedNumber subtract(EncryptedNumber encryptedNumber) {
        return this.context.subtract(this, encryptedNumber);
    }

    public EncodedNumber subtract(EncodedNumber encodedNumber) {
        return this.context.subtract(this, encodedNumber);
    }

    public EncodedNumber subtract(BigInteger bigInteger) {
        return this.subtract(this.context.encode(bigInteger));
    }

    public EncodedNumber subtract(double d) {
        return this.subtract(this.context.encode(d));
    }

    public EncodedNumber subtract(long l) {
        return this.subtract(this.context.encode(l));
    }

    public EncryptedNumber multiply(EncryptedNumber encryptedNumber) {
        return this.context.multiply(this, encryptedNumber);
    }

    public EncodedNumber multiply(EncodedNumber encodedNumber) {
        return this.context.multiply(this, encodedNumber);
    }

    public EncodedNumber multiply(BigInteger bigInteger) {
        return this.multiply(this.context.encode(bigInteger));
    }

    public EncodedNumber multiply(double d) {
        return this.multiply(this.context.encode(d));
    }

    public EncodedNumber multiply(long l) {
        return this.multiply(this.context.encode(l));
    }

    public EncodedNumber divide(double d) {
        return this.multiply(this.context.encode(1.0 / d));
    }

    public EncodedNumber divide(long l) {
        return this.multiply(this.context.encode(1.0 / (double)l));
    }

    public int hashCode() {
        return new HashChain().chain(this.context).chain(this.value).hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != EncodedNumber.class) {
            return false;
        }
        EncodedNumber encodedNumber = (EncodedNumber)object;
        return this.context.equals(encodedNumber.context) && this.value.equals(encodedNumber.value);
    }

    public boolean equals(EncodedNumber encodedNumber) {
        return encodedNumber == this || encodedNumber != null && this.context.equals(encodedNumber.context) && this.value.equals(encodedNumber.value);
    }
}

