/*
 * Decompiled with CFR 0.152.
 */
package com.n1analytics.paillier;

import com.n1analytics.paillier.DecodeException;
import com.n1analytics.paillier.EncodeException;
import com.n1analytics.paillier.EncodedNumber;
import com.n1analytics.paillier.EncodingScheme;
import com.n1analytics.paillier.EncryptedNumber;
import com.n1analytics.paillier.PaillierContextMismatchException;
import com.n1analytics.paillier.PaillierPublicKey;
import com.n1analytics.paillier.StandardEncodingScheme;
import com.n1analytics.paillier.util.BigIntegerUtil;
import com.n1analytics.paillier.util.HashChain;
import java.math.BigDecimal;
import java.math.BigInteger;

public class PaillierContext {
    protected static final int DEFAULT_BASE = 16;
    private final PaillierPublicKey publicKey;
    private final EncodingScheme encoding;

    public PaillierContext(PaillierPublicKey paillierPublicKey, boolean bl, int n) {
        this(paillierPublicKey, bl, n, 16);
    }

    public PaillierContext(PaillierPublicKey paillierPublicKey, boolean bl, int n, int n2) {
        if (paillierPublicKey == null) {
            throw new NullPointerException("publicKey must not be null");
        }
        this.publicKey = paillierPublicKey;
        this.encoding = new StandardEncodingScheme(this, bl, n, n2);
    }

    public PaillierContext(PaillierPublicKey paillierPublicKey, EncodingScheme encodingScheme) {
        if (paillierPublicKey == null) {
            throw new NullPointerException("publicKey must not be null");
        }
        this.publicKey = paillierPublicKey;
        this.encoding = encodingScheme;
    }

    public PaillierPublicKey getPublicKey() {
        return this.publicKey;
    }

    public EncodingScheme getEncodingScheme() {
        return this.encoding;
    }

    public int getBase() {
        return this.encoding.getBase();
    }

    public boolean isSigned() {
        return this.encoding.isSigned();
    }

    public boolean isUnsigned() {
        return !this.isSigned();
    }

    public int getPrecision() {
        return this.encoding.getPrecision();
    }

    public boolean isFullPrecision() {
        return this.getPrecision() == this.publicKey.getModulus().bitLength();
    }

    public BigInteger getMaxEncoded() {
        return this.encoding.getMaxEncoded();
    }

    public BigInteger getMinEncoded() {
        return this.encoding.getMinEncoded();
    }

    public BigInteger getMaxSignificand() {
        return this.encoding.getMaxSignificand();
    }

    public BigInteger getMinSignificand() {
        return this.encoding.getMinSignificand();
    }

    public void checkSameContext(PaillierContext paillierContext) throws PaillierContextMismatchException {
        if (this == paillierContext) {
            return;
        }
        if (!this.publicKey.equals(paillierContext.publicKey)) {
            throw new PaillierContextMismatchException("These PaillierContexts have diffenent public keys");
        }
        if (!this.encoding.equals(paillierContext.encoding)) {
            throw new PaillierContextMismatchException("These PaillierContexts have diffenent encoding schemes");
        }
    }

    public EncryptedNumber checkSameContext(EncryptedNumber encryptedNumber) throws PaillierContextMismatchException {
        this.checkSameContext(encryptedNumber.getContext());
        return encryptedNumber;
    }

    public EncodedNumber checkSameContext(EncodedNumber encodedNumber) throws PaillierContextMismatchException {
        this.checkSameContext(encodedNumber.getContext());
        return encodedNumber;
    }

    public boolean isValid(EncodedNumber encodedNumber) {
        return this.encoding.isValid(encodedNumber);
    }

    public EncodedNumber encode(BigInteger bigInteger) throws EncodeException {
        return this.encoding.encode(bigInteger);
    }

    public EncodedNumber encode(double d) throws EncodeException {
        return this.encoding.encode(d);
    }

    public EncodedNumber encode(double d, int n) throws EncodeException {
        return this.encoding.encode(d, n);
    }

    public EncodedNumber encode(double d, double d2) throws EncodeException {
        return this.encoding.encode(d, d2);
    }

    public EncodedNumber encode(long l) throws EncodeException {
        return this.encode(BigInteger.valueOf(l));
    }

    public EncodedNumber encode(BigDecimal bigDecimal) throws EncodeException {
        return this.encoding.encode(bigDecimal);
    }

    public int signum(EncodedNumber encodedNumber) {
        return this.encoding.signum(encodedNumber);
    }

    public BigInteger getRescalingFactor(int n) {
        return this.encoding.getRescalingFactor(n);
    }

    public EncodedNumber decreaseExponentTo(EncodedNumber encodedNumber, int n) {
        BigInteger bigInteger = encodedNumber.getValue();
        int n2 = encodedNumber.getExponent();
        if (n > n2) {
            throw new IllegalArgumentException("New exponent: " + n + "should be more negative than old exponent: " + n2 + ".");
        }
        int n3 = n2 - n;
        BigInteger bigInteger2 = this.getRescalingFactor(n3);
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger2).mod(this.publicKey.getModulus());
        return new EncodedNumber(this, bigInteger3, n);
    }

    public EncryptedNumber decreaseExponentTo(EncryptedNumber encryptedNumber, int n) {
        int n2 = encryptedNumber.getExponent();
        if (n > n2) {
            throw new IllegalArgumentException("New exponent: " + n + "should be more negative than old exponent: " + n2 + ".");
        }
        int n3 = n2 - n;
        BigInteger bigInteger = this.getRescalingFactor(n3);
        BigInteger bigInteger2 = this.publicKey.raw_multiply(encryptedNumber.ciphertext, bigInteger);
        return new EncryptedNumber(this, bigInteger2, n, encryptedNumber.isSafe);
    }

    public BigInteger decodeBigInteger(EncodedNumber encodedNumber) throws DecodeException {
        return this.encoding.decodeBigInteger(encodedNumber);
    }

    public double decodeDouble(EncodedNumber encodedNumber) throws DecodeException {
        return this.encoding.decodeDouble(encodedNumber);
    }

    public long decodeLong(EncodedNumber encodedNumber) throws DecodeException {
        return this.encoding.decodeLong(encodedNumber);
    }

    public BigDecimal decodeBigDecimal(EncodedNumber encodedNumber) throws DecodeException {
        return this.encoding.decodeBigDecimal(encodedNumber);
    }

    public EncryptedNumber obfuscate(EncryptedNumber encryptedNumber) {
        this.checkSameContext(encryptedNumber);
        BigInteger bigInteger = this.publicKey.raw_obfuscate(encryptedNumber.ciphertext);
        return new EncryptedNumber(this, bigInteger, encryptedNumber.getExponent(), true);
    }

    public EncryptedNumber encrypt(EncodedNumber encodedNumber) {
        this.checkSameContext(encodedNumber);
        BigInteger bigInteger = encodedNumber.getValue();
        BigInteger bigInteger2 = this.publicKey.raw_encrypt_without_obfuscation(bigInteger);
        return new EncryptedNumber(this, bigInteger2, encodedNumber.getExponent(), false);
    }

    public EncryptedNumber encrypt(BigInteger bigInteger) {
        return this.encrypt(this.encode(bigInteger));
    }

    public EncryptedNumber encrypt(double d) {
        return this.encrypt(this.encode(d));
    }

    public EncryptedNumber encrypt(long l) {
        return this.encrypt(this.encode(l));
    }

    public EncryptedNumber add(EncryptedNumber encryptedNumber, EncryptedNumber encryptedNumber2) throws PaillierContextMismatchException {
        this.checkSameContext(encryptedNumber);
        this.checkSameContext(encryptedNumber2);
        BigInteger bigInteger = encryptedNumber.ciphertext;
        BigInteger bigInteger2 = encryptedNumber2.ciphertext;
        int n = encryptedNumber.getExponent();
        int n2 = encryptedNumber2.getExponent();
        if (n > n2) {
            bigInteger = this.publicKey.raw_multiply(bigInteger, this.getRescalingFactor(n - n2));
            n = n2;
        } else if (n < n2) {
            bigInteger2 = this.publicKey.raw_multiply(bigInteger2, this.getRescalingFactor(n2 - n));
        }
        BigInteger bigInteger3 = this.publicKey.raw_add(bigInteger, bigInteger2);
        return new EncryptedNumber(this, bigInteger3, n, encryptedNumber.isSafe && encryptedNumber2.isSafe);
    }

    public EncryptedNumber add(EncryptedNumber encryptedNumber, EncodedNumber encodedNumber) throws PaillierContextMismatchException {
        boolean bl;
        this.checkSameContext(encryptedNumber);
        this.checkSameContext(encodedNumber);
        int n = encryptedNumber.getExponent();
        int n2 = encodedNumber.getExponent();
        BigInteger bigInteger = encodedNumber.value;
        if (n < n2) {
            bigInteger = bigInteger.multiply(this.getRescalingFactor(n2 - n)).mod(this.publicKey.getModulus());
            return this.add(encryptedNumber, this.encrypt(new EncodedNumber(this, bigInteger, n)));
        }
        if (n > n2 && encodedNumber.signum() == 1 && (bl = bigInteger.mod(this.getRescalingFactor(n - n2)).equals(BigInteger.ZERO))) {
            bigInteger = bigInteger.divide(this.getRescalingFactor(n - n2));
            return this.add(encryptedNumber, this.encrypt(new EncodedNumber(this, bigInteger, n)));
        }
        return this.add(encryptedNumber, this.encrypt(encodedNumber));
    }

    public EncryptedNumber add(EncodedNumber encodedNumber, EncryptedNumber encryptedNumber) throws PaillierContextMismatchException {
        return this.add(encryptedNumber, encodedNumber);
    }

    public EncodedNumber add(EncodedNumber encodedNumber, EncodedNumber encodedNumber2) throws PaillierContextMismatchException {
        this.checkSameContext(encodedNumber);
        this.checkSameContext(encodedNumber2);
        BigInteger bigInteger = this.publicKey.getModulus();
        BigInteger bigInteger2 = encodedNumber.getValue();
        BigInteger bigInteger3 = encodedNumber2.getValue();
        int n = encodedNumber.getExponent();
        int n2 = encodedNumber2.getExponent();
        if (n > n2) {
            bigInteger2 = bigInteger2.multiply(this.getRescalingFactor(n - n2));
            n = n2;
        } else if (n < n2) {
            bigInteger3 = bigInteger3.multiply(this.getRescalingFactor(n2 - n));
        }
        BigInteger bigInteger4 = bigInteger2.add(bigInteger3).mod(bigInteger);
        return new EncodedNumber(this, bigInteger4, n);
    }

    public EncryptedNumber additiveInverse(EncryptedNumber encryptedNumber) throws PaillierContextMismatchException {
        this.checkSameContext(encryptedNumber);
        return new EncryptedNumber(encryptedNumber.getContext(), BigIntegerUtil.modInverse(encryptedNumber.ciphertext, encryptedNumber.getContext().getPublicKey().getModulusSquared()), encryptedNumber.getExponent(), encryptedNumber.isSafe);
    }

    public EncodedNumber additiveInverse(EncodedNumber encodedNumber) throws PaillierContextMismatchException {
        this.checkSameContext(encodedNumber);
        if (encodedNumber.getValue().signum() == 0) {
            return encodedNumber;
        }
        BigInteger bigInteger = this.publicKey.getModulus();
        BigInteger bigInteger2 = encodedNumber.getValue();
        BigInteger bigInteger3 = bigInteger.subtract(bigInteger2);
        return new EncodedNumber(this, bigInteger3, encodedNumber.getExponent());
    }

    public EncryptedNumber subtract(EncryptedNumber encryptedNumber, EncryptedNumber encryptedNumber2) throws PaillierContextMismatchException {
        this.checkSameContext(encryptedNumber);
        this.checkSameContext(encryptedNumber2);
        return this.add(encryptedNumber, this.additiveInverse(encryptedNumber2));
    }

    public EncryptedNumber subtract(EncryptedNumber encryptedNumber, EncodedNumber encodedNumber) throws PaillierContextMismatchException {
        return this.add(encryptedNumber, this.encrypt(encodedNumber.additiveInverse()));
    }

    public EncryptedNumber subtract(EncodedNumber encodedNumber, EncryptedNumber encryptedNumber) throws PaillierContextMismatchException {
        return this.subtract(this.encrypt(encodedNumber), encryptedNumber);
    }

    public EncodedNumber subtract(EncodedNumber encodedNumber, EncodedNumber encodedNumber2) throws PaillierContextMismatchException {
        return this.add(encodedNumber, encodedNumber2.additiveInverse());
    }

    public EncryptedNumber multiply(EncryptedNumber encryptedNumber, EncodedNumber encodedNumber) throws PaillierContextMismatchException {
        this.checkSameContext(encryptedNumber);
        this.checkSameContext(encodedNumber);
        BigInteger bigInteger = encryptedNumber.ciphertext;
        BigInteger bigInteger2 = encodedNumber.getValue();
        BigInteger bigInteger3 = this.publicKey.getModulus().subtract(bigInteger2);
        if (bigInteger3.compareTo(this.encoding.getMaxEncoded()) <= 0) {
            bigInteger = BigIntegerUtil.modInverse(bigInteger, this.publicKey.getModulusSquared());
            bigInteger2 = bigInteger3;
        }
        BigInteger bigInteger4 = this.publicKey.raw_multiply(bigInteger, bigInteger2);
        int n = encryptedNumber.getExponent() + encodedNumber.getExponent();
        return new EncryptedNumber(this, bigInteger4, n, encryptedNumber.isSafe);
    }

    public EncryptedNumber multiply(EncodedNumber encodedNumber, EncryptedNumber encryptedNumber) throws PaillierContextMismatchException {
        return this.multiply(encryptedNumber, encodedNumber);
    }

    public EncodedNumber multiply(EncodedNumber encodedNumber, EncodedNumber encodedNumber2) throws PaillierContextMismatchException {
        this.checkSameContext(encodedNumber);
        this.checkSameContext(encodedNumber2);
        BigInteger bigInteger = this.publicKey.getModulus();
        BigInteger bigInteger2 = encodedNumber.getValue();
        BigInteger bigInteger3 = encodedNumber2.getValue();
        BigInteger bigInteger4 = bigInteger2.multiply(bigInteger3).mod(bigInteger);
        int n = encodedNumber.getExponent() + encodedNumber2.getExponent();
        return new EncodedNumber(this, bigInteger4, n);
    }

    public EncodedNumber randomEncodedNumber(int n) {
        return new EncodedNumber(this, BigIntegerUtil.randomPositiveNumber(this.publicKey.getModulus()), n);
    }

    public int hashCode() {
        return new HashChain().chain(this.publicKey).chain(this.encoding).hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != PaillierContext.class) {
            return false;
        }
        PaillierContext paillierContext = (PaillierContext)object;
        return this.publicKey.equals(paillierContext.publicKey) && this.encoding.equals(paillierContext.encoding);
    }

    public boolean equals(PaillierContext paillierContext) {
        return paillierContext == this || paillierContext != null && this.publicKey.equals(paillierContext.publicKey) && this.encoding.equals(paillierContext.encoding);
    }
}

