/*
 * Decompiled with CFR 0.152.
 */
package com.n1analytics.paillier.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.n1analytics.paillier.EncodedNumber;
import com.n1analytics.paillier.EncryptedNumber;
import com.n1analytics.paillier.PaillierContext;
import com.n1analytics.paillier.PaillierPrivateKey;
import com.n1analytics.paillier.PaillierPublicKey;
import com.n1analytics.paillier.cli.OptionParsing;
import com.n1analytics.paillier.cli.PrivateKeyJsonSerialiser;
import com.n1analytics.paillier.cli.SerialisationUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class JavallierCLI {
    String footer = "\nPlease report issues to https://github.com/NICTA/javallier/issues";
    private static final Logger log = Logger.getLogger(JavallierCLI.class.getName());
    private String[] args = null;
    private Options options = new Options();

    public JavallierCLI(String[] stringArray) {
        this.args = stringArray;
        this.options.addOption("h", "help", false, "Show this message and exit.");
        this.options.addOption("v", "verbose", false, "Enable logging");
    }

    public void parse() {
        Object object;
        HashMap<String, Command> hashMap = new HashMap<String, Command>();
        hashMap.put("genpkey", new GenerateKeyPairCommand("genpkey"));
        hashMap.put("extract", new ExtractCommand("extract"));
        hashMap.put("encrypt", new EncryptCommand("encrypt"));
        hashMap.put("decrypt", new DecryptCommand("decrypt"));
        hashMap.put("add", new AddCommand("add"));
        hashMap.put("addenc", new AddEncCommand("addenc"));
        hashMap.put("multiply", new MultiplyCommand("multiply"));
        Command command = null;
        List<String> list = Arrays.asList(this.args);
        if (list.size() > 0 && hashMap.containsKey(object = list.get(0))) {
            command = (Command)hashMap.get(object);
        }
        object = new DefaultParser();
        try {
            if (command != null) {
                this.options = command.addOptions(this.options);
            }
            CommandLine commandLine = object.parse(this.options, this.args);
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.ALL);
            log.addHandler(consoleHandler);
            if (commandLine.hasOption("v")) {
                log.setLevel(Level.INFO);
            } else {
                log.setLevel(Level.WARNING);
            }
            log.setUseParentHandlers(false);
            if (commandLine.hasOption("help") || command == null) {
                if (command == null) {
                    this.help(hashMap.values());
                } else {
                    this.help(command);
                }
                System.exit(0);
            }
            command.processOptions(commandLine);
            List list2 = commandLine.getArgList();
            try {
                command.run(list2);
            }
            catch (Exception exception) {
                log.warning("Failed to run command. Reason: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        catch (ParseException parseException) {
            System.err.println("Parsing failed.  Reason: " + parseException.getMessage());
            this.help(hashMap.values());
        }
    }

    public void usage(Command command) {
        HelpFormatter helpFormatter = new HelpFormatter();
        String string = "javallier " + command.getName() + " [OPTIONS] " + command.getOptionDescription();
        String string2 = "Javallier CLI - Data61 - 2016\n" + command.getDescription() + "\n\nOptions:\n";
        helpFormatter.printHelp(string, string2, this.options, this.footer);
    }

    public void help(Command command) {
        this.usage(command);
        System.exit(0);
    }

    private void help(Collection<Command> collection) {
        HelpFormatter helpFormatter = new HelpFormatter();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Javallier CLI - Data61 - 2016\n");
        stringBuilder.append("Commands:\n");
        for (Command command : collection) {
            stringBuilder.append("    " + command.getName() + ": " + command.getBlurb() + "\n");
        }
        stringBuilder.append("Try javallier COMMAND --help for command usage.\n");
        stringBuilder.append("\nOptions:\n\n");
        helpFormatter.printHelp("javallier COMMAND [OPTIONS]", stringBuilder.toString(), this.options, this.footer);
        System.exit(0);
    }

    protected static class AddEncCommand
    extends Command {
        Writer output;

        public AddEncCommand(String string) {
            super(string);
        }

        @Override
        public Options addOptions(Options options) {
            options.addOption("o", "output", true, "Output to given file instead of stdout");
            return options;
        }

        @Override
        public void processOptions(CommandLine commandLine) {
            this.output = OptionParsing.processOutputOption(commandLine);
        }

        @Override
        public void run(List<String> list) {
            System.out.println("Running the addenc command");
            System.out.println(list);
            String string = list.get(1);
            String string2 = list.get(2);
            String string3 = list.get(3);
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                Map map = (Map)objectMapper.readValue(new File(string2), Map.class);
                Map map2 = (Map)objectMapper.readValue(new File(string3), Map.class);
                Map map3 = (Map)objectMapper.readValue(new File(string), Map.class);
                PaillierPublicKey paillierPublicKey = SerialisationUtil.unserialise_public(map3);
                log.info("Deserialized public key");
                EncryptedNumber encryptedNumber = SerialisationUtil.unserialise_encrypted(map, paillierPublicKey);
                EncryptedNumber encryptedNumber2 = SerialisationUtil.unserialise_encrypted(map2, paillierPublicKey);
                log.info("Deserialized encrypted numbers");
                EncryptedNumber encryptedNumber3 = encryptedNumber.add(encryptedNumber2);
                ObjectNode objectNode = SerialisationUtil.serialise_encrypted(encryptedNumber3);
                this.output.write(objectNode.toString());
                this.output.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        @Override
        public String getOptionDescription() {
            return "PUBLICKEY ENCRYPTED1 ENCRYPTED2";
        }

        @Override
        public String getBlurb() {
            return "Add ENCRYPTED1 to ENCRYPTED2";
        }

        @Override
        public String getDescription() {
            return "Add two encrypted numbers together \nproducing a new encrypted number.";
        }
    }

    protected static class MultiplyCommand
    extends Command {
        Writer output;

        public MultiplyCommand(String string) {
            super(string);
        }

        @Override
        public Options addOptions(Options options) {
            options.addOption("o", "output", true, "Output to given file instead of stdout");
            return options;
        }

        @Override
        public void processOptions(CommandLine commandLine) {
            this.output = OptionParsing.processOutputOption(commandLine);
        }

        @Override
        public void run(List<String> list) {
            System.out.println("Running the multiply command");
            System.out.println(list);
            String string = list.get(1);
            String string2 = list.get(2);
            Double d = Double.parseDouble(list.get(3));
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                Map map = (Map)objectMapper.readValue(new File(string2), Map.class);
                Map map2 = (Map)objectMapper.readValue(new File(string), Map.class);
                PaillierPublicKey paillierPublicKey = SerialisationUtil.unserialise_public(map2);
                log.info("Deserialized public key");
                EncryptedNumber encryptedNumber = SerialisationUtil.unserialise_encrypted(map, paillierPublicKey);
                log.info("Deserialized ciphertext number...");
                EncryptedNumber encryptedNumber2 = encryptedNumber.multiply(d);
                ObjectNode objectNode = SerialisationUtil.serialise_encrypted(encryptedNumber2);
                this.output.write(objectNode.toString());
                this.output.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        @Override
        public String getOptionDescription() {
            return "PUBLICKEY ENCRYPTED PLAINTEXT";
        }

        @Override
        public String getBlurb() {
            return "Multiply ENCRYPTED with PLAINTEXT";
        }

        @Override
        public String getDescription() {
            return "Multiply ENCRYPTED and PLAINTEXT numbers together \nproducing a new encrypted number.";
        }
    }

    protected static class AddCommand
    extends Command {
        Writer output;

        public AddCommand(String string) {
            super(string);
        }

        @Override
        public Options addOptions(Options options) {
            options.addOption("o", "output", true, "Output to given file instead of stdout");
            return options;
        }

        @Override
        public void processOptions(CommandLine commandLine) {
            this.output = OptionParsing.processOutputOption(commandLine);
        }

        @Override
        public void run(List<String> list) {
            System.out.println("Running the add command");
            System.out.println(list);
            String string = list.get(1);
            String string2 = list.get(2);
            Double d = Double.parseDouble(list.get(3));
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                Map map = (Map)objectMapper.readValue(new File(string2), Map.class);
                Map map2 = (Map)objectMapper.readValue(new File(string), Map.class);
                PaillierPublicKey paillierPublicKey = SerialisationUtil.unserialise_public(map2);
                log.info("Deserialized public key");
                EncryptedNumber encryptedNumber = SerialisationUtil.unserialise_encrypted(map, paillierPublicKey);
                log.info("Deserialized ciphertext number...");
                EncryptedNumber encryptedNumber2 = encryptedNumber.add(d);
                ObjectNode objectNode = SerialisationUtil.serialise_encrypted(encryptedNumber2);
                this.output.write(objectNode.toString());
                this.output.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        @Override
        public String getOptionDescription() {
            return "PUBLICKEY ENCRYPTED PLAINTEXT";
        }

        @Override
        public String getBlurb() {
            return "Add ENCRYPTED to PLAINTEXT";
        }

        @Override
        public String getDescription() {
            return "Add ENCRYPTED and PLAINTEXT numbers together \nproducing a new encrypted number.";
        }
    }

    protected static class ExtractCommand
    extends Command {
        public ExtractCommand(String string) {
            super(string);
        }

        @Override
        public void run(List<String> list) {
            log.info("Running the extract command");
            log.info("Args: " + list);
            String string = list.get(1);
            String string2 = list.get(2);
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                Writer writer = string2.equals("-") ? new BufferedWriter(new OutputStreamWriter(System.out)) : new PrintWriter(string2);
                Map map = (Map)objectMapper.readValue(new File(string), Map.class);
                objectMapper.writeValue(writer, map.get("pub"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Private Key not found or not readable");
                System.exit(1);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        @Override
        public String getOptionDescription() {
            return "PRIVATEKEY OUTPUT";
        }

        @Override
        public String getBlurb() {
            return "Extract the public key from a PRIVATE key";
        }

        @Override
        public String getDescription() {
            return "Extract the public key from a private key";
        }
    }

    protected static class DecryptCommand
    extends Command {
        Writer output;

        public DecryptCommand(String string) {
            super(string);
        }

        @Override
        public Options addOptions(Options options) {
            options.addOption("o", "output", true, "Output to given file instead of stdout");
            return options;
        }

        @Override
        public void processOptions(CommandLine commandLine) {
            this.output = OptionParsing.processOutputOption(commandLine);
        }

        @Override
        public void run(List<String> list) {
            System.out.println("Running the decrypt command");
            System.out.println(list);
            String string = list.get(1);
            String string2 = list.get(2);
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                Map map = (Map)objectMapper.readValue(new File(string2), Map.class);
                Map map2 = (Map)objectMapper.readValue(new File(string), Map.class);
                PaillierPrivateKey paillierPrivateKey = SerialisationUtil.unserialise_private(map2);
                log.info("Deserialized private key");
                EncryptedNumber encryptedNumber = SerialisationUtil.unserialise_encrypted(map, paillierPrivateKey.getPublicKey());
                log.info("Deserialized number...");
                EncodedNumber encodedNumber = paillierPrivateKey.decrypt(encryptedNumber);
                log.info("Decoding...");
                this.output.write("" + encodedNumber.decodeDouble() + "\n");
                this.output.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        @Override
        public String getOptionDescription() {
            return "PRIVATEKEY CIPHERTEXT";
        }

        @Override
        public String getBlurb() {
            return "Decrypt CIPHERTEXT with PRIVATEKEY";
        }

        @Override
        public String getDescription() {
            return "Decrypted value could be an integer or float.";
        }
    }

    protected static class EncryptCommand
    extends Command {
        Writer output;

        public EncryptCommand(String string) {
            super(string);
        }

        @Override
        public Options addOptions(Options options) {
            options.addOption("o", "output", true, "Output to given file instead of stdout");
            return options;
        }

        @Override
        public void processOptions(CommandLine commandLine) {
            this.output = OptionParsing.processOutputOption(commandLine);
        }

        @Override
        public void run(List<String> list) {
            log.info("Running the encrypt command");
            log.info("Args: " + list);
            String string = list.get(1);
            String string2 = list.get(2);
            log.info("Encrypting " + string2);
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                Map map = (Map)objectMapper.readValue(new File(string), Map.class);
                PaillierPublicKey paillierPublicKey = SerialisationUtil.unserialise_public(map);
                PaillierContext paillierContext = paillierPublicKey.createSignedContext();
                EncryptedNumber encryptedNumber = paillierContext.encrypt(Double.parseDouble(string2));
                log.info("Encrypted");
                ObjectNode objectNode = SerialisationUtil.serialise_encrypted(encryptedNumber);
                this.output.write(objectNode.toString());
                this.output.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Public key file not found");
                System.exit(1);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        @Override
        public String getOptionDescription() {
            return "PUBLICKEY PLAINTEXT";
        }

        @Override
        public String getBlurb() {
            return "Encrypt a value with the given public key";
        }

        @Override
        public String getDescription() {
            return "Encrypt a value with the given public key\n\nThe PLAINTEXT will be interpreted as a floating point number.\n\nOutput will be a JSON object with a \"v\" attribute containing the\nciphertext as a string, and \"e\" the exponent as an integer.\n\nNote if you are passing a negative number to encrypt, you will\nneed to include a \"--\" between the public key and your plaintext.";
        }
    }

    protected static class GenerateKeyPairCommand
    extends Command {
        int DEFAULT_KEYSIZE = 2048;
        int keysize;
        String comment;

        public GenerateKeyPairCommand(String string) {
            super(string);
        }

        @Override
        public void run(List<String> list) {
            PaillierPrivateKey paillierPrivateKey = PaillierPrivateKey.create(this.keysize);
            log.info("Keypair generated");
            PrivateKeyJsonSerialiser privateKeyJsonSerialiser = new PrivateKeyJsonSerialiser(this.comment);
            paillierPrivateKey.serialize(privateKeyJsonSerialiser);
            if (list.size() < 2) {
                log.info("Output to stdout?");
                System.out.println(privateKeyJsonSerialiser);
            } else {
                String string = list.get(1);
                log.info("Using destination of " + string);
                try (PrintWriter printWriter = new PrintWriter(string);){
                    printWriter.println(privateKeyJsonSerialiser);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    log.info("Couldn't find that location sorry.");
                }
            }
        }

        @Override
        public Options addOptions(Options options) {
            options.addOption("s", "keysize", true, "The keysize in bits. Default to 1024");
            options.addOption("m", "message", true, "Add an identifying comment to the key");
            return options;
        }

        @Override
        public void processOptions(CommandLine commandLine) {
            if (commandLine.hasOption("keysize")) {
                this.keysize = Integer.parseInt(commandLine.getOptionValue("keysize"));
                log.info("Using provided key size of " + this.keysize);
            } else {
                this.keysize = this.DEFAULT_KEYSIZE;
                log.info("Using default key size of " + this.keysize);
            }
            this.comment = commandLine.hasOption("message") ? commandLine.getOptionValue("message") : "Paillier keypair generated by javallier";
            log.info("Comment: " + this.comment);
        }

        @Override
        public String getOptionDescription() {
            return "[--keysize=KEYSIZE] OUTPUT";
        }

        @Override
        public String getBlurb() {
            return "Create a new paillier keypair";
        }

        @Override
        public String getDescription() {
            return "Generate a new public/private keypair for use in\npaillier operations.\nOutput in JSON Web Key format\nhttps://tools.ietf.org/html/rfc7517";
        }
    }

    protected static abstract class Command {
        private String name;

        public Command(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public abstract void run(List<String> var1) throws InvalidArgsException, IOException;

        public Options addOptions(Options options) {
            return options;
        }

        public void processOptions(CommandLine commandLine) {
            log.info("Ignoring command specific options");
        }

        public abstract String getOptionDescription();

        public abstract String getBlurb();

        public abstract String getDescription();
    }

    protected static class InvalidArgsException
    extends Exception {
        private List<String> args;

        public InvalidArgsException(List<String> list) {
            this.args = list;
        }

        public List<String> getArgs() {
            return this.args;
        }
    }
}

