/*
 * Decompiled with CFR 0.152.
 */
package com.n1analytics.paillier.util;

import com.squareup.jnagmp.Gmp;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BigIntegerUtil {
    private static Logger logger = Logger.getLogger("com.n1analytics.paillier");
    public static final BigInteger LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigInteger LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    public static final SecureRandom random = new SecureRandom();
    public static final boolean USE_GMP = BigIntegerUtil.canLoadGmp();

    private static boolean canLoadGmp() {
        try {
            Gmp.checkLoaded();
            return true;
        }
        catch (Error error) {
            logger.log(Level.WARNING, "can't load Gmp library. Falling back to native Java for modPow. Unfortunately, that's a 'lot' slower.", error);
            return false;
        }
    }

    public static BigInteger modPowSecure(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        if (USE_GMP) {
            return bigInteger2.signum() < 0 ? BigIntegerUtil.modInverse(Gmp.modPowSecure((BigInteger)bigInteger, (BigInteger)bigInteger2.negate(), (BigInteger)bigInteger3), bigInteger3) : Gmp.modPowSecure((BigInteger)bigInteger, (BigInteger)bigInteger2, (BigInteger)bigInteger3);
        }
        logger.log(Level.WARNING, "Gmp library is not available. Falling back to native Java for modPow. This does not provide protection against timing attacks!");
        return bigInteger.modPow(bigInteger2, bigInteger3);
    }

    public static BigInteger modPow(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        if (USE_GMP) {
            return bigInteger2.signum() < 0 ? BigIntegerUtil.modInverse(Gmp.modPowInsecure((BigInteger)bigInteger, (BigInteger)bigInteger2.negate(), (BigInteger)bigInteger3), bigInteger3) : Gmp.modPowInsecure((BigInteger)bigInteger, (BigInteger)bigInteger2, (BigInteger)bigInteger3);
        }
        return bigInteger.modPow(bigInteger2, bigInteger3);
    }

    public static BigInteger modInverse(BigInteger bigInteger, BigInteger bigInteger2) throws ArithmeticException {
        if (USE_GMP) {
            return Gmp.modInverse((BigInteger)bigInteger, (BigInteger)bigInteger2);
        }
        return bigInteger.modInverse(bigInteger2);
    }

    public static boolean positive(BigInteger bigInteger) {
        return bigInteger.signum() > 0;
    }

    public static boolean nonNegative(BigInteger bigInteger) {
        return bigInteger.signum() >= 0;
    }

    public static boolean negative(BigInteger bigInteger) {
        return bigInteger.signum() < 0;
    }

    public static boolean nonPositive(BigInteger bigInteger) {
        return bigInteger.signum() <= 0;
    }

    public static boolean greater(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.compareTo(bigInteger2) > 0;
    }

    public static boolean greaterOrEqual(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.compareTo(bigInteger2) >= 0;
    }

    public static boolean less(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.compareTo(bigInteger2) < 0;
    }

    public static boolean lessOrEqual(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.compareTo(bigInteger2) <= 0;
    }

    public static BigInteger randomPositiveNumber(BigInteger bigInteger) {
        BigInteger bigInteger2;
        if (BigIntegerUtil.lessOrEqual(bigInteger, BigInteger.ONE)) {
            throw new IllegalArgumentException("n must be strictly greater than one");
        }
        int n = bigInteger.bitLength();
        while (BigIntegerUtil.less(bigInteger2 = new BigInteger(n, random), BigInteger.ONE) || BigIntegerUtil.greaterOrEqual(bigInteger2, bigInteger)) {
        }
        return bigInteger2;
    }

    public static BigInteger sqrt(BigInteger bigInteger) {
        BigInteger bigInteger2 = BigInteger.ONE;
        BigInteger bigInteger3 = bigInteger.shiftRight(5).add(BigInteger.valueOf(8L));
        while (bigInteger3.compareTo(bigInteger2) >= 0) {
            BigInteger bigInteger4 = bigInteger2.add(bigInteger3).shiftRight(1);
            if (bigInteger4.multiply(bigInteger4).compareTo(bigInteger) > 0) {
                bigInteger3 = bigInteger4.subtract(BigInteger.ONE);
                continue;
            }
            bigInteger2 = bigInteger4.add(BigInteger.ONE);
        }
        return bigInteger2.subtract(BigInteger.ONE);
    }
}

