/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common;

import com.metamx.common.IAE;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Interval;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.Weeks;
import org.joda.time.Years;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public enum Granularity {
    SECOND{
        DateTimeFormatter defaultFormat = DateTimeFormat.forPattern((String)"'y'=yyyy/'m'=MM/'d'=dd/'H'=HH/'M'=mm/'S'=ss");
        DateTimeFormatter hiveFormat = DateTimeFormat.forPattern((String)"'dt'=yyyy-MM-dd-HH-mm-ss");
        DateTimeFormatter lowerDefaultFormat = DateTimeFormat.forPattern((String)"'y'=yyyy/'m'=MM/'d'=dd/'h'=HH/'m'=mm/'s'=ss");

        @Override
        public DateTimeFormatter getFormatter(Formatter type) {
            switch (type) {
                case DEFAULT: {
                    return this.defaultFormat;
                }
                case HIVE: {
                    return this.hiveFormat;
                }
                case LOWER_DEFAULT: {
                    return this.lowerDefaultFormat;
                }
            }
            throw new IAE("There is no format for type %s at granularity %s", new Object[]{type, this.name()});
        }

        @Override
        public ReadablePeriod getUnits(int count) {
            return Seconds.seconds((int)count);
        }

        @Override
        public DateTime truncate(DateTime time) {
            MutableDateTime mutableDateTime = time.toMutableDateTime();
            mutableDateTime.setMillisOfSecond(0);
            return mutableDateTime.toDateTime();
        }

        @Override
        public int numIn(ReadableInterval interval) {
            return Seconds.secondsIn((ReadableInterval)interval).getSeconds();
        }

        @Override
        public DateTime toDate(String filePath, Formatter formatter) {
            Integer[] vals = this.getDateValues(filePath, formatter);
            DateTime date = null;
            if (vals[1] != null && vals[2] != null && vals[3] != null && vals[4] != null && vals[5] != null && vals[6] != null) {
                date = new DateTime(vals[1].intValue(), vals[2].intValue(), vals[3].intValue(), vals[4].intValue(), vals[5].intValue(), vals[6].intValue(), 0);
            }
            return date;
        }
    }
    ,
    MINUTE{
        DateTimeFormatter defaultFormat = DateTimeFormat.forPattern((String)"'y'=yyyy/'m'=MM/'d'=dd/'H'=HH/'M'=mm");
        DateTimeFormatter hiveFormat = DateTimeFormat.forPattern((String)"'dt'=yyyy-MM-dd-HH-mm");
        DateTimeFormatter lowerDefaultFormat = DateTimeFormat.forPattern((String)"'y'=yyyy/'m'=MM/'d'=dd/'h'=HH/'m'=mm");

        @Override
        public DateTimeFormatter getFormatter(Formatter type) {
            switch (type) {
                case DEFAULT: {
                    return this.defaultFormat;
                }
                case HIVE: {
                    return this.hiveFormat;
                }
                case LOWER_DEFAULT: {
                    return this.lowerDefaultFormat;
                }
            }
            throw new IAE("There is no format for type %s at granularity %s", new Object[]{type, this.name()});
        }

        @Override
        public ReadablePeriod getUnits(int count) {
            return Minutes.minutes((int)count);
        }

        @Override
        public DateTime truncate(DateTime time) {
            MutableDateTime mutableDateTime = time.toMutableDateTime();
            mutableDateTime.setMillisOfSecond(0);
            mutableDateTime.setSecondOfMinute(0);
            return mutableDateTime.toDateTime();
        }

        @Override
        public int numIn(ReadableInterval interval) {
            return Minutes.minutesIn((ReadableInterval)interval).getMinutes();
        }

        @Override
        public DateTime toDate(String filePath, Formatter formatter) {
            Integer[] vals = this.getDateValues(filePath, formatter);
            DateTime date = null;
            if (vals[1] != null && vals[2] != null && vals[3] != null && vals[4] != null && vals[5] != null) {
                date = new DateTime(vals[1].intValue(), vals[2].intValue(), vals[3].intValue(), vals[4].intValue(), vals[5].intValue(), 0, 0);
            }
            return date;
        }
    }
    ,
    FIFTEEN_MINUTE{

        @Override
        public DateTimeFormatter getFormatter(Formatter type) {
            return MINUTE.getFormatter(type);
        }

        @Override
        public ReadablePeriod getUnits(int count) {
            return Minutes.minutes((int)(count * 15));
        }

        @Override
        public DateTime truncate(DateTime time) {
            MutableDateTime mutableDateTime = time.toMutableDateTime();
            mutableDateTime.setMillisOfSecond(0);
            mutableDateTime.setSecondOfMinute(0);
            mutableDateTime.setMinuteOfHour(mutableDateTime.getMinuteOfHour() - mutableDateTime.getMinuteOfHour() % 15);
            return mutableDateTime.toDateTime();
        }

        @Override
        public int numIn(ReadableInterval interval) {
            return Minutes.minutesIn((ReadableInterval)interval).getMinutes() / 15;
        }

        @Override
        public DateTime toDate(String filePath, Formatter formatter) {
            Integer[] vals = this.getDateValues(filePath, formatter);
            if (vals[1] != null && vals[2] != null && vals[3] != null && vals[4] != null && vals[5] != null) {
                return this.truncate(new DateTime(vals[1].intValue(), vals[2].intValue(), vals[3].intValue(), vals[4].intValue(), vals[5].intValue(), 0, 0));
            }
            return null;
        }
    }
    ,
    HOUR{
        DateTimeFormatter defaultFormat = DateTimeFormat.forPattern((String)"'y'=yyyy/'m'=MM/'d'=dd/'H'=HH");
        DateTimeFormatter hiveFormat = DateTimeFormat.forPattern((String)"'dt'=yyyy-MM-dd-HH");
        DateTimeFormatter lowerDefaultFormat = DateTimeFormat.forPattern((String)"'y'=yyyy/'m'=MM/'d'=dd/'h'=HH");

        @Override
        public DateTimeFormatter getFormatter(Formatter type) {
            switch (type) {
                case DEFAULT: {
                    return this.defaultFormat;
                }
                case HIVE: {
                    return this.hiveFormat;
                }
                case LOWER_DEFAULT: {
                    return this.lowerDefaultFormat;
                }
            }
            throw new IAE("There is no format for type %s at granularity %s", new Object[]{type, this.name()});
        }

        @Override
        public ReadablePeriod getUnits(int n) {
            return Hours.hours((int)n);
        }

        @Override
        public DateTime truncate(DateTime time) {
            MutableDateTime mutableDateTime = time.toMutableDateTime();
            mutableDateTime.setMillisOfSecond(0);
            mutableDateTime.setSecondOfMinute(0);
            mutableDateTime.setMinuteOfHour(0);
            return mutableDateTime.toDateTime();
        }

        @Override
        public int numIn(ReadableInterval interval) {
            return Hours.hoursIn((ReadableInterval)interval).getHours();
        }

        @Override
        public DateTime toDate(String filePath, Formatter formatter) {
            Integer[] vals = this.getDateValues(filePath, formatter);
            DateTime date = null;
            if (vals[1] != null && vals[2] != null && vals[3] != null && vals[4] != null) {
                date = new DateTime(vals[1].intValue(), vals[2].intValue(), vals[3].intValue(), vals[4].intValue(), 0, 0, 0);
            }
            return date;
        }
    }
    ,
    SIX_HOUR{

        @Override
        public DateTimeFormatter getFormatter(Formatter type) {
            return HOUR.getFormatter(type);
        }

        @Override
        public ReadablePeriod getUnits(int n) {
            return Hours.hours((int)(n * 6));
        }

        @Override
        public DateTime truncate(DateTime time) {
            MutableDateTime mutableDateTime = time.toMutableDateTime();
            mutableDateTime.setMillisOfSecond(0);
            mutableDateTime.setSecondOfMinute(0);
            mutableDateTime.setMinuteOfHour(0);
            mutableDateTime.setHourOfDay(mutableDateTime.getHourOfDay() - mutableDateTime.getHourOfDay() % 6);
            return mutableDateTime.toDateTime();
        }

        @Override
        public int numIn(ReadableInterval interval) {
            return Hours.hoursIn((ReadableInterval)interval).getHours() / 6;
        }

        @Override
        public DateTime toDate(String filePath, Formatter formatter) {
            Integer[] vals = this.getDateValues(filePath, formatter);
            if (vals[1] != null && vals[2] != null && vals[3] != null && vals[4] != null) {
                return this.truncate(new DateTime(vals[1].intValue(), vals[2].intValue(), vals[3].intValue(), vals[4].intValue(), 0, 0, 0));
            }
            return null;
        }
    }
    ,
    DAY{
        DateTimeFormatter defaultFormat = DateTimeFormat.forPattern((String)"'y'=yyyy/'m'=MM/'d'=dd");
        DateTimeFormatter hiveFormat = DateTimeFormat.forPattern((String)"'dt'=yyyy-MM-dd");
        DateTimeFormatter lowerDefaultFormat = DateTimeFormat.forPattern((String)"'y'=yyyy/'m'=MM/'d'=dd");

        @Override
        public DateTimeFormatter getFormatter(Formatter type) {
            switch (type) {
                case DEFAULT: {
                    return this.defaultFormat;
                }
                case HIVE: {
                    return this.hiveFormat;
                }
                case LOWER_DEFAULT: {
                    return this.lowerDefaultFormat;
                }
            }
            throw new IAE("There is no format for type %s at granularity %s", new Object[]{type, this.name()});
        }

        @Override
        public ReadablePeriod getUnits(int n) {
            return Days.days((int)n);
        }

        @Override
        public DateTime truncate(DateTime time) {
            MutableDateTime mutableDateTime = time.toMutableDateTime();
            mutableDateTime.setMillisOfDay(0);
            return mutableDateTime.toDateTime();
        }

        @Override
        public int numIn(ReadableInterval interval) {
            return Days.daysIn((ReadableInterval)interval).getDays();
        }

        @Override
        public DateTime toDate(String filePath, Formatter formatter) {
            Integer[] vals = this.getDateValues(filePath, formatter);
            DateTime date = null;
            if (vals[1] != null && vals[2] != null && vals[3] != null) {
                date = new DateTime(vals[1].intValue(), vals[2].intValue(), vals[3].intValue(), 0, 0, 0, 0);
            }
            return date;
        }
    }
    ,
    WEEK{
        DateTimeFormatter defaultFormat = DateTimeFormat.forPattern((String)"'y'=yyyy/'m'=MM/'d'=dd");
        DateTimeFormatter hiveFormat = DateTimeFormat.forPattern((String)"'dt'=yyyy-MM-dd");
        DateTimeFormatter lowerDefaultFormat = DateTimeFormat.forPattern((String)"'y'=yyyy/'m'=MM/'d'=dd");

        @Override
        public DateTimeFormatter getFormatter(Formatter type) {
            return DAY.getFormatter(type);
        }

        @Override
        public ReadablePeriod getUnits(int n) {
            return Weeks.weeks((int)n);
        }

        @Override
        public DateTime truncate(DateTime time) {
            MutableDateTime mutableDateTime = time.toMutableDateTime();
            mutableDateTime.setMillisOfDay(0);
            mutableDateTime.setDayOfWeek(1);
            return mutableDateTime.toDateTime();
        }

        @Override
        public int numIn(ReadableInterval interval) {
            return Weeks.weeksIn((ReadableInterval)interval).getWeeks();
        }

        @Override
        public DateTime toDate(String filePath, Formatter formatter) {
            Integer[] vals = this.getDateValues(filePath, formatter);
            DateTime date = null;
            if (vals[1] != null && vals[2] != null && vals[3] != null) {
                date = this.truncate(new DateTime(vals[1].intValue(), vals[2].intValue(), vals[3].intValue(), 0, 0, 0, 0));
            }
            return date;
        }
    }
    ,
    MONTH{
        DateTimeFormatter defaultFormat = DateTimeFormat.forPattern((String)"'y'=yyyy/'m'=MM");
        DateTimeFormatter hiveFormat = DateTimeFormat.forPattern((String)"'dt'=yyyy-MM");
        DateTimeFormatter lowerDefaultFormat = DateTimeFormat.forPattern((String)"'y'=yyyy/'m'=MM");

        @Override
        public DateTimeFormatter getFormatter(Formatter type) {
            switch (type) {
                case DEFAULT: {
                    return this.defaultFormat;
                }
                case HIVE: {
                    return this.hiveFormat;
                }
                case LOWER_DEFAULT: {
                    return this.lowerDefaultFormat;
                }
            }
            throw new IAE("There is no format for type %s at granularity %s", new Object[]{type, this.name()});
        }

        @Override
        public ReadablePeriod getUnits(int n) {
            return Months.months((int)n);
        }

        @Override
        public DateTime truncate(DateTime time) {
            MutableDateTime mutableDateTime = time.toMutableDateTime();
            mutableDateTime.setMillisOfDay(0);
            mutableDateTime.setDayOfMonth(1);
            return mutableDateTime.toDateTime();
        }

        @Override
        public int numIn(ReadableInterval interval) {
            return Months.monthsIn((ReadableInterval)interval).getMonths();
        }

        @Override
        public DateTime toDate(String filePath, Formatter formatter) {
            Integer[] vals = this.getDateValues(filePath, formatter);
            DateTime date = null;
            if (vals[1] != null && vals[2] != null) {
                date = new DateTime(vals[1].intValue(), vals[2].intValue(), 1, 0, 0, 0, 0);
            }
            return date;
        }
    }
    ,
    YEAR{
        DateTimeFormatter defaultFormat = DateTimeFormat.forPattern((String)"'y'=yyyy");
        DateTimeFormatter hiveFormat = DateTimeFormat.forPattern((String)"'dt'=yyyy");
        DateTimeFormatter lowerDefaultFormat = DateTimeFormat.forPattern((String)"'y'=yyyy");

        @Override
        public DateTimeFormatter getFormatter(Formatter type) {
            switch (type) {
                case DEFAULT: {
                    return this.defaultFormat;
                }
                case HIVE: {
                    return this.hiveFormat;
                }
                case LOWER_DEFAULT: {
                    return this.lowerDefaultFormat;
                }
            }
            throw new IAE("There is no format for type %s at granularity %s", new Object[]{type, this.name()});
        }

        @Override
        public ReadablePeriod getUnits(int n) {
            return Years.years((int)n);
        }

        @Override
        public DateTime truncate(DateTime time) {
            MutableDateTime mutableDateTime = time.toMutableDateTime();
            mutableDateTime.setMillisOfDay(0);
            mutableDateTime.setDayOfMonth(1);
            mutableDateTime.setMonthOfYear(1);
            return mutableDateTime.toDateTime();
        }

        @Override
        public int numIn(ReadableInterval interval) {
            return Years.yearsIn((ReadableInterval)interval).getYears();
        }

        @Override
        public DateTime toDate(String filePath, Formatter formatter) {
            Integer[] vals = this.getDateValues(filePath, formatter);
            DateTime date = null;
            if (vals[1] != null) {
                date = new DateTime(vals[1].intValue(), 1, 1, 0, 0, 0, 0);
            }
            return date;
        }
    };

    protected final Pattern defaultPathPattern = Pattern.compile("^.*[Yy]=(\\d{4})/(?:[Mm]=(\\d{2})/(?:[Dd]=(\\d{2})/(?:[Hh]=(\\d{2})/(?:[Mm]=(\\d{2})/(?:[Ss]=(\\d{2})/)?)?)?)?)?.*$");
    protected final Pattern hivePathPattern = Pattern.compile("^.*dt=(\\d{4})(?:-(\\d{2})(?:-(\\d{2})(?:-(\\d{2})(?:-(\\d{2})(?:-(\\d{2})?)?)?)?)?)?/.*$");

    public abstract DateTimeFormatter getFormatter(Formatter var1);

    public abstract ReadablePeriod getUnits(int var1);

    public abstract DateTime truncate(DateTime var1);

    public abstract int numIn(ReadableInterval var1);

    public abstract DateTime toDate(String var1, Formatter var2);

    public DateTime toDate(String filePath) {
        return this.toDate(filePath, Formatter.DEFAULT);
    }

    protected final Integer[] getDateValues(String filePath, Formatter formatter) {
        Pattern pattern = this.defaultPathPattern;
        switch (formatter) {
            case DEFAULT: 
            case LOWER_DEFAULT: {
                break;
            }
            case HIVE: {
                pattern = this.hivePathPattern;
                break;
            }
            default: {
                throw new IAE("Format %s not supported", new Object[]{formatter});
            }
        }
        Matcher matcher = pattern.matcher(filePath);
        Integer[] vals = new Integer[7];
        if (matcher.matches()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                vals[i] = matcher.group(i) != null ? Integer.valueOf(Integer.parseInt(matcher.group(i))) : null;
            }
        }
        return vals;
    }

    public final DateTimeFormatter getFormatter(String type) {
        return this.getFormatter(Formatter.valueOf(type.toUpperCase()));
    }

    public final DateTime increment(DateTime time) {
        return time.plus(this.getUnits(1));
    }

    public final DateTime increment(DateTime time, int count) {
        return time.plus(this.getUnits(count));
    }

    public final DateTime decrement(DateTime time) {
        return time.minus(this.getUnits(1));
    }

    public final DateTime decrement(DateTime time, int count) {
        return time.minus(this.getUnits(count));
    }

    public final String toPath(DateTime time) {
        return this.toPath(time, "default");
    }

    public final String toPath(DateTime time, String type) {
        return this.toPath(time, Formatter.valueOf(type.toUpperCase()));
    }

    public final String toPath(DateTime time, Formatter type) {
        return this.getFormatter(type).print((ReadableInstant)time);
    }

    public final Interval bucket(DateTime t) {
        DateTime start = this.truncate(t);
        return new Interval((ReadableInstant)start, (ReadableInstant)this.increment(start));
    }

    public final Interval widen(Interval interval) {
        DateTime start = this.truncate(interval.getStart());
        DateTime end = interval.getEnd().equals((Object)start) ? this.increment(start) : (this.truncate(interval.getEnd()).equals((Object)interval.getEnd()) ? interval.getEnd() : this.increment(this.truncate(interval.getEnd())));
        return new Interval((ReadableInstant)start, (ReadableInstant)end);
    }

    public Iterable<Interval> getIterable(DateTime start, DateTime end) {
        return this.getIterable(new Interval((ReadableInstant)start, (ReadableInstant)end));
    }

    public Iterable<Interval> getIterable(Interval input) {
        return new IntervalIterable(input);
    }

    public Iterable<Interval> getReverseIterable(DateTime start, DateTime end) {
        return this.getReverseIterable(new Interval((ReadableInstant)start, (ReadableInstant)end));
    }

    public Iterable<Interval> getReverseIterable(Interval input) {
        return new ReverseIntervalIterable(input);
    }

    public static enum Formatter {
        DEFAULT,
        HIVE,
        LOWER_DEFAULT;

    }

    public class ReverseIntervalIterator
    implements Iterator<Interval> {
        private final Interval inputInterval;
        private DateTime currStart;
        private DateTime currEnd;

        public ReverseIntervalIterator(Interval inputInterval) {
            this.inputInterval = inputInterval;
            this.currEnd = inputInterval.getEnd();
            this.currStart = Granularity.this.decrement(this.currEnd);
        }

        @Override
        public boolean hasNext() {
            return this.currEnd.isAfter((ReadableInstant)this.inputInterval.getStart());
        }

        @Override
        public Interval next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("There are no more intervals");
            }
            Interval retVal = new Interval((ReadableInstant)this.currStart, (ReadableInstant)this.currEnd);
            this.currEnd = this.currStart;
            this.currStart = Granularity.this.decrement(this.currEnd);
            return retVal;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class IntervalIterator
    implements Iterator<Interval> {
        private final Interval inputInterval;
        private DateTime currStart;
        private DateTime currEnd;

        public IntervalIterator(Interval inputInterval) {
            this.inputInterval = inputInterval;
            this.currStart = Granularity.this.truncate(inputInterval.getStart());
            this.currEnd = Granularity.this.increment(this.currStart);
        }

        @Override
        public boolean hasNext() {
            return this.currStart.isBefore((ReadableInstant)this.inputInterval.getEnd());
        }

        @Override
        public Interval next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("There are no more intervals");
            }
            Interval retVal = new Interval((ReadableInstant)this.currStart, (ReadableInstant)this.currEnd);
            this.currStart = this.currEnd;
            this.currEnd = Granularity.this.increment(this.currStart);
            return retVal;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class ReverseIntervalIterable
    implements Iterable<Interval> {
        private final Interval inputInterval;

        public ReverseIntervalIterable(Interval inputInterval) {
            this.inputInterval = inputInterval;
        }

        @Override
        public Iterator<Interval> iterator() {
            return new ReverseIntervalIterator(this.inputInterval);
        }
    }

    public class IntervalIterable
    implements Iterable<Interval> {
        private final Interval inputInterval;

        public IntervalIterable(Interval inputInterval) {
            this.inputInterval = inputInterval;
        }

        @Override
        public Iterator<Interval> iterator() {
            return new IntervalIterator(this.inputInterval);
        }
    }
}

