/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.guava;

import com.google.common.base.Preconditions;
import com.metamx.common.guava.DelegatingYieldingAccumulator;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Yielder;
import com.metamx.common.guava.Yielders;
import com.metamx.common.guava.YieldingAccumulator;
import com.metamx.common.guava.YieldingSequenceBase;
import java.io.IOException;

public class LimitedSequence<T>
extends YieldingSequenceBase<T> {
    private final Sequence<T> baseSequence;
    private final int limit;

    public LimitedSequence(Sequence<T> baseSequence, int limit) {
        Preconditions.checkNotNull(baseSequence);
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (Object)"limit is negative");
        this.baseSequence = baseSequence;
        this.limit = limit;
    }

    @Override
    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
        LimitedYieldingAccumulator<OutType, T> limitedAccumulator = new LimitedYieldingAccumulator<OutType, T>(accumulator);
        Yielder<OutType> subYielder = this.baseSequence.toYielder(initValue, limitedAccumulator);
        return new LimitedYielder<OutType>(subYielder, limitedAccumulator);
    }

    private class LimitedYieldingAccumulator<OutType, T>
    extends DelegatingYieldingAccumulator<OutType, T> {
        int count;

        public LimitedYieldingAccumulator(YieldingAccumulator<OutType, T> accumulator) {
            super(accumulator);
            this.count = 0;
        }

        @Override
        public OutType accumulate(OutType accumulated, T in) {
            ++this.count;
            if (!this.withinThreshold()) {
                this.yield();
            }
            return super.accumulate(accumulated, in);
        }

        private boolean withinThreshold() {
            return this.count < LimitedSequence.this.limit;
        }
    }

    private class LimitedYielder<OutType>
    implements Yielder<OutType> {
        private final Yielder<OutType> subYielder;
        private final LimitedYieldingAccumulator<OutType, T> limitedAccumulator;

        public LimitedYielder(Yielder<OutType> subYielder, LimitedYieldingAccumulator<OutType, T> limitedAccumulator) {
            this.subYielder = subYielder;
            this.limitedAccumulator = limitedAccumulator;
        }

        @Override
        public OutType get() {
            return this.subYielder.get();
        }

        @Override
        public Yielder<OutType> next(OutType initValue) {
            Yielder<OutType> next = this.subYielder.next(initValue);
            if (!this.limitedAccumulator.withinThreshold()) {
                return Yielders.done(next.get(), next);
            }
            return new LimitedYielder<OutType>(this, this.limitedAccumulator);
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public void close() throws IOException {
            this.subYielder.close();
        }
    }
}

