/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.guava;

import com.google.common.io.Closeables;
import com.metamx.common.guava.ResourceClosingYielder;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Yielder;
import com.metamx.common.guava.YieldingAccumulator;
import com.metamx.common.guava.YieldingSequenceBase;
import java.io.Closeable;

public class ResourceClosingSequence<T>
extends YieldingSequenceBase<T> {
    private final Sequence<T> baseSequence;
    private final Closeable closeable;

    public ResourceClosingSequence(Sequence<T> baseSequence, Closeable closeable) {
        this.baseSequence = baseSequence;
        this.closeable = closeable;
    }

    @Override
    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
        Yielder<OutType> baseYielder;
        try {
            baseYielder = this.baseSequence.toYielder(initValue, accumulator);
        }
        catch (RuntimeException e) {
            Closeables.closeQuietly((Closeable)this.closeable);
            throw e;
        }
        return new ResourceClosingYielder<OutType>(baseYielder, this.closeable);
    }
}

