/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.parsers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.metamx.common.exception.FormattedException;
import com.metamx.common.parsers.Parser;
import com.metamx.common.parsers.ParserUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JSONParser
implements Parser<String, Object> {
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private ArrayList<String> fieldNames = null;
    private static final Function<JsonNode, String> valueFunction = new Function<JsonNode, String>(){

        public String apply(JsonNode node) {
            return node == null || node.isMissingNode() || node.isNull() ? null : node.asText();
        }
    };

    public JSONParser() {
    }

    public JSONParser(Iterable<String> fieldNames) {
        this.setFieldNames(fieldNames);
    }

    @Override
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public void setFieldNames(Iterable<String> fieldNames) {
        ParserUtils.validateFields(fieldNames);
        this.fieldNames = Lists.newArrayList(fieldNames);
    }

    @Override
    public Map<String, Object> parse(String input) throws FormattedException {
        try {
            Iterator<String> keysIter;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            JsonNode root = this.jsonMapper.readTree(input);
            Iterator<String> iterator = keysIter = this.fieldNames == null ? root.fieldNames() : this.fieldNames.iterator();
            while (keysIter.hasNext()) {
                Object nodeValue;
                String key = keysIter.next();
                JsonNode node = root.path(key);
                if (node.isArray()) {
                    nodeValue = Lists.newArrayListWithExpectedSize((int)node.size());
                    for (JsonNode subnode : node) {
                        String subnodeValue = (String)valueFunction.apply((Object)subnode);
                        if (subnodeValue == null) continue;
                        nodeValue.add(subnodeValue);
                    }
                    map.put(key, nodeValue);
                    continue;
                }
                nodeValue = (String)valueFunction.apply((Object)node);
                if (nodeValue == null) continue;
                map.put(key, nodeValue);
            }
            return map;
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, FormattedException.class);
            throw new FormattedException.Builder().withErrorCode(FormattedException.ErrorCode.UNPARSABLE_ROW).withMessage(e.getMessage()).build();
        }
    }
}

