/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.parsers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.metamx.common.exception.FormattedException;
import com.metamx.common.parsers.ParserUtils;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TimestampParser {
    public static Function<String, DateTime> createTimestampParser(String format) {
        HashMap<String, DateTimeZone> timezones = new HashMap<String, DateTimeZone>();
        return TimestampParser.createTimestampParser(format, timezones);
    }

    public static Function<String, DateTime> createTimestampParser(String format, Map<String, DateTimeZone> timezones) {
        if (format.equalsIgnoreCase("auto")) {
            return new Function<String, DateTime>(){

                public DateTime apply(String input) {
                    Preconditions.checkArgument((input != null && !input.isEmpty() ? 1 : 0) != 0, (Object)"null timestamp");
                    for (int i = 0; i < input.length(); ++i) {
                        if (input.charAt(i) >= '0' && input.charAt(i) <= '9') continue;
                        return new DateTime((Object)ParserUtils.stripQuotes(input));
                    }
                    return new DateTime(Long.parseLong(input));
                }
            };
        }
        if (format.equalsIgnoreCase("iso")) {
            return new Function<String, DateTime>(){

                public DateTime apply(String input) {
                    Preconditions.checkArgument((input != null && !input.isEmpty() ? 1 : 0) != 0, (Object)"null timestamp");
                    return new DateTime((Object)ParserUtils.stripQuotes(input));
                }
            };
        }
        if (format.equalsIgnoreCase("posix")) {
            return new Function<String, DateTime>(){

                public DateTime apply(String input) {
                    Preconditions.checkArgument((input != null && !input.isEmpty() ? 1 : 0) != 0, (Object)"null timestamp");
                    return new DateTime(Long.parseLong(ParserUtils.stripQuotes(input)) * 1000L);
                }
            };
        }
        if (format.equalsIgnoreCase("ruby")) {
            return new Function<String, DateTime>(){

                public DateTime apply(String input) {
                    Preconditions.checkArgument((input != null && !input.isEmpty() ? 1 : 0) != 0, (Object)"null timestamp");
                    Double ts = Double.parseDouble(ParserUtils.stripQuotes(input));
                    Long jts = ts.longValue() * 1000L;
                    return new DateTime((Object)jts);
                }
            };
        }
        if (format.equalsIgnoreCase("millis")) {
            return new Function<String, DateTime>(){

                public DateTime apply(String input) {
                    Preconditions.checkArgument((input != null && !input.isEmpty() ? 1 : 0) != 0, (Object)"null timestamp");
                    return new DateTime(Long.parseLong(ParserUtils.stripQuotes(input)));
                }
            };
        }
        try {
            final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format);
            return new Function<String, DateTime>(){

                public DateTime apply(String input) {
                    Preconditions.checkArgument((input != null && !input.isEmpty() ? 1 : 0) != 0, (Object)"null timestamp");
                    return formatter.parseDateTime(ParserUtils.stripQuotes(input));
                }
            };
        }
        catch (FormattedException e) {
            Throwables.propagateIfInstanceOf((Throwable)e, FormattedException.class);
            throw new FormattedException.Builder().withErrorCode(FormattedException.ErrorCode.UNPARSABLE_TIMESTAMP).withMessage(String.format("Unknown timestamp format [%s]", format)).build();
        }
        catch (IllegalArgumentException e) {
            Throwables.propagateIfInstanceOf((Throwable)e, FormattedException.class);
            throw new FormattedException.Builder().withErrorCode(FormattedException.ErrorCode.UNPARSABLE_TIMESTAMP).withMessage(String.format("Unknown timestamp format [%s]", format)).build();
        }
    }
}

