/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.dao;

import nablarch.common.dao.DaoContext;
import nablarch.common.dao.StandardSqlBuilder;
import nablarch.common.idgenerator.IdGenerator;
import nablarch.core.db.connection.AppDbConnection;
import nablarch.core.util.annotation.Published;

@Published(tag={"architect"})
public abstract class DaoContextFactory {
    protected IdGenerator sequenceIdGenerator;
    protected IdGenerator tableIdGenerator;
    protected ThreadLocal<AppDbConnection> dbConnection = new ThreadLocal();
    protected StandardSqlBuilder sqlBuilder = new StandardSqlBuilder();

    public abstract DaoContext create();

    public void setSequenceIdGenerator(IdGenerator sequenceIdGenerator) {
        this.sequenceIdGenerator = sequenceIdGenerator;
    }

    public void setTableIdGenerator(IdGenerator tableIdGenerator) {
        this.tableIdGenerator = tableIdGenerator;
    }

    public void setSqlBuilder(StandardSqlBuilder sqlBuilder) {
        this.sqlBuilder = sqlBuilder;
    }

    public void setDbConnection(AppDbConnection aConn) {
        if (aConn == null) {
            this.dbConnection.remove();
        } else {
            this.dbConnection.set(aConn);
        }
    }

    public AppDbConnection getDbConnection() {
        return this.dbConnection.get();
    }
}

