/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.dao;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import nablarch.common.dao.DatabaseUtil;
import nablarch.core.util.annotation.Published;

@Published(tag={"architect"})
public class DatabaseMetaDataExtractor {
    public Map<String, Short> getPrimaryKeys(String tableName) {
        try {
            DatabaseMetaData metaData = DatabaseUtil.getMetaData();
            return DatabaseMetaDataExtractor.toPrimaryKeyMap(metaData.getPrimaryKeys(null, null, DatabaseUtil.doConvertIdentifiers(metaData, tableName)));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, Short> toPrimaryKeyMap(ResultSet resultSet) throws SQLException {
        try {
            HashMap<String, Short> result = new HashMap<String, Short>();
            while (resultSet.next()) {
                result.put(resultSet.getString("COLUMN_NAME").toUpperCase(), resultSet.getShort("KEY_SEQ"));
            }
            HashMap<String, Short> hashMap = result;
            return hashMap;
        }
        finally {
            resultSet.close();
        }
    }
}

