/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.dao;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import nablarch.common.dao.DatabaseMetaDataExtractor;
import nablarch.core.db.connection.AppDbConnection;
import nablarch.core.db.connection.DbConnectionContext;
import nablarch.core.db.connection.TransactionManagerConnection;
import nablarch.core.repository.SystemRepository;

public final class DatabaseUtil {
    private static final DatabaseMetaDataExtractor DEFAULT_METADATA_EXTRACTOR = new DatabaseMetaDataExtractor();

    private DatabaseUtil() {
    }

    public static Map<String, Short> getPrimaryKey(String tableName) {
        return DatabaseUtil.getDatabaseMetaDataExtractor().getPrimaryKeys(tableName);
    }

    public static String convertIdentifiers(String identifiers) {
        try {
            return DatabaseUtil.doConvertIdentifiers(DatabaseUtil.getMetaData(), identifiers);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String convertIdentifiers(DatabaseMetaData metaData, String identifiers) {
        try {
            return DatabaseUtil.doConvertIdentifiers(metaData, identifiers);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String doConvertIdentifiers(DatabaseMetaData metaData, String identifiers) throws SQLException {
        if (metaData.storesMixedCaseIdentifiers()) {
            return identifiers;
        }
        if (metaData.storesUpperCaseIdentifiers()) {
            return identifiers.toUpperCase();
        }
        if (metaData.storesLowerCaseIdentifiers()) {
            return identifiers.toLowerCase();
        }
        return identifiers;
    }

    public static DatabaseMetaData getMetaData() throws SQLException {
        AppDbConnection connection = DbConnectionContext.getConnection();
        if (!(connection instanceof TransactionManagerConnection)) {
            throw new IllegalStateException("failed to get DatabaseMetaData.");
        }
        return ((TransactionManagerConnection)connection).getConnection().getMetaData();
    }

    private static DatabaseMetaDataExtractor getDatabaseMetaDataExtractor() {
        DatabaseMetaDataExtractor databaseMetaDataExtractor = (DatabaseMetaDataExtractor)SystemRepository.get((String)"databaseMetaDataExtractor");
        return databaseMetaDataExtractor == null ? DEFAULT_METADATA_EXTRACTOR : databaseMetaDataExtractor;
    }
}

