/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.dao;

import java.io.Closeable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import nablarch.common.dao.EntityList;
import nablarch.common.dao.EntityUtil;
import nablarch.common.dao.SqlResourceHolder;
import nablarch.core.db.statement.SqlRow;
import nablarch.core.util.annotation.Published;

@Published(tag={"architect"})
public class DeferredEntityList<E>
extends EntityList<E>
implements Closeable {
    private static final long serialVersionUID = 1L;
    private final transient SqlResourceHolder resourceHolder;
    private final Class<E> entityClass;

    public DeferredEntityList(Class<E> entityClass, SqlResourceHolder resourceHolder) {
        this.entityClass = entityClass;
        this.resourceHolder = resourceHolder;
    }

    @Override
    @Published
    public Iterator<E> iterator() {
        final Iterator iter = this.resourceHolder.getResultSetIterator().iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public E next() {
                SqlRow row = (SqlRow)iter.next();
                if (DeferredEntityList.this.entityClass.equals(SqlRow.class)) {
                    SqlRow e = row;
                    return e;
                }
                return EntityUtil.createEntity(DeferredEntityList.this.entityClass, row);
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    @Override
    public void close() {
        this.dispose();
    }

    private void dispose() {
        this.resourceHolder.dispose();
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException("listIterator");
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException("listIterator");
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException("add");
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException("addAll");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear");
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException("contains");
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        throw new UnsupportedOperationException("ensureCapacity");
    }

    @Override
    public E get(int index) {
        throw new UnsupportedOperationException("get");
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException("indexOf");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("isEmpty");
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException("lastIndexOf");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("removeRange");
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("size");
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("toArray");
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException("toArray");
    }

    @Override
    public void trimToSize() {
        throw new UnsupportedOperationException("trimToSize");
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("containsAll");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("removeAll");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll");
    }

    @Override
    public String toString() {
        return "DeferredEntityList";
    }
}

