/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.dao;

import java.util.ArrayList;
import java.util.Collection;
import nablarch.common.dao.Pagination;
import nablarch.core.util.annotation.Published;

@Published
public class EntityList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 1L;
    private Pagination pagination;

    public EntityList() {
    }

    public EntityList(int initCapacity) {
        super(initCapacity);
    }

    public EntityList(Collection<? extends E> collection) {
        super(collection);
    }

    protected void setPage(long page) {
        this.initPagination();
        this.pagination.setPageNumber((int)page);
    }

    protected void setMax(long max) {
        this.initPagination();
        this.pagination.setMax((int)max);
    }

    protected void setResultCount(long resultCount) {
        this.initPagination();
        this.pagination.setResultCount((int)resultCount);
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    private void initPagination() {
        if (this.pagination == null) {
            this.pagination = new Pagination();
        }
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException("add");
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException("addAll");
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException("set");
    }
}

