/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.dao;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Table;
import nablarch.common.dao.ColumnMeta;
import nablarch.common.dao.DatabaseUtil;
import nablarch.common.dao.FieldBasedJpaAnnotationParamFactory;
import nablarch.common.dao.GetterBasedJpaAnnotationParamFactory;
import nablarch.common.dao.IllegalEntityException;
import nablarch.common.dao.JpaAnnotationParam;
import nablarch.common.dao.JpaAnnotationParamFactory;
import nablarch.common.dao.NamingConversionUtil;
import nablarch.core.beans.BeanUtil;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;

@Published(tag={"architect"})
public class EntityMeta {
    private final String tableName;
    private final String schemaName;
    private final List<ColumnMeta> columnMetaList;
    private final List<ColumnMeta> idColumns;
    private final ColumnMeta versionColumn;
    private final ColumnMeta generatedValueColumn;
    private boolean enableFindById = true;

    public EntityMeta(Class<?> entityClass) {
        Access access = entityClass.getAnnotation(Access.class);
        JpaAnnotationParamFactory jpaAnnotationParamFactory = access != null && access.value() == AccessType.FIELD ? new FieldBasedJpaAnnotationParamFactory() : new GetterBasedJpaAnnotationParamFactory();
        this.tableName = EntityMeta.findTableName(entityClass);
        this.schemaName = EntityMeta.findSchemaName(entityClass);
        PropertyDescriptor[] propertyDescriptors = BeanUtil.getPropertyDescriptors(entityClass);
        this.columnMetaList = new ArrayList<ColumnMeta>(propertyDescriptors.length);
        this.idColumns = new ArrayList<ColumnMeta>(propertyDescriptors.length);
        ColumnMeta tempVersionColumn = null;
        ColumnMeta tempGeneratedValueColumn = null;
        for (PropertyDescriptor pd : propertyDescriptors) {
            JpaAnnotationParam jpaAnnotationParam = jpaAnnotationParamFactory.create(this.tableName, pd, entityClass);
            if (jpaAnnotationParam.isJoinColumn()) continue;
            ColumnMeta meta = new ColumnMeta(this, jpaAnnotationParam);
            if (!meta.isTransient()) {
                this.columnMetaList.add(meta);
            }
            if (meta.isIdColumn()) {
                this.idColumns.add(meta);
            }
            if (meta.isVersion()) {
                if (tempVersionColumn != null) {
                    throw new IllegalEntityException("version column must be single definition. class name = " + entityClass.getName());
                }
                tempVersionColumn = meta;
            }
            if (!meta.isGeneratedValue()) continue;
            if (tempGeneratedValueColumn != null) {
                throw new IllegalEntityException("Generated value column must be single definition. class name = " + entityClass.getName());
            }
            tempGeneratedValueColumn = meta;
        }
        this.versionColumn = tempVersionColumn;
        this.generatedValueColumn = tempGeneratedValueColumn;
        try {
            this.sortIdColumns();
        }
        catch (RuntimeException e) {
            this.enableFindById = false;
        }
    }

    private static String findTableName(Class<?> entityClass) {
        Table table = entityClass.getAnnotation(Table.class);
        if (table != null && StringUtil.hasValue((String)table.name())) {
            return table.name();
        }
        return NamingConversionUtil.deCamelize(entityClass.getSimpleName());
    }

    private static String findSchemaName(Class<?> entityClass) {
        Table table = entityClass.getAnnotation(Table.class);
        if (table == null) {
            return null;
        }
        String schema = table.schema();
        return StringUtil.isNullOrEmpty((String)schema) ? null : schema;
    }

    public List<ColumnMeta> getIdColumns() {
        return new ArrayList<ColumnMeta>(this.idColumns);
    }

    public List<ColumnMeta> getAllColumns() {
        return new ArrayList<ColumnMeta>(this.columnMetaList);
    }

    public ColumnMeta getVersionColumn() {
        return this.versionColumn;
    }

    public ColumnMeta getGeneratedValueColumn() {
        return this.generatedValueColumn;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public boolean canFindById() {
        return this.enableFindById;
    }

    protected void sortIdColumns() {
        final Map<String, Short> primaryKeyOrder = DatabaseUtil.getPrimaryKey(this.tableName);
        Collections.sort(this.idColumns, new Comparator<ColumnMeta>(){

            @Override
            public int compare(ColumnMeta cm1, ColumnMeta cm2) {
                return (Short)primaryKeyOrder.get(cm1.getName().toUpperCase()) - (Short)primaryKeyOrder.get(cm2.getName().toUpperCase());
            }
        });
    }

    public boolean equals(Object another) {
        if (another == null || !(another instanceof EntityMeta)) {
            return false;
        }
        EntityMeta anotherMeta = (EntityMeta)EntityMeta.class.cast(another);
        return this.tableName.equals(anotherMeta.tableName);
    }

    public int hashCode() {
        return this.tableName.hashCode();
    }
}

